<?php
$host = 'mysql4.ouiheberg.com';
$dbname = 's9104_peerkinton';
$username = 'u9104_v7kuXn4gCe';
$password = '.72c0PS3NYY+g=JnY8E=vuA3';


try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    $users = $pdo->query("SELECT * FROM users")->fetchAll(PDO::FETCH_ASSOC);
    $transactions = $pdo->query("SELECT t.*, 
        u1.firstname as sender_firstname, u1.lastname as sender_lastname,
        u2.firstname as recipient_firstname, u2.lastname as recipient_lastname
        FROM transactions t 
        LEFT JOIN users u1 ON t.sender_id = u1.userid
        LEFT JOIN users u2 ON t.recipient_id = u2.userid 
        ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
    
    $suspicious = [];
    $total_suspicious = 0;
    $blocked_accounts = 0;
    $total_balance = 0;
    
    foreach($transactions as $trans) {
        if($trans['amount'] >= 500000) {
            $suspicious[] = $trans;
            $total_suspicious += $trans['amount'];
        }
    }
    
    foreach($users as $user) {
        if($user['blocked_account'] == 'true') $blocked_accounts++;
        $total_balance += $user['balance'];
    }
    
} catch(PDOException $e) {
    die("Erreur connexion: " . $e->getMessage());
}

function getTimeAgo($datetime) {
    $time = strtotime($datetime);
    $time_diff = time() - $time;
    
    if($time_diff < 60) return "Il y a quelques secondes";
    else if($time_diff < 3600) return "Il y a " . floor($time_diff/60) . " minutes";
    else if($time_diff < 86400) return "Il y a " . floor($time_diff/3600) . " heures";
    else return "Le " . date('d/m/Y à H:i', $time);
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMATORS BANK - Système de Surveillance</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-gray-50 font-[Inter]">
    <nav class="bg-gradient-to-r from-blue-900 to-blue-800 text-white">
        <div class="container mx-auto px-6 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <svg class="h-8 w-8 mr-3" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    <div class="text-2xl font-bold">IMATORS BANK</div>
                </div>
                <div class="text-sm">
                    Système de Surveillance Bancaire
                </div>
            </div>
        </div>
    </nav>

    <div class="container mx-auto px-6 py-8">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center">
                    <div class="rounded-full bg-green-100 p-3">
                        <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-sm font-semibold text-gray-500">Balance Totale</h3>
                        <p class="text-lg font-bold"><?= number_format($total_balance, 2) ?> €</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center">
                    <div class="rounded-full bg-red-100 p-3">
                        <svg class="h-6 w-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-sm font-semibold text-gray-500">Transactions Suspectes</h3>
                        <p class="text-lg font-bold"><?= count($suspicious) ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center">
                    <div class="rounded-full bg-yellow-100 p-3">
                        <svg class="h-6 w-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-sm font-semibold text-gray-500">Comptes Bloqués</h3>
                        <p class="text-lg font-bold"><?= $blocked_accounts ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center">
                    <div class="rounded-full bg-blue-100 p-3">
                        <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <h3 class="text-sm font-semibold text-gray-500">Montant Suspect Total</h3>
                        <p class="text-lg font-bold"><?= number_format($total_suspicious, 2) ?> €</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-2 gap-6">
            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-lg font-bold">Comptes Clients</h2>
                    <div class="flex space-x-2">
                        <input type="text" id="searchClient" placeholder="Rechercher..." class="px-3 py-1 border rounded-lg text-sm">
                        <select id="filterStatus" class="px-3 py-1 border rounded-lg text-sm">
                            <option value="all">Tous les statuts</option>
                            <option value="active">Actifs</option>
                            <option value="blocked">Bloqués</option>
                        </select>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="bg-gray-50 text-gray-600">
                                <th class="p-3 text-left">Client</th>
                                <th class="p-3 text-left">Email</th>
                                <th class="p-3 text-right">Balance</th>
                                <th class="p-3 text-center">Statut</th>
                                <th class="p-3 text-left">Dernière Connexion</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($users as $user): ?>
                            <tr class="border-b hover:bg-gray-50">
                                <td class="p-3">
                                    <div class="font-semibold"><?= $user['firstname'] . ' ' . $user['lastname'] ?></div>
                                    <div class="text-xs text-gray-500">ID: <?= $user['userid'] ?></div>
                                </td>
                                <td class="p-3"><?= $user['email'] ?></td>
                                <td class="p-3 text-right font-medium">
                                    <?= number_format($user['balance'], 2) ?> €
                                </td>
                                <td class="p-3">
                                    <?php if($user['blocked_account'] == 'true'): ?>
                                        <span class="bg-red-100 text-red-800 text-xs px-2 py-1 rounded-full">Bloqué</span>
                                    <?php else: ?>
                                        <span class="bg-green-100 text-green-800 text-xs px-2 py-1 rounded-full">Actif</span>
                                    <?php endif; ?>
                                </td>
                                <td class="p-3 text-gray-500">
                                    <?= getTimeAgo($user['last_login']) ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex justify-between items-center mb-6">
                    <h2 class="text-lg font-bold">Transactions Suspectes</h2>
                    <select class="px-3 py-1 border rounded-lg text-sm">
                        <option>Dernières 24h</option>
                        <option>7 derniers jours</option>
                        <option>30 derniers jours</option>
                    </select>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="bg-gray-50 text-gray-600">
                                <th class="p-3 text-left">Détails</th>
                                <th class="p-3 text-left">De</th>
                                <th class="p-3 text-left">Vers</th>
                                <th class="p-3 text-right">Montant</th>
                                <th class="p-3 text-right">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($suspicious as $trans): ?>
                            <tr class="border-b hover:bg-red-50">
                                <td class="p-3">
                                    <div class="font-semibold">Transaction #<?= $trans['id'] ?></div>
                                    <div class="text-xs text-gray-500"><?= $trans['type'] ?></div>
                                </td>
                                <td class="p-3">
                                    <div class="font-medium"><?= $trans['sender_firstname'] . ' ' . $trans['sender_lastname'] ?></div>
                                    <div class="text-xs text-gray-500">ID: <?= $trans['sender_id'] ?></div>
                                </td>
                                <td class="p-3">
                                    <div class="font-medium"><?= $trans['recipient_firstname'] . ' ' . $trans['recipient_lastname'] ?></div>
                                    <div class="text-xs text-gray-500">ID: <?= $trans['recipient_id'] ?></div>
                                </td>
                                <td class="p-3 text-right font-bold text-red-600">
                                    <?= number_format($trans['amount'], 2) ?> €
                                </td>
                                <td class="p-3 text-right text-gray-500">
                                    <?= getTimeAgo($trans['created_at']) ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script>
    document.getElementById('searchClient').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });

    document.getElementById('filterStatus').addEventListener('change', function(e) {
        const status = e.target.value;
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (status === 'all') {
                row.style.display = '';
                return;
            }
            
            const isBlocked = row.querySelector('.bg-red-100') !== null;
            const isActive = row.querySelector('.bg-green-100') !== null;
            
            if (status === 'blocked' && isBlocked) row.style.display = '';
            else if (status === 'active' && isActive) row.style.display = '';
            else row.style.display = 'none';
        });
    });

    const links = document.querySelectorAll('tbody tr');
    links.forEach(link => {
        link.style.cursor = 'pointer';
        link.addEventListener('click', () => {
            link.classList.add('bg-blue-50');
            setTimeout(() => link.classList.remove('bg-blue-50'), 200);
        });
    });

    </script>
    </body>
    </html>