<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak | Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Assistant:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Assistant', 'ui-sans-serif', 'system-ui']
                    }
                }
            }
        }
    </script>
    <style>
        :root {
            --bg-primary: #ffffff;
            --text-primary: #000000;
            --bg-secondary: #f4f4f4;
            --text-secondary: #333333;
        }
        @media (prefers-color-scheme: dark) {
            :root {
                --bg-primary: #121212;
                --text-primary: #ffffff;
                --bg-secondary: #1e1e1e;
                --text-secondary: #cccccc;
            }
        }
        body {
            background-color: var(--bg-primary);
            color: var(--text-primary);
            transition: background-color 0.3s, color 0.3s;
        }
        .section-marker {
            position: fixed;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 10px;
            z-index: 50;
        }
        .section-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background-color: rgba(128, 128, 128, 0.3);
            transition: all 0.3s ease;
        }
        .section-dot.active {
            width: 12px;
            height: 12px;
            background-color: var(--text-primary);
        }
        @media (max-width: 768px) {
            .section-marker {
                display: none;
            }
        }
        .reveal {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.6s, transform 0.6s;
        }
        .reveal.active {
            opacity: 1;
            transform: translateY(0);
        }
        .masonry-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            grid-gap: 1rem;
        }
        @media (max-width: 768px) {
            .masonry-grid {
                grid-template-columns: 1fr;
            }
        }
        .masonry-item:nth-child(2n) {
            grid-row: span 2;
        }
        .overlay-hover {
            position: relative;
            overflow: hidden;
        }
        .overlay-hover::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(to bottom, transparent 60%, rgba(0,0,0,0.7));
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        .overlay-hover:hover::before {
            opacity: 1;
        }
        .overlay-hover .overlay-content {
            position: absolute;
            bottom: -100%;
            left: 0;
            width: 100%;
            padding: 1rem;
            color: white;
            transition: bottom 0.3s ease;
        }
        .overlay-hover:hover .overlay-content {
            bottom: 0;
        }
    </style>
</head>
<body class="font-sans">
    <div class="section-marker">
        <div class="section-dot" data-section="hero"></div>
        <div class="section-dot" data-section="skills"></div>
        <div class="section-dot" data-section="projects"></div>
        <div class="section-dot" data-section="musicians"></div>
        <div class="section-dot" data-section="movies"></div>
    </div>

    <div class="container mx-auto px-4">
        <section id="hero" class="min-h-screen flex items-center relative py-16">
            <div class="space-y-6 reveal">
                <p class="text-lg text-gray-600 mb-2 tracking-wider uppercase">Izhak Imators</p>
                <h1 class="text-5xl md:text-6xl mb-4 tracking-tight leading-tight">
                    Digital Architect <br>Building Innovative Solutions
                </h1>
                <p class="text-xl max-w-2xl mb-8 text-gray-700">
                    Transforming complex challenges into elegant, user-centric digital experiences through strategic design and cutting-edge technology.
                </p>
                <div class="h-0.5 bg-black opacity-20 w-24"></div>
            </div>
        </section>

        <section id="skills" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Technical Expertise</h2>
            <div class="masonry-grid">
                <div class="masonry-item bg-white dark:bg-[#1e1e1e] p-6 rounded-lg shadow-sm reveal">
                    <h3 class="text-2xl mb-4">Web Development</h3>
                    <ul class="space-y-2">
                        <li>HTML5 & CSS3</li>
                        <li>Responsive Design</li>
                        <li>Tailwind CSS</li>
                    </ul>
                </div>
                <div class="masonry-item bg-white dark:bg-[#1e1e1e] p-6 rounded-lg shadow-sm reveal delay-100">
                    <h3 class="text-2xl mb-4">Backend Technologies</h3>
                    <ul class="space-y-2">
                        <li>PHP</li>
                        <li>MySQL</li>
                        <li>Server-side Rendering</li>
                    </ul>
                </div>
                <div class="masonry-item bg-white dark:bg-[#1e1e1e] p-6 rounded-lg shadow-sm reveal delay-200">
                    <h3 class="text-2xl mb-4">Frontend Frameworks</h3>
                    <ul class="space-y-2">
                        <li>JavaScript</li>
                        <li>Modern Web APIs</li>
                        <li>Single Page Applications</li>
                    </ul>
                </div>
            </div>
        </section>

        <section id="projects" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Selected Projects</h2>
            <div class="masonry-grid">
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/400/300" alt="Project" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl mb-2">Web Platform</h3>
                        <p class="text-sm">Comprehensive web solution</p>
                    </div>
                </div>
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/400/600" alt="Project" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl mb-2">Mobile Application</h3>
                        <p class="text-sm">User-centric mobile app</p>
                    </div>
                </div>
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/400/450" alt="Project" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl mb-2">E-commerce Platform</h3>
                        <p class="text-sm">Scalable online marketplace</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="musicians" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Music Inspiration</h2>
            <div class="masonry-grid">
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/400/300" alt="Musician" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl">Artist Name</h3>
                        <a href="#" class="text-sm text-white hover:underline">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <section id="movies" class="py-16">
            <h2 class="text-4xl mb-8 reveal">Cinematic Favorites</h2>
            <div class="masonry-grid">
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl">Movie Title</h3>
                        <a href="#" class="text-sm text-white hover:underline">Streaming Platform</a>
                    </div>
                </div>
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl">Movie Title</h3>
                        <a href="#" class="text-sm text-white hover:underline">Streaming Platform</a>
                    </div>
                </div>
                <div class="masonry-item overlay-hover">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full h-full object-cover">
                    <div class="overlay-content">
                        <h3 class="text-xl">Movie Title</h3>
                        <a href="#" class="text-sm text-white hover:underline">Streaming Platform</a>
                    </div>
                </div>
            </div>
        </section>

        <footer class="py-8 text-center border-t border-gray-100 dark:border-gray-800">
            <p class="text-gray-600 dark:text-gray-400">&copy; 2024 Izhak. All rights reserved.</p>
        </footer>
    </div>

    <script>
        // Reveal and section marker logic
        document.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section');
            const dots = document.querySelectorAll('.section-dot');
            const revealElements = document.querySelectorAll('.reveal');
            
            sections.forEach((section, index) => {
                const rect = section.getBoundingClientRect();
                if (rect.top <= window.innerHeight / 2 && rect.bottom >= window.innerHeight / 2) {
                    dots.forEach(dot => dot.classList.remove('active'));
                    dots[index].classList.add('active');
                }
            });

            revealElements.forEach(element => {
                const elementTop = element.getBoundingClientRect().top;
                const elementBottom = element.getBoundingClientRect().bottom;
                
                if (elementTop < window.innerHeight && elementBottom >= 0) {
                    element.classList.add('active');
                }
            });
        });

        // Activate first dot on page load
        document.querySelector('.section-dot').classList.add('active');
    </script>
</body>
</html>