<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="chemin/vers/ton/favicon.png">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <title>formore</title>
    <meta name="description" content="                    Discover the streaming platform that brings you professionally produced films and series from your favourite video games. Made in the most iconic games like Minecraft, GTA, Roblox, and more.">
    <meta property="og:url" content="https://formore.tv">
    <meta property="og:type" content="website">
    <meta property="og:title" content="formore">
    <meta property="og:description" content="                    Discover the streaming platform that brings you professionally produced films and series from your favourite video games. Made in the most iconic games like Minecraft, GTA, Roblox, and more.">
    <meta property="og:image" content="https://opengraph.b-cdn.net/production/images/5eb18d74-896b-4c96-9a7e-efe031ea0ccd.png?token=QRnrk0kbiUcjbEA6KEYlauFXMKojBIITErv2v5YUipI&height=600&width=1200&expires=33277193497">

    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="formore.tv">
    <meta property="twitter:url" content="https://formore.tv">
    <meta name="twitter:title" content="formore">
    <meta name="twitter:description" content="                    Discover the streaming platform that brings you professionally produced films and series from your favourite video games. Made in the most iconic games like Minecraft, GTA, Roblox, and more.">
    <meta name="twitter:image" content="https://opengraph.b-cdn.net/production/images/5eb18d74-896b-4c96-9a7e-efe031ea0ccd.png?token=QRnrk0kbiUcjbEA6KEYlauFXMKojBIITErv2v5YUipI&height=600&width=1200&expires=33277193497">

    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            overflow: hidden;
        }
        .hero-section {
            min-height: 100vh;
            background-image: url('banner_formore_tv_one.png');
            background-size: cover;
            background-position: center;
            position: relative;
        }
        .gradient-overlay {
            background: linear-gradient(to bottom, rgba(0,0,0,0.3) 0%, rgba(0,0,0,0.7) 70%, rgba(0,0,0,1) 100%);
        }
    </style>
</head>
<body class="text-white">
    <div class="hero-section relative flex flex-col justify-between">
        <div class="gradient-overlay absolute inset-0"></div>
        
        <header class="relative z-10 pt-6 px-6 md:px-12">
            <h1 class="text-4xl md:text-5xl font-semibold tracking-wider">formore</h1>
        </header>
        
        <div class="relative z-10 w-full bg-black bg-opacity-80 pb-10">
            <div class="container mx-auto px-6 md:px-12 py-8">
                <div class="max-w-3xl mx-auto text-center">
                    <p class="text-lg md:text-xl mb-6 text-gray-300">
                    Discover the streaming platform that brings you professionally produced films and series from your favourite video games.
                    </p>
                    <div class="flex flex-col sm:flex-row justify-center space-y-4 sm:space-y-0 sm:space-x-6">
                        <a href="https://idsma.imators.com/auth/formore" class="bg-transparent hover:bg-white hover:text-black border border-white font-medium py-3 px-8 rounded-full transition duration-300">
                            Login
                        </a>
                        <a href="https://idsma.imators.com/register" class="bg-white text-black font-medium py-3 px-8 rounded-full transition duration-300">
                            Sign up
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>