<!DOCTYPE html>
<html lang="fr" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>En-tête - Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

        :root {
            --primary-color: #3B82F6;
            --secondary-color: #10B981;
        }

        body {
            font-family: 'Inter', sans-serif;
            color: #FFFFFF;
            background-color: #111827;
        }

        .header {
            background-color: rgba(0, 0, 0, 0.8);
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
            z-index: 1002;
        }

        .hamburger {
            width: 30px;
            height: 20px;
            position: relative;
            cursor: pointer;
            z-index: 1003;
        }

        .hamburger span {
            display: block;
            position: absolute;
            height: 3px;
            width: 100%;
            background: #FFFFFF;
            border-radius: 9px;
            opacity: 1;
            left: 0;
            transform: rotate(0deg);
            transition: .25s ease-in-out;
        }

        .hamburger span:nth-child(1) {
            top: 0px;
        }

        .hamburger span:nth-child(2) {
            top: 10px;
        }

        .hamburger.open span:nth-child(1) {
            top: 10px;
            transform: rotate(135deg);
        }

        .hamburger.open span:nth-child(2) {
            top: 10px;
            transform: rotate(-135deg);
        }

        .menu {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.95);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease-in-out;
            z-index: 1001;
            padding-top: 64px;
        }

        .menu.active {
            opacity: 1;
            visibility: visible;
        }

        .menu-item {
            margin: 10px 0;
            font-size: 28px;
            cursor: pointer;
            color: #FFFFFF;
            transition: all 0.3s ease;
            position: relative;
        }

        .menu-item:hover {
            color: var(--primary-color);
        }

        .menu-item::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -5px;
            left: 50%;
            background-color: var(--primary-color);
            transition: all 0.3s ease;
        }

        .menu-item:hover::after {
            width: 100%;
            left: 0;
        }

        .submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s cubic-bezier(0, 1, 0, 1);
            opacity: 0;
        }

        .submenu.active {
            max-height: 1000px;
            transition: max-height 1s ease-in-out, opacity 0.5s ease-in-out;
            opacity: 1;
        }

        .submenu a {
            display: block;
            padding: 8px 0;
            font-size: 20px;
            color: #FFFFFF;
            text-decoration: none;
            transition: all 0.3s ease;
            opacity: 0;
            transform: translateY(20px);
        }

        .submenu.active a {
            opacity: 1;
            transform: translateY(0);
            transition: opacity 0.5s ease-in-out, transform 0.5s ease-in-out;
        }

        .submenu a:hover {
            color: var(--primary-color);
            transform: translateX(5px);
        }

        .dropdown {
            position: relative;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: #1a1a1a;
            min-width: 160px;
            box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
            z-index: 1;
            border-radius: 8px;
            overflow: hidden;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content a {
            color: #fff;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            transition: all 0.3s ease;
        }

        .dropdown-content a:hover {
            background-color: #575757;
            transform: translateX(5px);
        }

        html {
            scroll-behavior: smooth;
        }
    </style>
</head>
<body class="h-full">

<header class="header fixed w-full top-0">
    <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <div class="flex-shrink-0 flex items-center">
                <a href="/" class="flex items-center">
                    <img class="h-8 w-auto" src="https://cdn.imators.com/logo.png" alt="Logo Imators">
                </a>
            </div>
            <div class="flex items-center space-x-4">
                <a href="https://auth.imators.com" class="bg-gradient-to-r from-primary-color to-secondary-color text-white px-4 py-2 rounded-full text-sm font-medium transition-all duration-300 ease-in-out transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-color">
                    Compte Imators
                </a>
                <div class="relative dropdown">
                    <button id="language-button" class="bg-white text-black text-sm p-2 rounded-full shadow hover:bg-gray-100 transition-all">
                        FR
                    </button>
                    <div class="dropdown-content">
                        <a href="/fr" class="text-sm hover:bg-gray-700 transition">Français</a>
                        <a href="/nl" class="text-sm hover:bg-gray-700 transition">Nederlands</a>
                        <a href="/de" class="text-sm hover:bg-gray-700 transition">Deutsch</a>
                        <a href="/en" class="text-sm hover:bg-gray-700 transition">English</a>
                    </div>
                </div>
                <button id="hamburger" class="hamburger" aria-label="Ouvrir le menu">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </nav>
</header>

<div id="menu" class="menu">
    <div class="menu-item" data-submenu="products">Produits</div>
    <div class="submenu" id="products">
        <a href="/progm">Progm</a>
        <a href="https://ohmypanel.com">OhMyPanel</a>
        <a href="https://owtiftt.com">Owtfitt</a>
        <a href="https://formore.tv">ForMore</a>
        <a href="https://gemance.com">Gemance</a>
    </div>
    <div class="menu-item" data-submenu="dev-tools">Outils Développeur</div>
    <div class="submenu" id="dev-tools">
        <a href="https://imators.systems">Systèmes Imators</a>
        <a href="https://developer.imators.com">Développeur Imators</a>
    </div>
    <div class="menu-item" data-submenu="company">L'Entreprise</div>
    <div class="submenu" id="company">
        <a href="/about-us">Histoire d'Imators</a>
        <a href="/contact-us">Support Client</a>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const hamburger = document.getElementById('hamburger');
        const menu = document.getElementById('menu');
        const header = document.querySelector('.header');
        const menuItems = document.querySelectorAll('.menu-item');
        const submenus = document.querySelectorAll('.submenu');

        hamburger.addEventListener('click', function() {
            this.classList.toggle('open');
            menu.classList.toggle('active');
            document.body.style.overflow = menu.classList.contains('active') ? 'hidden' : '';
        });

        menuItems.forEach(item => {
            item.addEventListener('click', function() {
                const submenuId = this.getAttribute('data-submenu');
                const submenu = document.getElementById(submenuId);
                
                if (submenu.classList.contains('active')) {
                    submenu.classList.remove('active');
                    setTimeout(() => {
                        submenu.style.display = 'none';
                    }, 500);
                } else {
                    submenus.forEach(sub => {
                        if (sub !== submenu) {
                            sub.classList.remove('active');
                            setTimeout(() => {
                                sub.style.display = 'none';
                            }, 500);
                        }
                    });
                    submenu.style.display = 'block';
                    setTimeout(() => {
                        submenu.classList.add('active');
                    }, 10);
                }
            });
        });

        // Effet de défilement
        let lastScrollTop = 0;
        const scrollThreshold = 50;

        window.addEventListener('scroll', () => {
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            if (scrollTop > 0) {
                header.style.backgroundColor = 'rgba(0, 0, 0, 0.9)';
            } else {
                header.style.backgroundColor = 'rgba(0, 0, 0, 0.8)';
            }

            if (Math.abs(scrollTop - lastScrollTop) > scrollThreshold) {
                if (scrollTop > lastScrollTop && scrollTop > header.offsetHeight) {
                    header.style.transform = 'translateY(-100%)';
                } else {
                    header.style.transform = 'translateY(0)';
                }
                lastScrollTop = scrollTop;
            }
        }, { passive: true });

        // Bouton de langue
        async function setLanguageButtonText() {
            try {
                const response = await fetch('https://ipinfo.io?token=5763340b2576b8');
                const data = await response.json();
                const country = data.country;

                const languageButton = document.getElementById('language-button');
                switch (country) {
                    case 'FR':
                        languageButton.innerText = 'FR';
                        break;
                    case 'BE':
                        languageButton.innerText = 'BE';
                        break;
                    case 'NL':
                        languageButton.innerText = 'NL';
                        break;
                    case 'DE':
                        languageButton.innerText = 'DE';
                        break;
                    default:
                        languageButton.innerText = 'EN';
                }
            } catch (error) {
                console.error('Erreur lors de la récupération des données de localisation:', error);
            }
        }

        setLanguageButtonText();
    });
</script>
</body>
</html>