<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hizhat - Book my vacation</title>
    <link href="https://fonts.googleapis.com/css2?family=Lexend+Tera:wght@100;200;300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        * {
            font-family: 'Lexend Tera', sans-serif;
        }

        .hero {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .line {
            height: 1px;
            background: #dedede;
        }
        
        .form-container {
            border: 1px solid #dedede;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        
        .form-container:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
        
        .tab-active {
            border-bottom: 2px solid #000;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="hero p-8">
        <header>
            <div class="flex items-center justify-center gap-6">
                <div class="line flex-1"></div>
                <h1 class="text-2xl font-light px-6">Hizhat</h1>
                <div class="line flex-1"></div>
            </div>
        </header>

        <main class="flex flex-col items-center justify-center gap-8 my-12">
            <h2 class="text-2xl md:text-3xl font-light text-center">Book your dream vacation</h2>
            
            <div class="form-container bg-white p-6 w-full max-w-3xl">
                <div class="flex border-b mb-6">
                    <button id="tab-flight" class="px-4 py-2 text-sm tab-active">Flight</button>
                    <button id="tab-hotel" class="px-4 py-2 text-sm">Hotel</button>
                    <button id="tab-train" class="px-4 py-2 text-sm">Train</button>
                    <button id="tab-combined" class="px-4 py-2 text-sm">Combined</button>
                </div>
                
                <div id="flight-form" class="tab-content">
                    <form action="process_booking.php" method="POST">
                        <input type="hidden" name="booking_type" value="flight">
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">From</label>
                                <input type="text" name="origin" class="w-full p-2 border rounded text-sm" placeholder="City or Airport" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">To</label>
                                <input type="text" name="destination" class="w-full p-2 border rounded text-sm" placeholder="City or Airport" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Departure</label>
                                <input type="date" name="departure_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Return</label>
                                <input type="date" name="return_date" class="w-full p-2 border rounded text-sm">
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/3 px-2 mb-4">
                                <label class="block text-xs mb-1">Passengers</label>
                                <select name="passengers" class="w-full p-2 border rounded text-sm">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5+</option>
                                </select>
                            </div>
                            <div class="w-full md:w-2/3 px-2 mb-4">
                                <label class="block text-xs mb-1">Class</label>
                                <select name="class" class="w-full p-2 border rounded text-sm">
                                    <option value="economy">Economy</option>
                                    <option value="premium">Premium Economy</option>
                                    <option value="business">Business</option>
                                    <option value="first">First Class</option>
                                </select>
                            </div>
                        </div>
                        
                        <button type="submit" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300 w-full">
                            Search Flights
                        </button>
                    </form>
                </div>
                
                <div id="hotel-form" class="tab-content hidden">
                    <form action="process_booking.php" method="POST">
                        <input type="hidden" name="booking_type" value="hotel">
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full px-2 mb-4">
                                <label class="block text-xs mb-1">Destination</label>
                                <input type="text" name="destination" class="w-full p-2 border rounded text-sm" placeholder="City or Specific Location" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Check-in</label>
                                <input type="date" name="checkin_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Check-out</label>
                                <input type="date" name="checkout_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Rooms</label>
                                <select name="rooms" class="w-full p-2 border rounded text-sm">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4+</option>
                                </select>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Guests</label>
                                <select name="guests" class="w-full p-2 border rounded text-sm">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5+</option>
                                </select>
                            </div>
                        </div>
                        
                        <button type="submit" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300 w-full">
                            Search Hotels
                        </button>
                    </form>
                </div>
                
                <div id="train-form" class="tab-content hidden">
                    <form action="process_booking.php" method="POST">
                        <input type="hidden" name="booking_type" value="train">
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">From</label>
                                <input type="text" name="origin" class="w-full p-2 border rounded text-sm" placeholder="Departure Station" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">To</label>
                                <input type="text" name="destination" class="w-full p-2 border rounded text-sm" placeholder="Arrival Station" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Departure Date</label>
                                <input type="date" name="departure_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Departure Time</label>
                                <select name="departure_time" class="w-full p-2 border rounded text-sm">
                                    <option value="morning">Morning</option>
                                    <option value="afternoon">Afternoon</option>
                                    <option value="evening">Evening</option>
                                    <option value="night">Night</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Passengers</label>
                                <select name="passengers" class="w-full p-2 border rounded text-sm">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5+</option>
                                </select>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Class</label>
                                <select name="class" class="w-full p-2 border rounded text-sm">
                                    <option value="economy">Standard</option>
                                    <option value="business">First Class</option>
                                </select>
                            </div>
                        </div>
                        
                        <button type="submit" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300 w-full">
                            Search Trains
                        </button>
                    </form>
                </div>
                
                <div id="combined-form" class="tab-content hidden">
                    <form action="process_booking.php" method="POST">
                        <input type="hidden" name="booking_type" value="combined">
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full px-2 mb-4">
                                <label class="block text-xs mb-1">Destination</label>
                                <input type="text" name="destination" class="w-full p-2 border rounded text-sm" placeholder="City or Country" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Start Date</label>
                                <input type="date" name="start_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">End Date</label>
                                <input type="date" name="end_date" class="w-full p-2 border rounded text-sm" required>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Travelers</label>
                                <select name="travelers" class="w-full p-2 border rounded text-sm">
                                    <option value="1">1</option>
                                    <option value="2">2</option>
                                    <option value="3">3</option>
                                    <option value="4">4</option>
                                    <option value="5">5+</option>
                                </select>
                            </div>
                            <div class="w-full md:w-1/2 px-2 mb-4">
                                <label class="block text-xs mb-1">Package Type</label>
                                <select name="package_type" class="w-full p-2 border rounded text-sm">
                                    <option value="flight_hotel">Flight + Hotel</option>
                                    <option value="flight_hotel_car">Flight + Hotel + Car</option>
                                    <option value="train_hotel">Train + Hotel</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap -mx-2 mb-4">
                            <div class="w-full px-2 mb-4">
                                <label class="block text-xs mb-1">Budget</label>
                                <select name="budget" class="w-full p-2 border rounded text-sm">
                                    <option value="economy">Economy</option>
                                    <option value="standard">Standard</option>
                                    <option value="premium">Premium</option>
                                    <option value="luxury">Luxury</option>
                                </select>
                            </div>
                        </div>
                        
                        <button type="submit" class="bg-gray-900 text-white px-8 py-3 rounded-full text-sm hover:bg-gray-800 transition-all duration-300 w-full">
                            Search Vacation Packages
                        </button>
                    </form>
                </div>
            </div>
            
            <p class="text-gray-600 text-sm font-light text-center mt-4">
                Book all your holidays in just five minutes.<br>
                Hotels provided by <a href="#" class="underline">alltophotels.io</a>
            </p>
        </main>

        <footer class="bg-white font-['Poppins'] px-8 mt-12">
            <div class="max-w-5xl mx-auto px-4 py-8 flex flex-wrap justify-between">
                <div class="w-full md:w-1/2 p-5">
                    <h5 class="text-xs uppercase font-medium mb-6">Legal</h5>
                    <a href="https://imators.com/privacy" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Privacy Policy</a>
                    <a href="https://imators.com/terms-of-use" class="my-3 block hover:text-gray-600 text-sm font-medium duration-700">Terms of Use</a>
                </div>
                <div class="w-full md:w-1/2 p-5">
                    <h5 class="text-xs uppercase font-medium mb-6">About</h5>
                    <p class="text-sm">Hizhat is a member of Imators Group.</p>
                </div>
            </div>
            <div class="text-center py-4 border-t border-gray-200">
                <p class="text-sm mb-2">&copy; 2025 Imators. All rights reserved.</p>
                <p class="text-xs">Imators is a registered LLC (Limited Liability Company). All our products are subject to our rules.</p>
            </div>
        </footer>
    </div>

    <script>
        // Tab switching functionality
        const tabs = ['flight', 'hotel', 'train', 'combined'];
        
        tabs.forEach(tab => {
            document.getElementById(`tab-${tab}`).addEventListener('click', () => {
                // Handle tab styling
                tabs.forEach(t => {
                    document.getElementById(`tab-${t}`).classList.remove('tab-active');
                    document.getElementById(`${t}-form`).classList.add('hidden');
                });
                
                document.getElementById(`tab-${tab}`).classList.add('tab-active');
                document.getElementById(`${tab}-form`).classList.remove('hidden');
            });
        });
    </script>
</body>
</html>