<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/auth', function() {
    $token = request('token');
    $expires = request('expires');
    $signature = request('signature');
    
    if (!$token || !$expires || !$signature) {
        return redirect('/')->with('error', 'Paramètres manquants');
    }
    
    if (time() > $expires) {
        return redirect('/')->with('error', 'Lien expiré');
    }
    
    $expectedSignature = hash_hmac('sha256', $token . $expires, '1MZEEO92K55S1LFKEG0NMVA6JHJTNJ54');
    
    if (!hash_equals($expectedSignature, $signature)) {
        return redirect('/')->with('error', 'Signature invalide');
    }
    
    $data = json_decode(base64_decode($token), true);
    
    if (!$data || !isset($data['user_id']) || !isset($data['ise_auth'])) {
        return redirect('/')->with('error', 'Token invalide');
    }
    
    session([
        'user_id' => $data['user_id'],
        'email' => $data['email'],
        'username' => $data['username'],
        'authenticated' => true,
        'auth_time' => time()
    ]);
    
    return redirect('/workspace');
});

Route::get('/workspace', function() {
    if (!session('authenticated')) {
        return redirect('/');
    }
    
    if (time() - session('auth_time', 0) > 3600) {
        session()->flush();
        return redirect('/')->with('error', 'Session expirée');
    }
    
    return view('workspace');
})->name('workspace');

Route::get('/logout', function() {
    session()->flush();
    return redirect('/');
});