<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background-color: #000;
            margin: 0;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: #000;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            height: 70px;
            z-index: 100;
            transition: background-color 0.3s ease;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled,
        .header-transparent.panel-open {
            background-color: #000;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
        }

        .logo img {
            height: 28px;
        }

        @media (min-width: 1024px) {
            .logo img {
                height: 36px;
            }
        }

        .nav-menu {
            display: flex;
            gap: 30px;
        }

        @media (max-width: 1023px) {
            .nav-menu {
                display: none;
            }
        }

        .nav-item {
            padding: 10px;
            cursor: pointer;
            font-weight: 300;
        }

        .nav-item:hover {
            opacity: 0.7;
        }

        .category-panel {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background-color: #000;
            z-index: 200;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0s linear 0.3s;
        }

        .category-panel.active {
            opacity: 1;
            visibility: visible;
            transition: opacity 0.3s ease, visibility 0s linear;
        }

        .category-header {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            padding: 0 20px;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 202;
            background-color: #000 !important;
        }

        @media (min-width: 1024px) {
            .category-header {
                height: 90px;
            }
        }

        .panel-container {
            width: 100%;
            max-width: 400px;
            padding: 40px 0;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: center;
        }

        .close-panel {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            background: transparent;
            border: none;
            padding: 0;
        }

        .close-panel svg {
            width: 24px;
            height: 24px;
            stroke: #fff;
            stroke-width: 1.5;
        }

        .links-list {
            list-style: none;
            padding: 0;
            margin: 0 auto;
            text-align: left;
            width: 200px;
        }

        .links-list li {
            margin-bottom: 20px;
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.3s ease, transform 0.3s ease;
        }

        .category-panel.active .links-list li {
            opacity: 1;
            transform: translateY(0);
        }

        .category-panel.active .links-list li:nth-child(1) {
            transition-delay: 0.1s;
        }

        .category-panel.active .links-list li:nth-child(2) {
            transition-delay: 0.15s;
        }

        .category-panel.active .links-list li:nth-child(3) {
            transition-delay: 0.2s;
        }

        .category-panel.active .links-list li:nth-child(4) {
            transition-delay: 0.25s;
        }

        .category-panel.active .links-list li:nth-child(5) {
            transition-delay: 0.3s;
        }

        .category-link {
            display: inline-block;
            font-size: 1.1rem;
            font-weight: 300;
            padding: 8px 0;
            color: #fff;
            transition: opacity 0.2s ease;
        }

        .category-link:hover {
            opacity: 0.7;
        }

        .account-btn {
            padding: 8px 16px;
            background: #fff;
            color: #000;
            border-radius: 6px;
            font-weight: 500;
            transition: opacity 0.2s ease;
            margin-left: 20px;
            display: block;
        }

        .account-btn:hover {
            opacity: 0.9;
        }

        @media (max-width: 767px) {
            .account-btn {
                display: none;
            }
        }

        .menu-toggle {
            width: 30px;
            height: 30px;
            display: none;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            background: transparent;
            border: none;
            padding: 0;
        }

        @media (max-width: 1023px) {
            .menu-toggle {
                display: flex;
            }
        }

        .menu-toggle span {
            display: block;
            width: 24px;
            height: 1px;
            background: #fff;
            position: relative;
        }

        .menu-toggle span::before {
            content: '';
            position: absolute;
            width: 24px;
            height: 1px;
            background: #fff;
            top: -8px;
            left: 0;
        }

        .menu-toggle.active span {
            display: none;
        }

        .menu-toggle.active::before,
        .menu-toggle.active::after {
            content: '';
            position: absolute;
            width: 24px;
            height: 1px;
            background: #fff;
        }

        .menu-toggle.active::before {
            transform: rotate(45deg);
        }

        .menu-toggle.active::after {
            transform: rotate(-45deg);
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            z-index: 99;
            transform: translateY(-100%);
            visibility: hidden;
            opacity: 0;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: center;
            padding-left: 30px;
            transition: transform 0.3s ease, opacity 0.3s ease, visibility 0s linear 0.3s;
        }

        .mobile-menu.active {
            transform: translateY(0);
            visibility: visible;
            opacity: 1;
            transition: transform 0.3s ease, opacity 0.3s ease, visibility 0s linear;
        }

        .mobile-nav {
            width: 100%;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: center;
        }

        .mobile-nav-item {
            margin-bottom: 25px;
            padding: 10px;
            font-size: 1.5rem;
            font-weight: 300;
            cursor: pointer;
            text-align: left;
            transition: opacity 0.2s ease;
            opacity: 0;
            transform: translateY(10px);
        }

        .mobile-menu.active .mobile-nav-item {
            opacity: 1;
            transform: translateY(0);
            transition: opacity 0.3s ease, transform 0.3s ease;
        }

        .mobile-menu.active .mobile-nav-item:nth-child(1) {
            transition-delay: 0.1s;
        }

        .mobile-menu.active .mobile-nav-item:nth-child(2) {
            transition-delay: 0.15s;
        }

        .mobile-menu.active .mobile-nav-item:nth-child(3) {
            transition-delay: 0.2s;
        }

        .mobile-menu.active .mobile-nav-item:nth-child(4) {
            transition-delay: 0.25s;
        }

        .mobile-nav-item:active {
            opacity: 0.7;
        }

        .mobile-account-btn {
            margin-top: 20px;
            padding: 12px 24px;
            background: #fff;
            color: #000;
            border-radius: 6px;
            font-weight: 500;
            transition: opacity 0.2s ease;
            align-self: flex-start;
            opacity: 0;
            transform: translateY(10px);
        }

        .mobile-menu.active .mobile-account-btn {
            opacity: 1;
            transform: translateY(0);
            transition: opacity 0.3s ease, transform 0.3s ease;
            transition-delay: 0.3s;
        }

        .mobile-account-btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body class="h-full">
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="header-container">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>

            <div class="flex items-center">
                <nav class="nav-menu">
                    <div class="nav-item" data-category="products">Products</div>
                    <div class="nav-item" data-category="developer">Developer Tools</div>
                    <div class="nav-item" data-category="company">Company</div>
                </nav>
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <div class="menu-toggle">
                    <span></span>
                </div>
            </div>
        </div>
    </header>

    <div class="category-panel" id="products-panel">
        <div class="category-header" style="background-color: #000 !important;">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        </div>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="https://academ.my" class="category-link">Academ</a></li>
                <li><a href="https://ohmypanel.com" class="category-link">OhMyPanel</a></li>
                <li><a href="/traffic/" class="category-link">Traffic's</a></li>
            </ul>
        </div>
    </div>

    <div class="category-panel" id="developer-panel">
        <div class="category-header" style="background-color: #000 !important;">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        </div>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="https://imators.systems" class="category-link">Imators Systems</a></li>
                <li><a href="https://developer.imators.com" class="category-link">Imators Developer</a></li>
                <li><a href="/traffic" class="category-link">TrafficLight API</a></li>
            </ul>
        </div>
    </div>

    <div class="category-panel" id="company-panel">
        <div class="category-header" style="background-color: #000 !important;">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>
            <button class="close-panel">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                    <line x1="18" y1="6" x2="6" y2="18"></line>
                    <line x1="6" y1="6" x2="18" y2="18"></line>
                </svg>
            </button>
        </div>
        <div class="panel-container">
            <ul class="links-list">
                <li><a href="/support" class="category-link">Support</a></li>
                <li><a href="/contact-us" class="category-link">Contact us</a></li>
                <li><a href="/about-us" class="category-link">About Imators</a></li>
            </ul>
        </div>
    </div>

    <div class="mobile-menu">
        <div class="mobile-nav">
            <div class="mobile-nav-item" data-category="products">Products</div>
            <div class="mobile-nav-item" data-category="developer">Developer Tools</div>
            <div class="mobile-nav-item" data-category="company">Company</div>
            <a href="https://idsma.imators.com" class="mobile-account-btn">Imators Account</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const header = document.querySelector('.header');
            const menuToggle = document.querySelector('.menu-toggle');
            const mobileMenu = document.querySelector('.mobile-menu');
            const navItems = document.querySelectorAll('.nav-item');
            const mobileNavItems = document.querySelectorAll('.mobile-nav-item');
            const categoryPanels = document.querySelectorAll('.category-panel');
            const closePanelButtons = document.querySelectorAll('.close-panel');
            const categoryHeaders = document.querySelectorAll('.category-header');
            
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeCategoryPanel = null;
            
            function openCategoryPanel(category) {
                const panel = document.getElementById(category + '-panel');
                
                if (panel) {
                    if (activeCategoryPanel && activeCategoryPanel !== panel) {
                        activeCategoryPanel.classList.remove('active');
                    }
                    
                    panel.classList.add('active');
                    activeCategoryPanel = panel;
                    document.body.style.overflow = 'hidden';
                    
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                    }
                    
                    categoryHeaders.forEach(header => {
                        header.style.backgroundColor = '#000';
                    });
                    
                    if (header.classList.contains('header-transparent')) {
                        header.classList.add('panel-open');
                    }
                }
            }
            
            function closeCategoryPanel() {
                if (activeCategoryPanel) {
                    activeCategoryPanel.classList.remove('active');
                    activeCategoryPanel = null;
                    document.body.style.overflow = '';
                    
                    if (header.classList.contains('header-transparent')) {
                        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                        if (scrollTop === 0) {
                            header.classList.remove('panel-open');
                        }
                    }
                }
            }
            
            navItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            mobileNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    const category = this.getAttribute('data-category');
                    openCategoryPanel(category);
                });
            });
            
            closePanelButtons.forEach(button => {
                button.addEventListener('click', closeCategoryPanel);
            });
            
            menuToggle.addEventListener('click', function() {
                this.classList.toggle('active');
                mobileMenu.classList.toggle('active');
                
                if (mobileMenu.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                    
                    if (header.classList.contains('header-transparent')) {
                        header.classList.add('panel-open');
                    }
                } else {
                    document.body.style.overflow = '';
                    
                    if (header.classList.contains('header-transparent')) {
                        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                        if (scrollTop === 0) {
                            header.classList.remove('panel-open');
                        }
                    }
                }
            });
            
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    if (activeCategoryPanel) {
                        closeCategoryPanel();
                    }
                    
                    if (mobileMenu.classList.contains('active')) {
                        mobileMenu.classList.remove('active');
                        menuToggle.classList.remove('active');
                        document.body.style.overflow = '';
                        
                        if (header.classList.contains('header-transparent')) {
                            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                            if (scrollTop === 0) {
                                header.classList.remove('panel-open');
                            }
                        }
                    }
                }
            });
            
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                if (!mobileMenu.classList.contains('active') && !activeCategoryPanel && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });
            
            categoryPanels.forEach(panel => {
                panel.addEventListener('click', function(e) {
                    if (e.target === this) {
                        closeCategoryPanel();
                    }
                });
            });
        });
    </script>
</body>
</html>