<?php
$transparent_header = isset($transparent_header) ? $transparent_header : false;
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            color: #fff;
            background-color: #000;
            margin: 0;
        }

        .header {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            height: 70px;
            z-index: 100;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .header {
                height: 90px;
            }
        }

        .header-transparent {
            background-color: transparent;
            border-bottom: none;
        }

        .header-transparent.scrolled {
            background-color: rgba(0, 0, 0, 0.95);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
        }

        .logo img {
            height: 28px;
            transition: all 0.3s ease;
        }

        @media (min-width: 1024px) {
            .logo img {
                height: 36px;
            }
        }
        
        /* Desktop Menu */
        .desktop-menu {
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
                gap: 30px;
            }

            .menu-item {
                position: relative;
                padding: 10px;
                cursor: pointer;
                font-weight: 400;
            }

            .menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
            }
        }

        /* Mega Menu */
        .mega-menu-backdrop {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background-color: rgba(0, 0, 0, 0.7);
            backdrop-filter: blur(10px);
            z-index: 99;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }

        .mega-menu {
            position: fixed;
            top: 90px;
            left: 0;
            width: 100%;
            background-color: rgb(10, 10, 10);
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            z-index: 99;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-20px);
            transition: all 0.3s ease;
            max-height: 0;
            overflow: hidden;
        }

        .mega-menu-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
            display: flex;
        }

        .mega-menu-links {
            flex: 1;
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
        }

        .mega-menu-link {
            display: block;
            padding: 15px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            transition: all 0.2s ease;
        }

        .mega-menu-link:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }

        .mega-menu-title {
            font-weight: 500;
            margin-bottom: 5px;
        }

        .mega-menu-desc {
            font-size: 0.8rem;
            opacity: 0.7;
        }

        .mega-menu-stories {
            width: 300px;
            margin-left: 40px;
            padding-left: 40px;
            border-left: 1px solid rgba(255, 255, 255, 0.1);
        }

        .stories-heading {
            font-size: 1.2rem;
            font-weight: 500;
            margin-bottom: 20px;
        }

        .stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .story-card {
            aspect-ratio: 1/1;
            border-radius: 10px;
            overflow: hidden;
            position: relative;
            background-size: cover;
            background-position: center;
            transition: all 0.3s ease;
        }

        .story-card:hover {
            transform: scale(1.05);
        }

        .story-content {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 15px;
            background: linear-gradient(transparent, rgba(0, 0, 0, 0.8));
        }

        .story-title {
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .story-desc {
            font-size: 0.8rem;
            opacity: 0.8;
        }

        .account-btn {
            display: none;
            padding: 8px 16px;
            background: #fff;
            color: #000;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        @media (min-width: 1024px) {
            .account-btn {
                display: inline-block;
            }
        }

        .account-btn:hover {
            opacity: 0.9;
        }

        /* Mobile Menu */
        .mobile-toggle {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            position: relative;
        }

        @media (min-width: 1024px) {
            .mobile-toggle {
                display: none;
            }
        }

        .mobile-toggle span {
            display: block;
            width: 18px;
            height: 2px;
            background: #fff;
            position: relative;
            transition: all 0.3s ease;
        }

        .mobile-toggle span::before,
        .mobile-toggle span::after {
            content: '';
            position: absolute;
            width: 18px;
            height: 2px;
            background: #fff;
            transition: all 0.3s ease;
        }

        .mobile-toggle span::before {
            top: -6px;
        }

        .mobile-toggle span::after {
            top: 6px;
        }

        .mobile-toggle.active span {
            background: transparent;
        }

        .mobile-toggle.active span::before {
            transform: rotate(45deg);
            top: 0;
        }

        .mobile-toggle.active span::after {
            transform: rotate(-45deg);
            top: 0;
        }

        .mobile-menu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            z-index: 99;
            transform: translateY(-100%);
            transition: all 0.3s ease;
            visibility: hidden;
            opacity: 0;
            overflow-y: auto;
        }

        .mobile-menu.active {
            transform: translateY(0);
            visibility: visible;
            opacity: 1;
        }

        .mobile-menu-header {
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .mobile-menu-title {
            font-size: 1.2rem;
            font-weight: 500;
        }

        .mobile-stories {
            padding: 20px;
        }

        .mobile-stories-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }

        .mobile-story {
            aspect-ratio: 1/1;
            border-radius: 12px;
            overflow: hidden;
            position: relative;
        }

        .mobile-story-content {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            padding: 15px;
            display: flex;
            flex-direction: column;
            justify-content: flex-end;
            background: linear-gradient(transparent 50%, rgba(0, 0, 0, 0.8));
        }

        .mobile-story-title {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 5px;
        }

        .mobile-story-desc {
            font-size: 0.75rem;
            opacity: 0.8;
            margin-bottom: 10px;
        }

        .mobile-story-btn {
            align-self: flex-start;
            padding: 6px 12px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            font-size: 0.75rem;
            transition: all 0.2s ease;
        }

        .mobile-nav {
            padding: 20px;
        }

        .mobile-nav-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px;
            margin-bottom: 15px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .mobile-nav-item:active {
            background: rgba(255, 255, 255, 0.1);
        }

        .mobile-submenu {
            position: fixed;
            top: 70px;
            left: 0;
            width: 100%;
            height: calc(100vh - 70px);
            background: #000;
            z-index: 100;
            transform: translateX(100%);
            transition: all 0.3s ease;
            visibility: hidden;
            opacity: 0;
            overflow-y: auto;
        }

        .mobile-submenu.active {
            transform: translateX(0);
            visibility: visible;
            opacity: 1;
        }

        .mobile-submenu-header {
            display: flex;
            align-items: center;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .back-btn {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            margin-right: 15px;
        }

        .mobile-submenu-title {
            font-size: 1.1rem;
            font-weight: 500;
        }

        .mobile-submenu-links {
            padding: 20px;
        }

        .mobile-submenu-link {
            display: block;
            padding: 15px;
            margin-bottom: 15px;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            transition: all 0.2s ease;
        }

        .mobile-submenu-link:active {
            background: rgba(255, 255, 255, 0.1);
        }
    </style>
</head>
<body class="h-full">
    <!-- Header -->
    <header class="header <?php echo $transparent_header ? 'header-transparent' : ''; ?>">
        <div class="header-container">
            <div class="logo">
                <a href="/">
                    <img src="https://cdn.imators.com/logo.png" alt="Imators">
                </a>
            </div>

            <nav class="desktop-menu">
                <div class="menu-item" data-menu="products">Products</div>
                <div class="menu-item" data-menu="developer">Developer Tools</div>
                <div class="menu-item" data-menu="company">Company</div>
            </nav>

            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="account-btn">Imators Account</a>
                <div class="mobile-toggle">
                    <span></span>
                </div>
            </div>
        </div>
    </header>

    <!-- Mega Menu Backdrops -->
    <div class="mega-menu-backdrop" id="products-backdrop"></div>
    <div class="mega-menu-backdrop" id="developer-backdrop"></div>
    <div class="mega-menu-backdrop" id="company-backdrop"></div>

    <!-- Mega Menus -->
    <div class="mega-menu" id="products-menu">
        <div class="mega-menu-container">
            <div class="mega-menu-links">
                <a href="https://academ.my" class="mega-menu-link">
                    <div class="mega-menu-title">Academ</div>
                    <div class="mega-menu-desc">Say goodbye to homework overflow</div>
                </a>
                <a href="/progm" class="mega-menu-link">
                    <div class="mega-menu-title">Progm</div>
                    <div class="mega-menu-desc">Program management simplified</div>
                </a>
                <a href="https://ohmypanel.com" class="mega-menu-link">
                    <div class="mega-menu-title">OhMyPanel</div>
                    <div class="mega-menu-desc">Quick & easy shopping</div>
                </a>
                <a href="https://owtfitt.com" class="mega-menu-link">
                    <div class="mega-menu-title">Owtfitt</div>
                    <div class="mega-menu-desc">Premium fashion outfits</div>
                </a>
                <a href="https://imators.systems/traffic" class="mega-menu-link">
                    <div class="mega-menu-title">TrafficLight</div>
                    <div class="mega-menu-desc">Intelligent traffic management</div>
                </a>
            </div>
            <div class="mega-menu-stories">
                <h3 class="stories-heading">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/story1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Academ Success</h5>
                            <p class="story-desc">See how Academ transforms education</p>
                        </div>
                    </div>
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/story2.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">TrafficLight Impact</h5>
                            <p class="story-desc">Smart traffic solutions</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mega-menu" id="developer-menu">
        <div class="mega-menu-container">
            <div class="mega-menu-links">
                <a href="https://imators.systems" class="mega-menu-link">
                    <div class="mega-menu-title">Imators Systems</div>
                    <div class="mega-menu-desc">Enterprise-grade systems</div>
                </a>
                <a href="https://developer.imators.com" class="mega-menu-link">
                    <div class="mega-menu-title">Imators Developer</div>
                    <div class="mega-menu-desc">Developer resources & APIs</div>
                </a>
                <a href="https://imators.systems/traffic" class="mega-menu-link">
                    <div class="mega-menu-title">TrafficLight</div>
                    <div class="mega-menu-desc">Traffic management API</div>
                </a>
            </div>
            <div class="mega-menu-stories">
                <h3 class="stories-heading">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/dev1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Developer Journey</h5>
                            <p class="story-desc">Building with Imators tools</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mega-menu" id="company-menu">
        <div class="mega-menu-container">
            <div class="mega-menu-links">
                <a href="/support" class="mega-menu-link">
                    <div class="mega-menu-title">Support</div>
                    <div class="mega-menu-desc">Get help with our products</div>
                </a>
                <a href="/contact-us" class="mega-menu-link">
                    <div class="mega-menu-title">Contact us</div>
                    <div class="mega-menu-desc">Reach out to our team</div>
                </a>
                <a href="/about-us" class="mega-menu-link">
                    <div class="mega-menu-title">About Imators</div>
                    <div class="mega-menu-desc">Our mission and vision</div>
                </a>
            </div>
            <div class="mega-menu-stories">
                <h3 class="stories-heading">Stories</h3>
                <div class="stories-grid">
                    <div class="story-card" style="background-image: url('https://cdn.imators.com/company1.jpg')">
                        <div class="story-content">
                            <h5 class="story-title">Our Journey</h5>
                            <p class="story-desc">The story of Imators</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div class="mobile-menu">
        <div class="mobile-menu-header">
            <h2 class="mobile-menu-title">Nice to see you.</h2>
        </div>

        <div class="mobile-stories">
            <div class="mobile-stories-grid">
                <div class="mobile-story" style="background-color: #8B5CF6;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">Academ</h3>
                        <p class="mobile-story-desc">Saying goodbye to homework overflow</p>
                        <a href="https://academ.my" class="mobile-story-btn">Learn more</a>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #FBBF24;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">OhMyPanel</h3>
                        <p class="mobile-story-desc">Quick & easy shopping</p>
                        <a href="https://ohmypanel.com" class="mobile-story-btn">Learn more</a>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #404040;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">Imators Account</h3>
                        <p class="mobile-story-desc">Global benefits</p>
                        <a href="https://idsma.imators.com" class="mobile-story-btn">Explorer</a>
                    </div>
                </div>
                <div class="mobile-story" style="background-color: #3B82F6;">
                    <div class="mobile-story-content">
                        <h3 class="mobile-story-title">TrafficLight</h3>
                        <p class="mobile-story-desc">Traffic management</p>
                        <a href="https://imators.systems/traffic" class="mobile-story-btn">Discover</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="mobile-nav">
            <div class="mobile-nav-item" data-submenu="products-submenu">
                <span>Products</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-submenu="developer-submenu">
                <span>Developer Tools</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
            <div class="mobile-nav-item" data-submenu="company-submenu">
                <span>Company</span>
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 18l6-6-6-6"/>
                </svg>
            </div>
        </div>
    </div>

    <!-- Mobile Submenus -->
    <div class="mobile-submenu" id="products-submenu">
        <div class="mobile-submenu-header">
            <button class="back-btn">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-submenu-title">Products</span>
        </div>
        <div class="mobile-submenu-links">
            <a href="https://academ.my" class="mobile-submenu-link">Academ</a>
            <a href="/progm" class="mobile-submenu-link">Progm</a>
            <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
            <a href="https://owtfitt.com" class="mobile-submenu-link">Owtfitt</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu" id="developer-submenu">
        <div class="mobile-submenu-header">
            <button class="back-btn">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-submenu-title">Developer Tools</span>
        </div>
        <div class="mobile-submenu-links">
            <a href="https://imators.systems" class="mobile-submenu-link">Imators Systems</a>
            <a href="https://developer.imators.com" class="mobile-submenu-link">Imators Developer</a>
            <a href="https://imators.systems/traffic" class="mobile-submenu-link">TrafficLight</a>
        </div>
    </div>

    <div class="mobile-submenu" id="company-submenu">
        <div class="mobile-submenu-header">
            <button class="back-btn">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M15 18l-6-6 6-6"/>
                </svg>
            </button>
            <span class="mobile-submenu-title">Company</span>
        </div>
        <div class="mobile-submenu-links">
            <a href="/support" class="mobile-submenu-link">Support</a>
            <a href="/contact-us" class="mobile-submenu-link">Contact us</a>
            <a href="/about-us" class="mobile-submenu-link">About Imators</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Elements
            const header = document.querySelector('.header');
            const mobileToggle = document.querySelector('.mobile-toggle');
            const mobileMenu = document.querySelector('.mobile-menu');
            const menuItems = document.querySelectorAll('.menu-item');
            const megaMenus = document.querySelectorAll('.mega-menu');
            const megaMenuBackdrops = document.querySelectorAll('.mega-menu-backdrop');
            const mobileNavItems = document.querySelectorAll('.mobile-nav-item');
            const mobileSubmenus = document.querySelectorAll('.mobile-submenu');
            const backButtons = document.querySelectorAll('.back-btn');
            
            let lastScrollTop = 0;
            let scrollTimeout;
            let activeMenu = null;
            
            // Desktop menu hover handling
            menuItems.forEach(item => {
                const menuType = item.getAttribute('data-menu');
                const menu = document.getElementById(menuType + '-menu');
                const backdrop = document.getElementById(menuType + '-backdrop');
                
                if (menu && backdrop) {
                    // Show menu on hover
                    item.addEventListener('mouseenter', function() {
                        // Hide any active menu
                        if (activeMenu && activeMenu !== menu) {
                            activeMenu.style.maxHeight = '0';
                            activeMenu.style.opacity = '0';
                            activeMenu.style.visibility = 'hidden';
                            
                            const activeBackdrop = document.getElementById(activeMenu.id.replace('menu', 'backdrop'));
                            if (activeBackdrop) {
                                activeBackdrop.style.opacity = '0';
                                activeBackdrop.style.visibility = 'hidden';
                            }
                        }
                        
                        // Show current menu
                        menu.style.maxHeight = '800px';
                        menu.style.opacity = '1';
                        menu.style.visibility = 'visible';
                        backdrop.style.opacity = '1';
                        backdrop.style.visibility = 'visible';
                        activeMenu = menu;
                        document.body.style.overflow = 'hidden';
                    });
                    
                    // Hide menu when mouse leaves menu area
                    menu.addEventListener('mouseleave', function() {
                        closeMenu(menu, backdrop);
                    });
                    
                    // Hide menu when clicking backdrop
                    backdrop.addEventListener('click', function() {
                        closeMenu(menu, backdrop);
                    });
                }
            });
            
            function closeMenu(menu, backdrop) {
                menu.style.maxHeight = '0';
                menu.style.opacity = '0';
                menu.style.visibility = 'hidden';
                backdrop.style.opacity = '0';
                backdrop.style.visibility = 'hidden';
                activeMenu = null;
                document.body.style.overflow = '';
            }
            
            // Mobile menu toggle
            mobileToggle.addEventListener('click', function() {
                this.classList.toggle('active');
                mobileMenu.classList.toggle('active');
                
                if (mobileMenu.classList.contains('active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                    // Close all submenus
                    mobileSubmenus.forEach(submenu => {
                        submenu.classList.remove('active');
                    });
                }
            });
            
            // Mobile navigation items
            mobileNavItems.forEach(item => {
                item.addEventListener('click', function() {
                    const submenuId = this.getAttribute('data-submenu');
                    const submenu = document.getElementById(submenuId);
                    
                    if (submenu) {
                        submenu.classList.add('active');
                    }
                });
            });
            
            // Back buttons in submenu
            backButtons.forEach(button => {
                button.addEventListener('click', function() {
                    const submenu = this.closest('.mobile-submenu');
                    if (submenu) {
                        submenu.classList.remove('active');
                    }
                });
            });
            
            // Handle scroll
            window.addEventListener('scroll', function() {
                clearTimeout(scrollTimeout);
                const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
                
                // Transparent header handling
                if (header.classList.contains('header-transparent')) {
                    if (scrollTop > 0) {
                        header.classList.add('scrolled');
                    } else {
                        header.classList.remove('scrolled');
                    }
                }
                
                // Hide/show header on scroll
                if (!mobileMenu.classList.contains('active') && !activeMenu && Math.abs(scrollTop - lastScrollTop) > 50) {
                    header.style.transform = scrollTop > lastScrollTop && scrollTop > header.offsetHeight ? 
                        'translateY(-100%)' : 'translateY(0)';
                    lastScrollTop = scrollTop;
                }
                
                scrollTimeout = setTimeout(() => {
                    header.style.transform = 'translateY(0)';
                }, 1000);
            });
            
            // Close menus with ESC key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    // Close mobile menu if open
                    if (mobileMenu.classList.contains('active')) {
                        mobileToggle.classList.remove('active');
                        mobileMenu.classList.remove('active');
                        document.body.style.overflow = '';
                        
                        // Also close any open submenu
                        mobileSubmenus.forEach(submenu => {
                            submenu.classList.remove('active');
                        });
                    }
                    
                    // Close desktop mega menu if open
                    if (activeMenu) {
                        const menuId = activeMenu.id;
                        const backdrop = document.getElementById(menuId.replace('menu', 'backdrop'));
                        
                        activeMenu.style.maxHeight = '0';
                        activeMenu.style.opacity = '0';
                        activeMenu.style.visibility = 'hidden';
                        
                        if (backdrop) {
                            backdrop.style.opacity = '0';
                            backdrop.style.visibility = 'hidden';
                        }
                        
                        activeMenu = null;
                        document.body.style.overflow = '';
                    }
                }
            });
            
            // Mobile story clicks
            const mobileStories = document.querySelectorAll('.mobile-story');
            mobileStories.forEach(story => {
                story.addEventListener('click', function() {
                    const link = this.querySelector('a');
                    if (link) {
                        window.location.href = link.getAttribute('href');
                    }
                });
            });
            
            // Desktop story clicks
            const storyCards = document.querySelectorAll('.story-card');
            storyCards.forEach(card => {
                card.addEventListener('click', function() {
                    window.location.href = '#story-detail';
                });
            });
            
            // Swipe down to close mobile menu
            let touchStartY = 0;
            mobileMenu.addEventListener('touchstart', function(e) {
                touchStartY = e.touches[0].clientY;
            }, { passive: true });
            
            mobileMenu.addEventListener('touchmove', function(e) {
                const touchY = e.touches[0].clientY;
                const diff = touchY - touchStartY;
                
                if (diff > 70) {
                    mobileToggle.classList.remove('active');
                    mobileMenu.classList.remove('active');
                    document.body.style.overflow = '';
                }
            }, { passive: true });
        });
    </script>
</body>
</html>