<?php
require_once 'config.php';

if(isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    // Add view
    if(isset($_SESSION['user_id'])) {
        $stmt = $pdo->prepare("INSERT INTO interactions (content_id, user_id, type) VALUES (?, ?, 'view')");
        $stmt->execute([$id, $_SESSION['user_id']]);
    }

    // Get video info
    $stmt = $pdo->prepare("
        SELECT c.*, u.username as author_name
        FROM content c
        LEFT JOIN users u ON c.author_id = u.id
        WHERE c.id = ?
    ");
    $stmt->execute([$id]);
    $video = $stmt->fetch(PDO::FETCH_ASSOC);

    if($video) {
        // Video player with controls
        echo '<video src="' . htmlspecialchars($video['url_video']) . '" controls class="w-full">
            Your browser does not support the video tag.
        </video>';
        
        // Video information
        echo '<div class="mt-4">';
        echo '<h2 class="text-2xl font-bold">' . htmlspecialchars($video['name']) . '</h2>';
        echo '<p class="text-gray-400 mt-2">' . nl2br(htmlspecialchars($video['description'])) . '</p>';
        echo '<p class="text-gray-400 mt-2">By: ' . htmlspecialchars($video['author_name']) . '</p>';
        echo '</div>';
    }
}
?>