<div class="bg-white rounded-lg shadow-sm border hover:shadow-md transition-shadow p-6">
    <div class="flex items-center mb-4">
        <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
            <i class="fas fa-pen-nib text-blue-600 text-xl"></i>
        </div>
        <h3 class="ml-4 text-lg font-semibold text-gray-900">Document Editor</h3>
    </div>
    <p class="text-gray-600 mb-4">Intelligent Search Engine - Créez des documents avec IA.</p>
    <a href="/editor" class="block w-full bg-blue-600 text-white py-2 px-4 rounded-lg hover:bg-blue-700 transition-colors text-center">
        Nouveau document
    </a>
</div>

<div class="bg-white rounded-lg shadow-sm border p-6 mb-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-xl font-semibold text-gray-900">Mes documents</h3>
        <a href="/editor" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors">
            <i class="fas fa-plus mr-2"></i>Nouveau document
        </a>
    </div>
    <div id="documents-list" class="space-y-3">
        <div class="text-center text-gray-500 py-8">
            <i class="fas fa-file-alt text-4xl mb-4"></i>
            <p>Chargement des documents...</p>
        </div>
    </div>
</div>

<script>
async function loadDocuments() {
    try {
        const response = await fetch('/api/documents');
        const documents = await response.json();
        
        const container = document.getElementById('documents-list');
        
        if (documents.length === 0) {
            container.innerHTML = `
                <div class="text-center text-gray-500 py-8">
                    <i class="fas fa-file-alt text-4xl mb-4"></i>
                    <p>Aucun document créé</p>
                    <a href="/editor" class="inline-block mt-4 bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700">
                        Créer votre premier document
                    </a>
                </div>
            `;
            return;
        }
        
        let html = '';
        documents.forEach(doc => {
            const date = new Date(doc.updated_at).toLocaleDateString('fr-FR');
            html += `
                <div class="flex items-center justify-between p-4 border rounded-lg hover:bg-gray-50">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-file-alt text-blue-600"></i>
                        <div>
                            <h4 class="font-medium text-gray-900">${doc.title}</h4>
                            <p class="text-sm text-gray-500">Modifié le ${date}</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-2">
                        <a href="/editor/${doc.id}" class="text-blue-600 hover:text-blue-800">
                            <i class="fas fa-edit"></i>
                        </a>
                        <button onclick="deleteDocument(${doc.id})" class="text-red-600 hover:text-red-800">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    } catch (error) {
        console.error('Erreur chargement documents:', error);
    }
}

async function deleteDocument(id) {
    if (confirm('Êtes-vous sûr de vouloir supprimer ce document ?')) {
        try {
            const response = await fetch(`/api/documents/${id}`, {
                method: 'DELETE'
            });
            
            if (response.ok) {
                loadDocuments();
            }
        } catch (error) {
            console.error('Erreur suppression:', error);
        }
    }
}

// Charger les documents au chargement de la page
document.addEventListener('DOMContentLoaded', loadDocuments);
</script>