<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('stock.json'), true) ?: [];
    
    if (isset($_POST['action'])) {
        if ($_POST['action'] === 'add') {
            $data[] = [
                'line' => $_POST['line'],
                'station' => $_POST['station'],
                'arrival' => $_POST['arrival'],
                'status' => 'on-time'
            ];
        } elseif ($_POST['action'] === 'update') {
            $index = $_POST['index'];
            if (isset($data[$index])) {
                $data[$index]['status'] = $_POST['status'];
            }
        } elseif ($_POST['action'] === 'delete') {
            array_splice($data, $_POST['index'], 1);
        }
    }
    
    file_put_contents('stock.json', json_encode($data));
    header('Location: admin.php');
    exit;
}

$data = json_decode(file_get_contents('stock.json'), true) ?: [];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration des Trains</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-b from-gray-900 to-gray-800 text-white min-h-screen">
    <div class="container mx-auto p-8">
        <h1 class="text-5xl font-bold mb-12 bg-gradient-to-r from-blue-500 to-purple-500 text-transparent bg-clip-text">Administration des Trains</h1>
        
        <form method="POST" class="bg-gray-800 bg-opacity-50 backdrop-blur-lg p-8 rounded-xl shadow-lg mb-12">
            <input type="hidden" name="action" value="add">
            <div class="grid grid-cols-3 gap-6">
                <div class="space-y-2">
                    <label class="block text-sm font-medium">Ligne</label>
                    <input type="text" name="line" class="w-full bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none" required>
                </div>
                <div class="space-y-2">
                    <label class="block text-sm font-medium">Gare</label>
                    <input type="text" name="station" class="w-full bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none" required>
                </div>
                <div class="space-y-2">
                    <label class="block text-sm font-medium">Heure d'arrivée</label>
                    <input type="datetime-local" name="arrival" class="w-full bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none" required>
                </div>
            </div>
            <button type="submit" class="mt-6 bg-gradient-to-r from-blue-500 to-blue-700 px-6 py-3 rounded-lg font-medium hover:from-blue-600 hover:to-blue-800 transition-colors">
                Ajouter un train
            </button>
        </form>
        
        <div class="space-y-6">
            <?php foreach ($data as $index => $train): ?>
            <div class="bg-gray-800 bg-opacity-50 backdrop-blur-lg p-6 rounded-xl shadow-lg flex items-center justify-between">
                <div class="flex items-center gap-6">
                    <div class="w-12 h-12 rounded-full bg-blue-500 flex items-center justify-center text-xl font-bold">
                        <?= htmlspecialchars($train['line']) ?>
                    </div>
                    <div>
                        <div class="text-xl font-medium"><?= htmlspecialchars($train['station']) ?></div>
                        <div class="text-gray-400"><?= (new DateTime($train['arrival']))->format('H:i') ?></div>
                    </div>
                </div>
                <div class="flex gap-4">
                    <form method="POST" class="flex items-center">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        <select name="status" class="bg-gray-700 p-3 rounded-lg mr-4 focus:ring-2 focus:ring-blue-500 focus:outline-none">
                            <option value="on-time" <?= $train['status'] === 'on-time' ? 'selected' : '' ?>>À l'heure</option>
                            <option value="delayed" <?= $train['status'] === 'delayed' ? 'selected' : '' ?>>Retardé</option>
                        </select>
                        <button type="submit" class="bg-gradient-to-r from-green-500 to-green-700 px-4 py-2 rounded-lg font-medium hover:from-green-600 hover:to-green-800 transition-colors">
                            Mettre à jour
                        </button>
                    </form>
                    <form method="POST" onsubmit="return confirm('Es-tu sûr de vouloir supprimer ce train ?')">
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="index" value="<?= $index ?>">
                        <button type="submit" class="bg-gradient-to-r from-red-500 to-red-700 px-4 py-2 rounded-lg font-medium hover:from-red-600 hover:to-red-800 transition-colors">
                            Supprimer
                        </button>
                    </form>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>