<?php
define('AZURE_KEY', 'VOTRE_CLE_AZURE');
define('AZURE_REGION', 'francecentral');

function generateAzureToken() {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://'.AZURE_REGION.'.api.cognitive.microsoft.com/sts/v1.0/issueToken');
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        <div class="space-y-6">
            <?php foreach ($data as $index => $train): ?>
            <div class="bg-gray-800 bg-opacity-50 backdrop-blur-lg p-6 rounded-xl shadow-lg">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-6">
                        <div class="w-12 h-12 rounded-full bg-blue-500 flex items-center justify-center text-xl font-bold">
                            <?= htmlspecialchars($train['line']) ?>
                        </div>
                        <div>
                            <div class="text-xl font-medium"><?= htmlspecialchars($train['station']) ?></div>
                            <div class="text-gray-400">
                                Voie <?= htmlspecialchars($train['platform']) ?> - 
                                <?= (new DateTime($train['arrival']))->format('H:i') ?>
                            </div>
                        </div>
                    </div>
                    <div class="flex gap-4">
                        <form method="POST" class="flex items-center gap-4">
                            <input type="hidden" name="action" value="update">
                            <input type="hidden" name="index" value="<?= $index ?>">
                            
                            <div>
                                <select name="status" class="bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                                    <option value="on-time" <?= $train['status'] === 'on-time' ? 'selected' : '' ?>>À l'heure</option>
                                    <option value="delayed" <?= $train['status'] === 'delayed' ? 'selected' : '' ?>>Retardé</option>
                                </select>
                            </div>
                            
                            <div>
                                <input type="number" name="platform" value="<?= htmlspecialchars($train['platform']) ?>" 
                                    min="1" max="99" class="w-20 bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none"
                                    placeholder="Voie">
                            </div>
                            
                            <div>
                                <input type="text" name="info" value="<?= htmlspecialchars($train['info'] ?? '') ?>" 
                                    class="w-64 bg-gray-700 p-3 rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none"
                                    placeholder="Information supplémentaire">
                            </div>
                            
                            <button type="submit" class="bg-gradient-to-r from-green-500 to-green-700 px-4 py-2 rounded-lg font-medium hover:from-green-600 hover:to-green-800 transition-colors">
                                Mettre à jour
                            </button>
                        </form>
                        
                        <form method="POST" onsubmit="return confirm('Es-tu sûr de vouloir supprimer ce train ?')">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="index" value="<?= $index ?>">
                            <button type="submit" class="bg-gradient-to-r from-red-500 to-red-700 px-4 py-2 rounded-lg font-medium hover:from-red-600 hover:to-red-800 transition-colors">
                                Supprimer
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    
    <script>
    document.querySelectorAll('input[type="datetime-local"]').forEach(input => {
        if (!input.value) {
            const now = new Date();
            now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
            input.value = now.toISOString().slice(0,16);
        }
    });
    </script>
</body>
</html>