<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Projects - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .border-custom {
                border-color: var(--border-dark);
            }
            .bg-custom {
                background-color: var(--bg-dark);
            }
            .button-custom {
                background-color: var(--text-dark);
                color: var(--bg-dark);
            }
            .dot-custom {
                background-color: var(--text-dark);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .border-custom {
                border-color: var(--border-light);
            }
            .bg-custom {
                background-color: var(--bg-light);
            }
            .button-custom {
                background-color: var(--text-light);
                color: var(--bg-light);
            }
            .dot-custom {
                background-color: var(--text-light);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        .project-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .project-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .project-tag {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            margin-right: 6px;
            margin-bottom: 6px;
        }

        .tag-web {
            background-color: #e34c26;
            color: white;
        }

        .tag-app {
            background-color: #03bafc;
            color: white;
        }

        .tag-design {
            background-color: #fc5a03;
            color: white;
        }

        .tag-backend {
            background-color: #777bb3;
            color: white;
        }

        section {
            border-bottom: 1px solid currentColor;
            padding: 4rem 0;
        }

        @media (min-width: 768px) {
            section {
                padding: 6rem 0;
            }
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 2.5rem;
            }
            h2 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="index.html" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- MENU
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4">
                    My work
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6">
                    Projects that make a difference
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12">
                    As CEO of Imators, I've led various projects that combine innovation with user-focused design. Here's a showcase of some of the work I'm most proud of.
                </p>
            </div>
        </section>

        <section id="featured-project" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">FEATURED PROJECT</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                <div class="overflow-hidden rounded-lg border border-custom shadow-lg">
                    <img src="https://images.unsplash.com/photo-1551288049-bebda4e38f71?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                         class="w-full h-full object-cover" alt="ForChange Platform">
                </div>
                
                <div class="space-y-6">
                    <h3 class="text-3xl font-light">ForChange Platform</h3>
                    <div class="flex flex-wrap">
                        <span class="project-tag tag-web">Web Development</span>
                        <span class="project-tag tag-backend">PHP Backend</span>
                        <span class="project-tag tag-design">UI/UX Design</span>
                    </div>
                    <p class="text-lg font-light leading-relaxed">
                        A comprehensive platform created to connect communities and enable positive social change. This project combines modern design principles with robust backend functionality.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        The platform includes user authentication, community forums, event management, and real-time notifications to create a seamless experience for users committed to making a difference.
                    </p>
                    <a href="https://forchange.me" class="button-custom px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block mt-4">
                        Visit Project
                    </a>
                </div>
            </div>
        </section>

        <section id="all-projects" class="mb-16">
            <h2 class="text-4xl font-light mb-12 border-b border-custom pb-4">ALL PROJECTS</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Project 1 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1460925895917-afdab827c52f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2015&q=80" 
                             class="w-full h-full object-cover" alt="Imators Dashboard">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">Imators Dashboard</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-web">Web App</span>
                            <span class="project-tag tag-backend">PHP</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            A comprehensive admin dashboard for managing company resources and client projects.
                        </p>
                        <a href="#" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
                
                <!-- Project 2 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1526498460520-4c246339dccb?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                             class="w-full h-full object-cover" alt="SmileyDay App">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">SmileyDay App</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-app">Mobile App</span>
                            <span class="project-tag tag-design">UI Design</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            A wellness application focused on promoting daily happiness through simple activities.
                        </p>
                        <a href="#" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
                
                <!-- Project 3 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1551434678-e076c223a692?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                             class="w-full h-full object-cover" alt="CodeJoy Platform">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">CodeJoy Platform</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-web">Web Platform</span>
                            <span class="project-tag tag-backend">JavaScript</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            An interactive coding platform designed to make learning programming enjoyable for beginners.
                        </p>
                        <a href="#" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
                
                <!-- Project 4 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                             class="w-full h-full object-cover" alt="Aktascorp Website">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">Aktascorp Website</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-web">Website</span>
                            <span class="project-tag tag-design">Design</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            A modern, responsive website for the Aktascorp group showcasing their services and portfolio.
                        </p>
                        <a href="https://aktascorp.com" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
                
                <!-- Project 5 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1593720213428-28a5b9e94613?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                             class="w-full h-full object-cover" alt="DevPortal">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">DevPortal</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-web">Web Platform</span>
                            <span class="project-tag tag-backend">Full Stack</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            A developer-focused portal with documentation, API references, and interactive tutorials.
                        </p>
                        <a href="#" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
                
                <!-- Project 6 -->
                <div class="project-card rounded-lg border border-custom overflow-hidden">
                    <div class="aspect-video overflow-hidden">
                        <img src="https://images.unsplash.com/photo-1519389950473-47ba0277781c?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2070&q=80" 
                             class="w-full h-full object-cover" alt="TeamCollab Tool">
                    </div>
                    <div class="p-6 space-y-4">
                        <h3 class="text-2xl font-light">TeamCollab Tool</h3>
                        <div class="flex flex-wrap">
                            <span class="project-tag tag-web">Web App</span>
                            <span class="project-tag tag-backend">PHP & JS</span>
                        </div>
                        <p class="text-base font-light leading-relaxed">
                            An internal collaboration tool for development teams with project tracking and real-time communication.
                        </p>
                        <a href="#" class="text-sm hover:underline inline-block mt-2">View details →</a>
                    </div>
                </div>
            </div>
        </section>

        <section id="contact" class="mb-16">
            <div class="max-w-2xl mx-auto text-center">
                <h2 class="text-4xl font-light mb-6">Have a project in mind?</h2>
                <p class="text-lg font-light leading-relaxed mb-8">
                    I'm always looking for interesting challenges and new opportunities. Let's create something amazing together!
                </p>
                <a href="mailto:contact@forchange.me" class="button-custom px-8 py-3 rounded-full text-sm font-light tracking-wide hover:opacity-90 transition-opacity inline-block">
                    Get in touch
                </a>
            </div>
        </section>
    </main>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
        <p>All projects shown are the property of Imators. All rights reserved.</p>
    </footer>
</body>
</html>