<!DOCTYPE html>
<html data-lt-installed="true" lang="fr">
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Imators</title>
	  <script>
  window.intercomSettings = {
    api_base: "https://api-iam.intercom.io",
    app_id: "iy90e1rt",
  };
</script>

<div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
  <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
    <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
    Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use<a>.
    </div>
    <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
    Accept
    </button>
  </div>
</div>

<script>
  function acceptCookies() {
    const cookieBox = document.getElementById('cookieBox');
    cookieBox.classList.add('opacity-0', 'translate-y-8');
    
    setTimeout(() => {
      cookieBox.style.display = 'none';
      localStorage.setItem('cookiesAccepted', 'true');
    }, 500);
  }

  window.onload = function() {
    const cookieBox = document.getElementById('cookieBox');
    
    if (localStorage.getItem('cookiesAccepted') === 'true') {
      cookieBox.style.display = 'none';
    } else {
      setTimeout(() => {
        cookieBox.classList.remove('opacity-0', 'translate-y-8');
      }, 2000);
    }
  }
</script>


<script>
  // We pre-filled your app ID in the widget URL: 'https://widget.intercom.io/widget/iy90e1rt'
  (function(){var w=window;var ic=w.Intercom;if(typeof ic==="function"){ic('reattach_activator');ic('update',w.intercomSettings);}else{var d=document;var i=function(){i.c(arguments);};i.q=[];i.c=function(args){i.q.push(args);};w.Intercom=i;var l=function(){var s=d.createElement('script');s.type='text/javascript';s.async=true;s.src='https://widget.intercom.io/widget/iy90e1rt';var x=d.getElementsByTagName('script')[0];x.parentNode.insertBefore(s,x);};if(document.readyState==='complete'){l();}else if(w.attachEvent){w.attachEvent('onload',l);}else{w.addEventListener('load',l,false);}}})();
</script>

	<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css" rel="stylesheet" />
<link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
	<script src="https://cdn.jsdelivr.net/npm/alpinejs@2.2.19/dist/alpine.min.js" defer></script>
<link href="https://fonts.googleapis.com/css2?family=Karla:wght@200&display=swap" rel="stylesheet">
<meta name="description" content="Imators, founded in January 2024 by Izhak Aktas, is an innovative company specializing in the development of cutting-edge technologies.">

<!-- Facebook Meta Tags -->
<meta property="og:url" content="https://imators.com/privacy">
<meta property="og:type" content="website">
<meta property="og:title" content="Imators - Privacy Policy">
<meta property="og:description" content="Discover a new technological era by including good products and good means in your daily life with Imators">
<meta property="og:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">

<!-- Twitter Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta property="twitter:domain" content="imators.com">
<meta property="twitter:url" content="https://imators.com/privacy">
<meta name="twitter:title" content="Imators - Privacy Policy">
<meta name="twitter:description" content="Discover a new technological era by including good products and good means in your daily life with Imators">
<meta name="twitter:image" content="https://opengraph.b-cdn.net/production/documents/d172e1b4-bb0f-43f1-8d53-3e621ff45f4d.png?token=666f0cdDa_ZLi24WisNPC35fxAOWa_mcSOkOE0dzTXg&height=630&width=1200&expires=33249085956">
<link rel="stylesheet" href="src/header/styles.css" />
<script src="src/header/script.js" defer></script>
  <style>

        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
        }


    #progressBar {
      position: fixed;
      top: 0;
      right: 0;
      width: 4px;
      height: 0;
      background: #4C51BF;
      transition: height 0.3s;
      z-index: 1000;
    }
    .content-section {
      padding-top: 2rem;
      padding-bottom: 2rem;
    }

    header {
      transition: background-color 0.5s;
  }
  .menu-link {
      transition: color 0.3s ease-in-out;
  }
  .visible-header-bg {
      background-color: rgba(0, 0, 0, 0.8) !important;
  }
  .visible-header-text {
      color: #FFF !important;
  }
  .footer, .mobile-menu {
      background-color: #111827;
      color: #FFF;
  }
  
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        .animated-gradient {
            background: linear-gradient(45deg, #6D5BBA, #8D58BF, #9D55B8, #E15594, #E15555);
            background-size: 600% 600%;
            animation: gradientBG 16s ease infinite;
        }
        .menu-animate {
            transition: transform 0.3s ease;
        }
        .menu-animate:hover {
            transform: rotate(90deg);
        }
        .link-underline::after {
            content: '';
            display: block;
            width: 0;
            height: 2px;
            background: #FFFFFF;
            transition: width .3s;
        }
        .link-underline:hover::after {
            width: 100%;
        }
        .hover-bg:hover {
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
        }
  

  </style>
</head>
<body class="mt-8 bg-black text-white">
<?php include 'src/header.php'; ?>


    <section class="container mx-auto py-16 px-4">
      <h1 class="text-4xl font-bold mb-8 text-blue-200">Privacy Policy</h1>
      <p class="mb-4">
        At Imators, we are committed to protecting the privacy and security of our users. This Privacy Policy outlines the types of information we collect, how we use it, and the measures we take to safeguard your personal data.
      </p>
      
    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">Data collection</h2>
    <p class="mb-4">
        During any verification process, such as logging into your account or otherwise, we will be required to examine your IP address in order to track the location where the connection/action was performed. Our applications and services collect similar but more extensive information, such as e-mail address, surname, first name and age. This information, which complies with the GDPR and respects your privacy, is never shared with third-party services for commercial, sales or marketing purposes. Our services collect your information securely and delete it permanently each time you log off via the device you used to access our platforms, site or applications.
    </p>

    <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">How We Use Your Information</h2>
    <p class="mb-4">
        We use the information we collect in a variety of ways to improve our services and provide an optimal user experience. Here is a detailed explanation of how we use your information:
    </p>
    <ul class="list-disc ml-8 mb-4">
        <li class="text-blue-500">Service customization</li>
        <p>One of the main advantages of collecting your IP address is that we can personalize the services we offer you. By knowing your IP address, we can identify your approximate geographical location and redirect you to services or pages that are most relevant to you. For example, if you're in a specific region, we may show you promotions or services that are available in your area. This personalization ensures that you see content that is relevant and useful to you, enhancing your overall user experience.</p>
        <li class="text-blue-500">Account creation and management</li>
        <p>When you create a customer account with Imators, we associate your e-mail address and password with your IP address. This association enables us to offer you centralized management of all the devices connected to your account. This means you can easily track and control the connections of your various devices, ensuring enhanced security and simplified management. For example, if you connect from a new device, we can check whether the IP address matches the one we have registered and, if there is a discrepancy, alert you to any suspicious activity.</p>
        <li class="text-blue-500">Security and Fraud Prevention</li>
        <p>Collecting your IP address also plays a crucial role in the security of your account. By monitoring IP addresses attempting to connect to your account, we are able to detect suspicious or unauthorized activity. For example, if we see attempts to connect from IP addresses in geographic regions that are unusual for your profile, we may take steps to protect your account, such as blocking access or requesting further verification. This continuous monitoring helps us to prevent fraud and proactively protect your personal information.</p>
        <li class="text-blue-500">Improving our Services</li>
        <p>The information we collect is not only used to analyze customer visits or personalize services, but is also essential for the continuous improvement of our services. By studying browsing data and users' interactions with our site, we can identify which features are working well and which need adjustment. For example, if we find that a particular page has a high bounce rate, we can investigate to understand why users are leaving that page and make any necessary changes to improve its content or usability.</p>
        <li class="text-blue-500">Communication with Users</li>
        <p>We also use your information to communicate directly with you. For example, we may send you e-mails to confirm your registration, inform you of important updates to our services, or send you promotions and special offers that may be of interest to you. Your e-mail address, combined with your IP address, enables us to personalize these communications and ensure that they are relevant to you. If you have any questions or concerns, you can contact us at any time, and we will use your information to provide you with the assistance you need.</p>
        <li class="text-blue-500">Compliance with Legal Obligations</li>
        <p>Finally, we may need to share your information to comply with applicable laws and regulations. For example, if we receive a legal request to disclose your information from the relevant authorities, we may be obliged to provide this information. We are committed to respecting your rights and privacy while complying with legal and regulatory obligations.</p>
    </ul>

      <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">Sharing Your Personal Information</h2>
      <p class="mb-4">
        We share your personal information with third parties to help us use them effectively, as described above. This sharing allows us to improve our services and provide you with a better user experience. Here are some detailed examples of how and why we share your personal information:
        <p>We use Google Analytics, a web analysis service provided by Google, to help us understand how our customers use our site. Google Analytics collects information such as the frequency of your visits to our site, the pages you view and the sites you visited before coming to our site. This information helps us analyze trends, administer the site, track users' movements around the site and gather demographic information about our user base as a whole. By learning more about our users' behavior, we can adjust our content and services to better meet your needs and preferences.</p>
        <p>We also share your personal information with third-party service providers who perform services on our behalf, such as processing payments, sending marketing emails, hosting our website, and analyzing data. These third-party service providers have access to your personal information only to the extent necessary to perform these tasks on our behalf and are contractually bound not to disclose or use your information for any other purpose.</p>
        <p>Finally, we may also share your personal information to comply with applicable laws and regulations. For example, we may disclose your personal information in response to a subpoena, search warrant or other lawful request for information that we receive from the appropriate authorities. We may also share your personal information to protect our rights, property or safety, as well as those of our users or third parties.</p>
        <p>In certain situations, it may be necessary to share your personal information to protect our rights and security and that of our users. For example, if we have reason to believe that you have violated our terms of use or committed fraud, we may share your information with the appropriate authorities or other relevant third parties to investigate such violations and take appropriate action.</p>
        <p>We may also share your personal information with our subsidiaries and affiliates in the course of our business operations. These entities use your information in the same way we do, in accordance with this Privacy Policy. This allows us to streamline our operations and ensure a consistent and integrated user experience across all our platforms and services.</p>
        <p>As part of our ongoing development, we may sell, buy, merge or reorganize our business or assets. As part of these transactions, users' personal information may be transferred as a business asset. In such cases, we will ensure that your personal information remains protected in accordance with this Privacy Policy and applicable laws.</p>
        <p>Occasionally, we may share aggregated or anonymous information with third parties for marketing, advertising, research or other purposes. This information does not identify you personally and is used to analyze trends, conduct demographic research and improve our services.</p>
        <p class="mt-6">In conclusion, the sharing of your personal information with third parties is done responsibly and only for legitimate reasons that aim to improve your user experience, comply with legal obligations and protect our rights and those of our users. We are committed to protecting your personal information and using it in a transparent and secure manner.</p>
      </p>
    

      
      <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">Your Rights</h2>
<p class="mb-4">
  You have several rights regarding your personal information. We are committed to respecting and facilitating the exercise of these rights to ensure transparency and the protection of your data. Here is a detailed description of your rights and how you can exercise them:
</p>
<p class="mb-4">
  <strong>Access rights:</strong> You have the right to request access to the personal information we hold about you. This includes the right to receive a copy of this information and to know how it is used, processed, and shared. To exercise this right, you can contact us through the means provided below, and we will provide you with a copy of your personal information in a comprehensible and accessible format.
</p>
<p class="mb-4">
  <strong>Right of rectification:</strong> If you find that the personal information we hold about you is incorrect, incomplete, or outdated, you have the right to request its rectification. You can provide us with the necessary details to correct or complete this information, and we will ensure our records are updated accordingly.
</p>
<p class="mb-4">
  <strong>Right to erasure (Right to be forgotten):</strong> In certain circumstances, you have the right to request the deletion of your personal information. This includes situations where the data is no longer necessary for the purposes for which it was collected, where you withdraw your consent on which the processing is based, or where you object to the processing of your data and there are no overriding legitimate grounds for the processing. If you wish to exercise this right, please contact us, and we will take the necessary steps to delete your personal information from our systems.
</p>
<p class="mb-4">
  <strong>Right to Restrict Processing:</strong> You also have the right to request the restriction of the processing of your personal information in certain situations. This means you can ask us to suspend the use of your data, for example, if you contest the accuracy of the information or if you object to its processing. While we review your request, we will limit the processing of your personal information to specific purposes.
</p>
<p class="mb-4">
  <strong>Right to Data Portability:</strong> The right to data portability allows you to receive your personal information in a structured, commonly used, and machine-readable format and to transmit it to another data controller. This applies only to data that you have provided to us and that is processed by automated means based on your consent or the performance of a contract. If you wish to exercise this right, we will provide your personal information in a compatible format and facilitate its transfer to another data controller if technically possible.
</p>
<p class="mb-4">
  <strong>Right to object:</strong> You have the right to object to the processing of your personal information in certain circumstances. This includes cases where we process your data for legitimate interests or for direct marketing purposes. If you object to the processing of your data for legitimate interests, we will cease the processing unless we can demonstrate compelling legitimate grounds for the processing that override your rights and freedoms. If you object to processing for direct marketing purposes, we will immediately stop processing your data for these purposes.
</p>
<p class="mb-4">
  <strong>Right to Withdraw Consent:</strong> If the processing of your personal information is based on your consent, you have the right to withdraw this consent at any time. Withdrawing your consent does not affect the lawfulness of the processing based on consent before its withdrawal. To withdraw your consent, you can contact us via the means provided below, and we will stop processing your personal information accordingly.
</p>
<p class="mb-4">
  <strong>Right to file a complaint:</strong> If you believe your data protection rights have been violated, you have the right to file a complaint with the competent data protection authority. However, we encourage you to contact us first to resolve any concerns you may have. We take your concerns very seriously and will strive to resolve them fairly and promptly.
</p>



      <h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">Changes</h2>
      <p class="mb-4">
        We may update this privacy policy from time to time in order to reflect, for example, changes to our practices or for other operational, legal, or regulatory reasons. You will be informed by e-mail if you have a customer account with us.
      </p>

<h2 class="text-2xl font-semibold mt-8 mb-4 text-blue-300">Contact Us</h2>
<p class="mb-4">
  Questions about this privacy policy? Contact us via  <a href="/contact-us" class="text-blue-500 hover:underline"></a>
  <a href="contact-us" class="text-blue-500 hover:underline">Contact Us</a> page for more ways to reach us.
</p>

    </section>

<footer class="bg-black text-white"><div class="max-w-6xl mx-auto px-4 py-10 flex flex-wrap justify-between">
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Need Help?</h5>
        <a href="/support" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Support
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Discover</h5>
        <a href="/privacy" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Privacy Policy
        </a>
        <a href="/terms-of-use" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Terms of Use
        </a>
        <a href="/" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Home
        </a>
        <a href="/about-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            About Us
        </a>
        <a href="/contact-us" class="my-3 block hover:text-gray-100 text-sm font-medium duration-700">
            Contact Us
        </a>
    </div>
    <div class="w-full md:w-1/3 p-5">
        <h5 class="text-xs uppercase font-medium mb-6">Because it's possible</h5>
        <p class="text-sm">
            All images, videos, and content on this site are the property of Imators.
        </p>
    </div>
</div>

<div class="text-center py-4 border-t border-gray-800">
    <p class="text-sm mb-2">
        &copy; <?php echo date("Y"); ?> Imators. All rights reserved.
    </p>
    <p class="text-xs mt-4">
        <a href="https://aktascorp.com">Imators is a aktascorp members.</a>
    </p>
    <p class="text-xs">
        Imators is a registered LLC (Limited Liability Company). All our products, whether technologically physical or simply online, are subject to our rules, which you can access.
    </p>
</div></footer>

</body>
</html>