<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Menu - Izhak</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="icon" href="icon.png" type="image/png">
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <style>
        :root {
            --bg-light: #ffffff;
            --bg-dark: #121212;
            --text-light: #121212;
            --text-dark: #f5f5f5;
            --border-light: rgba(0, 0, 0, 0.1);
            --border-dark: rgba(255, 255, 255, 0.1);
        }

        @media (prefers-color-scheme: dark) {
            body {
                background-color: var(--bg-dark);
                color: var(--text-dark);
            }
            .header-border {
                border-top: 1px solid var(--text-dark);
                border-bottom: 1px solid var(--text-dark);
                background-color: rgba(18, 18, 18, 0.8);
            }
            .menu-item {
                border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            }
            .menu-item:hover {
                background-color: rgba(255, 255, 255, 0.05);
            }
        }

        @media (prefers-color-scheme: light) {
            body {
                background-color: var(--bg-light);
                color: var(--text-light);
            }
            .header-border {
                border-top: 1px solid var(--text-light);
                border-bottom: 1px solid var(--text-light);
                background-color: rgba(255, 255, 255, 0.8);
            }
            .menu-item {
                border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            }
            .menu-item:hover {
                background-color: rgba(0, 0, 0, 0.05);
            }
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .header-border {
            backdrop-filter: blur(10px);
        }

        .menu-item {
            transition: transform 0.3s ease;
        }

        .menu-item:hover {
            transform: translateX(10px);
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }
    </style>
</head>
<body class="min-h-screen">
    <header class="header-border py-8 mb-16 sticky top-0 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-6xl md:text-7xl font-light italic tracking-tight">
                    Izhak
                </h1>
                <a href="/" class="text-sm hover:underline hover:font-semibold font-light max-w-xs text-right leading-relaxed">
                    <- HOME
                </a>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="menu" class="mb-16">
            <h2 class="text-4xl font-light mb-12 pb-4">What would you like to see?</h2>
            
            <div class="menu-list">
                <?php
                // Array of pages with their titles and URLs
                $pages = [
                    ['title' => 'Home', 'url' => '/'],
                    ['title' => 'Projects', 'url' => '/projects'],
                    ['title' => 'Website shop', 'url' => '/shop'],
                    ['title' => 'Contact', 'url' => '/contact'],
                ];

                // Display each page as a menu item
                foreach ($pages as $index => $page) {
                    echo '<a href="' . $page['url'] . '" class="menu-item block py-6 text-3xl md:text-4xl font-light hover:font-normal">' . $page['title'] . '</a>';
                }
                ?>
            </div>
        </section>
    </main>

    <footer class="py-8 text-center text-sm font-light">
        <p>Designed with a smile.</p>
        <p>This website is protected by the <a href="https://aktascorp.com" class="underline">aktascorp group</a></p>
    </footer>
</body>
</html>