<?php
require_once 'functions.php';
checkLogin();

$systemInfo = getSystemInfo();
$recentProfiles = getProfiles();
$recentProfiles = array_slice($recentProfiles, 0, 5);

$totalProfiles = $db->query("SELECT COUNT(*) FROM profiles")->fetchColumn();
$recentActivities = $db->query("SELECT a.*, u.username FROM activity_logs a LEFT JOIN users u ON a.user_id = u.id ORDER BY a.created_at DESC LIMIT 10")->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peerkinton - Tableau de bord</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            font-weight: 300;
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="min-h-screen flex flex-col">
        <header class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
                <div class="flex items-center">
                    <h1 class="text-2xl font-light">PEERKINTON</h1>
                </div>
                <nav class="flex space-x-8">
                    <a href="index.php" class="text-blue-600 font-light">Accueil</a>
                    <a href="search.php" class="text-gray-600 hover:text-blue-600 font-light">Recherche</a>
                    <a href="logout.php" class="text-gray-600 hover:text-red-600 font-light">Déconnexion</a>
                </nav>
            </div>
        </header>

        <main class="flex-grow max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <section>
                    <div class="mb-8">
                        <h2 class="text-xl font-light mb-4">Statistiques du système</h2>
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <p class="text-sm text-gray-500">Nom du système</p>
                                    <p class="text-xl font-light"><?php echo $systemInfo['name']; ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Version</p>
                                    <p class="text-xl font-light"><?php echo $systemInfo['version']; ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Date de création</p>
                                    <p class="text-xl font-light"><?php echo date('d/m/Y', strtotime($systemInfo['creation_date'])); ?></p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-500">Profils enregistrés</p>
                                    <p class="text-xl font-light"><?php echo number_format($totalProfiles); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div>
                        <h2 class="text-xl font-light mb-4">Profils récents</h2>
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden">
                            <?php if (empty($recentProfiles)): ?>
                                <p class="p-6 text-gray-500">Aucun profil enregistré</p>
                            <?php else: ?>
                                <table class="min-w-full divide-y divide-gray-200">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nom</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Email</th>
                                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date de mise à jour</th>
                                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <?php foreach ($recentProfiles as $profile): ?>
                                            <tr>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="font-light"><?php echo htmlspecialchars($profile['full_name']); ?></div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="text-sm text-gray-500"><?php echo htmlspecialchars($profile['email']); ?></div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap">
                                                    <div class="text-sm text-gray-500"><?php echo date('d/m/Y H:i', strtotime($profile['updated_at'])); ?></div>
                                                </td>
                                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-light">
                                                    <a href="profile.php?id=<?php echo $profile['id']; ?>" class="text-blue-600 hover:text-blue-800 mx-1">Voir</a>
                                                    <a href="edit.php?id=<?php echo $profile['id']; ?>" class="text-green-600 hover:text-green-800 mx-1">Modifier</a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                                <div class="px-6 py-3 bg-gray-50 text-right">
                                    <a href="search.php" class="text-blue-600 hover:text-blue-800 text-sm font-light">Voir tous les profils →</a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </section>

                <section>
                    <div class="mb-8">
                        <h2 class="text-xl font-light mb-4">Journal des mises à jour</h2>
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                            <?php if (empty($systemInfo['update_logs'])): ?>
                                <p class="text-gray-500">Aucune mise à jour enregistrée</p>
                            <?php else: ?>
                                <div class="space-y-4">
                                    <?php foreach ($systemInfo['update_logs'] as $log): ?>
                                        <div class="border-l-4 border-blue-500 pl-4 py-1">
                                            <p class="text-sm"><?php echo htmlspecialchars($log); ?></p>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div>
                        <h2 class="text-xl font-light mb-4">Activités récentes</h2>
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                            <?php if (empty($recentActivities)): ?>
                                <p class="text-gray-500">Aucune activité enregistrée</p>
                            <?php else: ?>
                                <div class="space-y-4">
                                    <?php foreach ($recentActivities as $activity): ?>
                                        <div class="flex items-start space-x-3">
                                            <div class="w-2 h-2 rounded-full bg-blue-500 mt-2"></div>
                                            <div class="flex-1">
                                                <p class="text-sm">
                                                    <span class="font-medium"><?php echo htmlspecialchars($activity['username'] ?? 'Système'); ?></span>
                                                    <?php 
                                                    switch ($activity['action']) {
                                                        case 'login':
                                                            echo 's\'est connecté';
                                                            break;
                                                        case 'login_failed':
                                                            echo 'a échoué la connexion';
                                                            break;
                                                        case 'create_profile':
                                                            echo 'a créé un profil';
                                                            break;
                                                        case 'update_profile':
                                                            echo 'a mis à jour un profil';
                                                            break;
                                                        case 'delete_profile':
                                                            echo 'a supprimé un profil';
                                                            break;
                                                        default:
                                                            echo htmlspecialchars($activity['action']);
                                                    }
                                                    ?>
                                                </p>
                                                <?php if (!empty($activity['details'])): ?>
                                                    <p class="text-xs text-gray-500 mt-1"><?php echo htmlspecialchars($activity['details']); ?></p>
                                                <?php endif; ?>
                                                <p class="text-xs text-gray-400 mt-1"><?php echo date('d/m/Y H:i:s', strtotime($activity['created_at'])); ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </section>
            </div>
        </main>

        <footer class="bg-white border-t border-gray-200 py-6">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <p class="text-center text-sm text-gray-500">
                    &copy; <?php echo date('Y'); ?> Peerkinton - Centre privé d'analyse de profils - Tous droits réservés
                </p>
            </div>
        </footer>
    </div>
</body>
</html>