<?php
$dotenv = parse_ini_file('.env');
$event_date = new DateTime($dotenv['EVENT_DATE']);
$address = $dotenv['EVENT_ADDRESS'];
$latitude = $dotenv['EVENT_LAT'];
$longitude = $dotenv['EVENT_LONG'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événement</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap">
</head>
<body class="bg-white font-['Inter']">
    <div class="max-w-[1400px] mx-auto px-4">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-1 mb-24">
            <div class="aspect-square">
                <img src="/image1.jpg" class="w-full h-full object-cover" alt="">
            </div>
            <div class="aspect-square">
                <img src="/image2.jpg" class="w-full h-full object-cover" alt="">
            </div>
            <div class="aspect-square">
                <img src="/image3.jpg" class="w-full h-full object-cover" alt="">
            </div>
            <div class="aspect-square">
                <img src="/image4.jpg" class="w-full h-full object-cover" alt="">
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-16">
            <div class="space-y-12">
                <div>
                    <h1 class="text-4xl font-light mb-6"><?php echo $dotenv['EVENT_TITLE']; ?></h1>
                    <p class="text-gray-600 leading-relaxed"><?php echo $dotenv['EVENT_DESCRIPTION']; ?></p>
                </div>
                
                <div class="flex space-x-8 text-5xl font-light" id="countdown">
                    <span class="countdown-days">00</span>
                    <span class="countdown-hours">00</span>
                    <span class="countdown-minutes">00</span>
                    <span class="countdown-seconds">00</span>
                </div>
            </div>
            
            <div class="h-[600px]" id="map"></div>
        </div>
    </div>

    <script>
    function updateCountdown() {
        const eventDate = new Date('<?php echo $event_date->format('Y-m-d H:i:s'); ?>');
        const now = new Date();
        const diff = eventDate - now;

        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        document.querySelector('.countdown-days').textContent = String(days).padStart(2, '0');
        document.querySelector('.countdown-hours').textContent = String(hours).padStart(2, '0');
        document.querySelector('.countdown-minutes').textContent = String(minutes).padStart(2, '0');
        document.querySelector('.countdown-seconds').textContent = String(seconds).padStart(2, '0');
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();

    mapkit.init({
        authorizationCallback: function(done) {
            done('<?php echo $dotenv['MAPKIT_TOKEN']; ?>');
        }
    });

    const map = new mapkit.Map('map');
    const coordinate = new mapkit.Coordinate(<?php echo $latitude; ?>, <?php echo $longitude; ?>);
    const annotation = new mapkit.MarkerAnnotation(coordinate, {
        color: "#000000",
        title: "<?php echo $address; ?>"
    });

    map.addAnnotation(annotation);
    map.showItems([annotation]);
    </script>
</body>
</html>