<?php
$dotenv = parse_ini_file('.env');
$event_date = new DateTime($dotenv['EVENT_DATE']);
$address = $dotenv['EVENT_ADDRESS'];
$latitude = $dotenv['EVENT_LAT'];
$longitude = $dotenv['EVENT_LONG'];
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Événement</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.apple-mapkit.com/mk/5.x.x/mapkit.js"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap">
</head>
<body class="bg-[#FAFAFA] min-h-screen">
    <div class="max-w-7xl mx-auto p-6 sm:p-8">
        <div class="grid grid-cols-2 sm:grid-cols-4 gap-3 mb-16">
            <div class="relative group overflow-hidden rounded-2xl aspect-square transition-all duration-300 hover:scale-[1.02]">
                <img src="/image1.jpg" class="w-full h-full object-cover" alt="Image 1">
                <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </div>
            <div class="relative group overflow-hidden rounded-2xl aspect-square transition-all duration-300 hover:scale-[1.02]">
                <img src="/image2.jpg" class="w-full h-full object-cover" alt="Image 2">
                <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </div>
            <div class="relative group overflow-hidden rounded-2xl aspect-square transition-all duration-300 hover:scale-[1.02]">
                <img src="/image3.jpg" class="w-full h-full object-cover" alt="Image 3">
                <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </div>
            <div class="relative group overflow-hidden rounded-2xl aspect-square transition-all duration-300 hover:scale-[1.02]">
                <img src="/image4.jpg" class="w-full h-full object-cover" alt="Image 4">
                <div class="absolute inset-0 bg-black/40 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <div class="space-y-8">
                <div class="space-y-4">
                    <h1 class="text-5xl font-bold tracking-tight" style="font-family: 'Space Grotesk'"><?php echo $dotenv['EVENT_TITLE']; ?></h1>
                    <p class="text-gray-600 text-lg leading-relaxed"><?php echo $dotenv['EVENT_DESCRIPTION']; ?></p>
                </div>
                
                <div class="inline-flex items-center space-x-6 px-8 py-4 bg-black text-white rounded-full" id="countdown">
                    <div class="text-center">
                        <span class="countdown-days text-2xl font-bold">00</span>
                        <span class="text-xs block mt-1">JOURS</span>
                    </div>
                    <div class="text-center">
                        <span class="countdown-hours text-2xl font-bold">00</span>
                        <span class="text-xs block mt-1">HEURES</span>
                    </div>
                    <div class="text-center">
                        <span class="countdown-minutes text-2xl font-bold">00</span>
                        <span class="text-xs block mt-1">MINUTES</span>
                    </div>
                    <div class="text-center">
                        <span class="countdown-seconds text-2xl font-bold">00</span>
                        <span class="text-xs block mt-1">SECONDES</span>
                    </div>
                </div>
            </div>
            
            <div class="h-[500px] rounded-3xl overflow-hidden shadow-lg" id="map"></div>
        </div>
    </div>

    <script>
    function updateCountdown() {
        const eventDate = new Date('<?php echo $event_date->format('Y-m-d H:i:s'); ?>');
        const now = new Date();
        const diff = eventDate - now;

        const days = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        document.querySelector('.countdown-days').textContent = String(days).padStart(2, '0');
        document.querySelector('.countdown-hours').textContent = String(hours).padStart(2, '0');
        document.querySelector('.countdown-minutes').textContent = String(minutes).padStart(2, '0');
        document.querySelector('.countdown-seconds').textContent = String(seconds).padStart(2, '0');
    }

    setInterval(updateCountdown, 1000);
    updateCountdown();

    mapkit.init({
        authorizationCallback: function(done) {
            done('<?php echo $dotenv['MAPKIT_TOKEN']; ?>');
        }
    });

    const map = new mapkit.Map('map');
    const coordinate = new mapkit.Coordinate(<?php echo $latitude; ?>, <?php echo $longitude; ?>);
    const annotation = new mapkit.MarkerAnnotation(coordinate, {
        color: "#000000",
        title: "<?php echo $address; ?>"
    });

    map.addAnnotation(annotation);
    map.showItems([annotation]);
    </script>
</body>
</html>