<?php
require_once 'db.php';
session_start();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interface de Gestion</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com/2.2.19"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'poppins': ['Poppins', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-white text-gray-900">
    <div class="container mx-auto px-4 py-8">
        <h1 class="text-3xl font-bold mb-8">Interface de Gestion</h1>
        
        <!-- Tabs -->
        <div class="mb-8">
            <div class="border-b border-gray-200">
                <nav class="-mb-px flex">
                    <a href="#" class="user-tab bg-white inline-block p-4 text-gray-600 hover:text-gray-800 font-medium">
                        Gestion Utilisateurs
                    </a>
                    <a href="#" class="doc-tab bg-white inline-block p-4 text-gray-600 hover:text-gray-800 font-medium ml-4">
                        Gestion Documents
                    </a>
                </nav>
            </div>
        </div>

        <!-- Contenu des utilisateurs -->
        <div id="users-content" class="users-section">
            <div class="grid grid-cols-1 gap-4">
                <?php
                $db1 = getDB1Connection();
                $query = $db1->query("SELECT * FROM utilisateurs");
                while($user = $query->fetch(PDO::FETCH_ASSOC)) {
                    echo '<div class="user-card bg-gray-50 p-4 rounded-lg cursor-pointer" 
                          data-user-id="'.$user['id'].'" 
                          data-email="'.htmlspecialchars($user['email']).'"
                          data-username="'.htmlspecialchars($user['username']).'">';
                    echo '<h3 class="font-medium">'.$user['username'].'</h3>';
                    echo '<p class="text-sm text-gray-600">'.$user['email'].'</p>';
                    echo '<p class="text-sm text-gray-500">Note: '.$user['note'].'</p>';
                    echo '</div>';
                }
                ?>
            </div>
        </div>

        <!-- Contenu des documents -->
        <div id="docs-content" class="docs-section hidden">
            <form action="upload_document.php" method="post" enctype="multipart/form-data" class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700">Upload PDF</label>
                    <input type="file" name="pdf_file" accept=".pdf" class="mt-1 block w-full">
                </div>
                <button type="submit" class="bg-black text-white px-4 py-2 rounded-md hover:bg-gray-800">
                    Upload
                </button>
            </form>

            <div class="mt-8">
                <h3 class="text-xl font-medium mb-4">Documents existants</h3>
                <?php
                $db2 = getDB2Connection();
                $query = $db2->query("SELECT * FROM documents");
                while($doc = $query->fetch(PDO::FETCH_ASSOC)) {
                    echo '<div class="bg-gray-50 p-4 rounded-lg mb-2">';
                    echo '<a href="'.$doc['pdf-link'].'" target="_blank" class="text-blue-600 hover:underline">';
                    echo basename($doc['pdf-link']);
                    echo '</a>';
                    echo '</div>';
                }
                ?>
            </div>
        </div>
    </div>

    <!-- Modal de modification utilisateur -->
    <div id="user-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center">
        <div class="bg-white p-6 rounded-lg w-full max-w-md">
            <h2 class="text-xl font-bold mb-4">Modifier l'utilisateur</h2>
            <form id="edit-user-form" class="space-y-4">
                <input type="hidden" id="user-id">
                <div>
                    <label class="block text-sm font-medium">Email</label>
                    <input type="email" id="email" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-sm font-medium">Username</label>
                    <input type="text" id="username" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-sm font-medium">Nouveau mot de passe</label>
                    <input type="password" id="password" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="button" id="close-modal" class="px-4 py-2 border rounded-md">Annuler</button>
                    <button type="submit" class="px-4 py-2 bg-black text-white rounded-md hover:bg-gray-800">
                        Sauvegarder
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // Gestion des onglets
            const userTab = document.querySelector('.user-tab');
            const docTab = document.querySelector('.doc-tab');
            const usersSection = document.querySelector('.users-section');
            const docsSection = document.querySelector('.docs-section');

            userTab.addEventListener('click', (e) => {
                e.preventDefault();
                usersSection.classList.remove('hidden');
                docsSection.classList.add('hidden');
            });

            docTab.addEventListener('click', (e) => {
                e.preventDefault();
                docsSection.classList.remove('hidden');
                usersSection.classList.add('hidden');
            });

            // Gestion du modal
            const modal = document.getElementById('user-modal');
            const closeModal = document.getElementById('close-modal');
            const userCards = document.querySelectorAll('.user-card');

            userCards.forEach(card => {
                card.addEventListener('click', () => {
                    modal.classList.remove('hidden');
                    document.getElementById('user-id').value = card.dataset.userId;
                    document.getElementById('email').value = card.dataset.email;
                    document.getElementById('username').value = card.dataset.username;
                });
            });

            closeModal.addEventListener('click', () => {
                modal.classList.add('hidden');
            });

            // Soumission du formulaire
            document.getElementById('edit-user-form').addEventListener('submit', async (e) => {
                e.preventDefault();
                const formData = new FormData(e.target);
                
                try {
                    const response = await fetch('update_user.php', {
                        method: 'POST',
                        body: formData
                    });
                    
                    const result = await response.json();
                    if(result.success) {
                        alert('Modifications enregistrées avec succès');
                        modal.classList.add('hidden');
                        location.reload();
                    } else {
                        alert('Erreur lors de la modification');
                    }
                } catch(error) {
                    console.error('Erreur:', error);
                    alert('Une erreur est survenue');
                }
            });
        });
    </script>
</body>
</html>