// Ajouter ceci à la liste des modals dans l'objet dom
modals: {
    // ... modals existants
    account: document.getElementById('accountModal')
},

// Ajouter ces éléments à l'objet dom
account: {
    guestView: document.getElementById('guestAccountView'),
    userView: document.getElementById('userAccountView'),
    userName: document.getElementById('accountUserName'),
    userEmail: document.getElementById('accountUserEmail'),
    fullName: document.getElementById('accountFullName'),
    email: document.getElementById('accountEmail'),
    currentPassword: document.getElementById('accountCurrentPassword'),
    newPassword: document.getElementById('accountNewPassword'),
    confirmPassword: document.getElementById('accountConfirmPassword')
},

// Dans la fonction bindEvents(), ajouter ces événements :
dom.buttons.accountSettings.addEventListener('click', openAccountSettings);
document.getElementById('signInFromGuest').addEventListener('click', () => {
    closeModal(dom.modals.account);
    window.location.reload();
});
document.getElementById('createAccountFromGuest').addEventListener('click', () => {
    closeModal(dom.modals.account);
    window.location.reload();
});
document.getElementById('saveAccountChanges').addEventListener('click', saveAccountChanges);
document.getElementById('accountLogout').addEventListener('click', () => {
    closeModal(dom.modals.account);
    logoutUser();
});

// Ajouter ces nouvelles fonctions à la fin du code, avant la dernière accolade
function openAccountSettings() {
    if (app.state.userAuth.isGuest) {
        dom.account.guestView.style.display = 'block';
        dom.account.userView.style.display = 'none';
    } else {
        dom.account.guestView.style.display = 'none';
        dom.account.userView.style.display = 'block';
        
        // Remplir les informations de l'utilisateur
        dom.account.userName.textContent = app.state.userAuth.name;
        dom.account.userEmail.textContent = app.state.userAuth.email;
        dom.account.fullName.value = app.state.userAuth.name;
        dom.account.email.value = app.state.userAuth.email;
        
        // Réinitialiser les champs de mot de passe
        dom.account.currentPassword.value = '';
        dom.account.newPassword.value = '';
        dom.account.confirmPassword.value = '';
    }
    
    openModal(dom.modals.account);
    closeUserDropdown();
}

function saveAccountChanges() {
    const fullName = dom.account.fullName.value;
    const currentPassword = dom.account.currentPassword.value;
    const newPassword = dom.account.newPassword.value;
    const confirmPassword = dom.account.confirmPassword.value;
    
    if (!fullName) {
        showNotification('Please enter your full name', 'error');
        return;
    }
    
    // Si l'utilisateur veut changer le mot de passe
    if (currentPassword || newPassword || confirmPassword) {
        if (!currentPassword) {
            showNotification('Please enter your current password', 'error');
            return;
        }
        
        if (!newPassword) {
            showNotification('Please enter your new password', 'error');
            return;
        }
        
        if (newPassword !== confirmPassword) {
            showNotification('New passwords do not match', 'error');
            return;
        }
        
        if (newPassword.length < 6) {
            showNotification('New password must be at least 6 characters', 'error');
            return;
        }
    }
    
    const btn = dom.account.saveAccountChanges;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<div class="w-4 h-4 border-2 border-white border-t-transparent rounded-full animate-spin mr-2"></div> Updating...';
    btn.disabled = true;
    
    const data = {
        user_id: app.state.userAuth.userId,
        full_name: fullName,
        current_password: currentPassword,
        new_password: newPassword
    };
    
    fetch('db.php?action=updateAccount', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Mettre à jour les informations utilisateur
            app.state.userAuth.name = fullName;
            
            // Mettre à jour l'UI
            dom.userName.textContent = fullName;
            
            // Mettre à jour localStorage
            const userInfo = JSON.parse(localStorage.getItem('trafficLightUser'));
            userInfo.username = fullName;
            localStorage.setItem('trafficLightUser', JSON.stringify(userInfo));
            
            showNotification('Account updated successfully', 'success');
            
            // Réinitialiser les champs de mot de passe
            dom.account.currentPassword.value = '';
            dom.account.newPassword.value = '';
            dom.account.confirmPassword.value = '';
            
            setTimeout(() => {
                closeModal(dom.modals.account);
            }, 1000);
        } else {
            showNotification(data.message || 'Update failed', 'error');
        }
        
        btn.innerHTML = originalText;
        btn.disabled = false;
    })
    .catch(error => {
        console.error('Account update error:', error);
        showNotification('Connection error', 'error');
        
        btn.innerHTML = originalText;
        btn.disabled = false;
    });
}