<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="logo_new.png">
    <title>Vert Chasseur</title>
    
    <meta property="og:title" content="Vert Chasseur - Quartier d'Uccle">
    <meta property="og:description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
    <meta property="og:image" content="https://vertchasseur.com/banner.png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:url" content="https://vertchasseur.com">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Vert Chasseur">
    <meta property="og:locale" content="fr_BE">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Vert Chasseur - Quartier d'Uccle">
    <meta name="twitter:description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
    <meta name="twitter:image" content="https://vertchasseur.com/banner.png">
    
    <meta name="description" content="Vert Chasseur est un quartier à Uccle où vous trouverez de la joie et un havre de paix accueillant. Découvrez les nombreux commerçant du quartier et la joie de vivre du coin.">
    <meta name="keywords" content="Vert Chasseur, Uccle, Bruxelles, quartier, commerces, restaurants">
    <meta name="author" content="Vert Chasseur">
    
    <link rel="canonical" href="https://vertchasseur.com">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {}
            }
        }
    </script>
    <script defer src="https://cloud.umami.is/script.js" data-website-id="6ec552ef-4a61-4f71-a55f-4464703af623"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Princess+Sofia&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Abril+Fatface&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Archivo+Black&display=swap" rel="stylesheet">
    <style>
        @media (min-width: 768px) {
            body {
                background-image: url('font-homepage.png');
                background-size: cover;
                background-position: center;
                background-attachment: fixed;
                background-repeat: no-repeat;
            }
        }
        @media (max-width: 767px) {
            body {
                background-color: #ffffff !important;
                background-image: none !important;
            }
            .dark body {
                background-color: #000000 !important;
                background-image: none !important;
            }
        }
        .card-hover {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-6px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.08);
        }
        .dark .card-hover:hover {
            box-shadow: 0 20px 40px rgba(0,0,0,0.3);
        }
        .txt-chasseur {
            font-family: "Princess Sofia", serif;
            font-weight: 400;
        }
        .txt-ad-title {
            font-family: "Abril Fatface", serif;
            font-weight: 400;
        }
        .police-sandro {
            font-family: "Archivo Black", sans-serif;
            font-weight: 400;
        }
        .deli-gradient {
            background: linear-gradient(90deg, 
                #a9d7d0 0%, 
                #a9d7d0 25%, 
                #ef6f56 25%, 
                #ef6f56 50%, 
                #bbbae3 50%, 
                #bbbae3 75%, 
                #ffe076 75%, 
                #ffe076 100%);
        }
        .pub-image-bg {
            background-image: url('https://www.pa-sport.fr/wp-content/uploads/unnamed-32-2.jpg');
            background-size: cover;
            background-position: center;
        }
    </style>
</head>
<body class="transition-colors duration-300">
<?php include 'header.php'; ?>
    <script>
        if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
            document.documentElement.classList.add('dark');
        }
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
            if (e.matches) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        });
        
        document.addEventListener('DOMContentLoaded', function() {
            const pubContainer = document.getElementById('pub-container');
            
            let visitCount = localStorage.getItem('visitCount');
            
            if (!visitCount) {
                visitCount = 1;
            } else {
                visitCount = parseInt(visitCount) + 1;
            }
            
            localStorage.setItem('visitCount', visitCount);
            
            if (visitCount % 2 === 1) {
                pubContainer.href = "https://vertchasseur.com/shop-details?id=3";
                pubContainer.classList.add('deli-gradient');
                pubContainer.classList.remove('pub-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
                        <div class="absolute top-6 right-6 bg-white/10 text-white text-sm px-3 py-1.5 rounded-full backdrop-blur-sm">
                            <a class="underline" href="https://aktascorp.com/ads">Publicité</a>
                        </div>
                        <div class="max-w-xs space-y-4">
                            <h2 class="text-white text-3xl font-medium leading-tight">
                                Delitraiteur,<br> 
                                le coin de douceur<br> 
                                de Vert Chasseur
                            </h2>
                            <p class="text-white/90 text-base leading-relaxed">
                                Smile and quality, with simplicity.
                            </p>
                            <button class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors">
                                Découvrir
                            </button>
                        </div>
                    </div>
                `;
            } else {
                pubContainer.href = "https://theaceclubparis.com/en-be";
                pubContainer.classList.remove('deli-gradient');
                pubContainer.classList.add('pub-image-bg');
                pubContainer.innerHTML = `
                    <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
                        <div class="absolute top-6 right-6 bg-white/10 text-white text-sm px-3 py-1.5 rounded-full backdrop-blur-sm">
                            <a class="underline" href="https://aktascorp.com/ads">Publicité</a>
                        </div>
                        <div class="max-w-xs space-y-4">
                            <h2 class="text-white text-3xl font-medium leading-tight">
                                Discover<br> 
                                The Ace Club, and preserve the legacy.
                            </h2>
                            <p class="text-white/90 text-base leading-relaxed">
                                Marque de vêtements de sport et de style de vie haut de gamme
                            </p>
                            <button class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors">
                                Explorer
                            </button>
                        </div>
                    </div>
                `;
            }
        });
    </script>

    <main class="min-h-screen flex flex-col items-center justify-center px-4 py-20">
        <div class="text-center max-w-3xl mx-auto mb-12">
            <p class="text-stone-500 dark:text-stone-400 text-sm tracking-wider uppercase mb-6 font-light">Uccle · Bruxelles</p>
            <h1 class="text-5xl md:text-7xl font-light mb-8 text-stone-900 dark:text-white tracking-tight">Bienvenue à <span class="txt-chasseur font-normal">Vert Chasseur</span></h1>
            <p class="text-xl text-stone-600 dark:text-stone-300 leading-relaxed max-w-xl mx-auto font-light mb-8">
                Un havre de paix, qui ne s'arretera jamais.
            </p>
            <div class="bg-white/80 dark:bg-stone-900/80 backdrop-blur-sm rounded-2xl p-6 border border-stone-200/50 dark:border-stone-700/50 max-w-md mx-auto">
                <h2 class="text-lg font-medium text-stone-900 dark:text-white mb-3">Rejoins la communauté</h2>
                <p class="text-stone-600 dark:text-stone-300 text-sm mb-4">Découvre les événements et offres exclusives du quartier</p>
                <a href="https://vertchasseur.com/register" class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2.5 rounded-full font-medium transition-colors w-full block text-center">
                    Créer mon compte
                </a>
            </div>
        </div>

        <div class="w-full max-w-6xl mx-auto grid md:grid-cols-2 lg:grid-cols-3 gap-8 px-4">
            <a id="pub-container" class="card-hover aspect-square group block rounded-2xl overflow-hidden relative">
            </a>

            <div id="ad-container" class="card-hover aspect-square group block rounded-2xl overflow-hidden relative bg-gradient-to-br from-blue-500 to-purple-600">
                <div class="absolute inset-0 flex flex-col justify-end p-8 bg-gradient-to-t from-black/60 to-transparent">
                    <div class="absolute top-6 right-6 bg-white/10 text-white text-xs px-3 py-1.5 rounded-full backdrop-blur-sm">
                        Publicité
                    </div>
                    <div class="max-w-xs space-y-4">
                        <h2 class="text-white text-2xl font-medium leading-tight">
                            Votre publicité ici
                        </h2>
                        <p class="text-white/90 text-sm leading-relaxed">
                            Contactez-nous pour promouvoir votre entreprise dans le quartier Vert Chasseur
                        </p>
                        <a href="https://aktascorp.com/ads" class="bg-white/15 text-white px-6 py-2.5 rounded-full backdrop-blur-sm hover:bg-white/25 transition-colors inline-block text-center">
                            Nous contacter
                        </a>
                    </div>
                </div>
            </div>
            
            <a href="https://vertchasseur.com/shop" class="card-hover aspect-square group block rounded-2xl p-8 bg-white dark:bg-stone-900 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-stone-900 dark:text-white">Commerces & Restaurants</h2>
                        <p class="text-stone-600 dark:text-stone-300 leading-relaxed">Découvrez les établissements qui font la richesse de notre quartier avec une qualité irréprochable dans la majorité.</p>
                    </div>
                    <div class="flex items-center text-stone-900 dark:text-white mt-6 group-hover:translate-x-1 transition-transform">
                        <span class="mr-2 text-sm font-medium">Explorer</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                        </svg>
                    </div>
                </div>
            </a>

            <div class="card-hover aspect-square block rounded-2xl p-8 bg-white dark:bg-stone-900 overflow-hidden">
                <div class="h-full flex flex-col justify-between">
                    <div>
                        <h2 class="text-2xl font-medium mb-4 text-stone-900 dark:text-white"><span class="txt-chasseur">Le poème du jour</span></h2>
                        <p class="text-stone-600 dark:text-stone-300 leading-relaxed">
                            Dans le silence d'un matin pur,<br>
                            La brise chante, douce et sûre.<br>
                            Les arbres dansent, pleins de lumière,<br>
                            Offrant leur paix à l'univers.
                        </p>
                    </div>
                    <p class="text-right text-stone-500 dark:text-stone-400 text-sm italic mt-6">Par Alois Passareiro</p>
                </div>
            </div>
        </div>

        <div class="w-full max-w-6xl mx-auto px-4">
            <div class="bg-stone-100 dark:bg-stone-800 rounded-2xl p-6 border border-stone-200 dark:border-stone-700">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-stone-900 dark:text-white">Publicité</h3>
                    <span class="text-xs text-stone-500 dark:text-stone-400 bg-stone-200 dark:bg-stone-700 px-2 py-1 rounded">Sponsorisé</span>
                </div>
                <div class="grid md:grid-cols-2 gap-6 items-center">
                    <div>
                        <h4 class="text-xl font-medium text-stone-900 dark:text-white mb-3">Besoin d'un service local ?</h4>
                        <p class="text-stone-600 dark:text-stone-300 mb-4">Découvre notre réseau de professionnels de confiance dans le quartier Vert Chasseur.</p>
                        <a href="https://aktascorp.com/ads" class="inline-flex items-center text-emerald-600 dark:text-emerald-400 font-medium hover:text-emerald-700 dark:hover:text-emerald-300">
                            Voir les services
                            <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
                            </svg>
                        </a>
                    </div>
                    <div class="bg-gradient-to-br from-emerald-100 to-teal-100 dark:from-emerald-900/30 dark:to-teal-900/30 rounded-xl p-6 text-center">
                        <div class="w-16 h-16 bg-emerald-500 rounded-full mx-auto mb-3 flex items-center justify-center">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-4m-5 0H3m2 0h4M9 7h6m-6 4h6m-6 4h6"/>
                            </svg>
                        </div>
                        <p class="text-stone-700 dark:text-stone-300 font-medium">Services de proximité</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="w-full py-6 mt-10 border-t border-stone-200 dark:border-stone-800">
        <p class="text-xs text-stone-500 dark:text-stone-400 text-center">© 2025 Vert Chasseur · A <a href="https://aktascorp.com" class="underline hover:text-stone-700 dark:hover:text-stone-300">aktascorp</a> member · <a href="https://aktascorp.com/privacy" class="hover:text-stone-700 dark:hover:text-stone-300">Confidentialité</a></p>
    </footer>
</body>
</html>