<?php
require_once 'config.php';

if(isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT id, username, password FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        header('Location: index.php');
        exit;
    }
    $error = "Invalid credentials";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - ForMore</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Titillium+Web:wght@200;300;400;600;700;900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Titillium Web', sans-serif;
        }
        .formore {
            font-weight: 900;
            background: linear-gradient(to right, #3b82f6, #1d4ed8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-black to-blue-900 min-h-screen text-white">
    <div class="min-h-screen flex items-center justify-center p-6">
        <div class="w-full max-w-md">
            <a href="index.php">
                <h1 class="text-5xl formore text-center mb-12">ForMore</h1>
            </a>

            <div class="bg-gray-800/50 backdrop-blur-sm rounded-2xl p-8">
                <?php if(isset($error)): ?>
                    <div class="bg-red-500/80 backdrop-blur-sm text-white p-4 rounded-xl mb-6 text-center">
                        <?= $error ?>
                    </div>
                <?php endif; ?>

                <form method="POST" class="space-y-6">
                    <div>
                        <input type="text" name="username" required 
                            class="w-full bg-gray-900/50 backdrop-blur-sm border-0 rounded-xl p-4 text-white focus:ring-2 focus:ring-blue-500"
                            placeholder="Username">
                    </div>

                    <div>
                        <input type="password" name="password" required 
                            class="w-full bg-gray-900/50 backdrop-blur-sm border-0 rounded-xl p-4 text-white focus:ring-2 focus:ring-blue-500"
                            placeholder="Password">
                    </div>

                    <div class="flex items-center gap-3">
                        <input type="checkbox" name="adult" required id="adult"
                            class="w-4 h-4 bg-gray-900/50 backdrop-blur-sm border-0 rounded focus:ring-2 focus:ring-blue-500">
                        <label for="adult" class="text-sm text-gray-300">
                            I confirm that I am over 18 years old
                        </label>
                    </div>

                    <button type="submit" name="login" 
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 rounded-xl transition-colors">
                        Sign In
                    </button>

                    <p class="text-center text-gray-400 pt-4">
                        Don't have an account? 
                        <a href="signup.php" class="text-blue-400 hover:text-blue-300 font-semibold">Sign up</a>
                    </p>
                </form>
            </div>
        </div>
    </div>
</body>
</html>