<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IMATORS BANK</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Poppins', sans-serif; }
        .gradient-bg {
            background: linear-gradient(135deg, #1a237e 0%, #0d47a1 100%);
        }
    </style>
</head>
<body class="bg-[#0f172a] text-gray-100">
    <!-- En-tête -->
    <div class="gradient-bg shadow-lg border-b border-blue-900/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex h-16 items-center justify-between">
                <div class="flex items-center">
                    <div class="text-2xl font-bold tracking-tight">IMATORS BANK</div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="text-sm">
                        <div class="text-blue-200"><?= $_SESSION['level'] ?></div>
                        <div class="text-blue-300/80 text-xs"><?= $_SESSION['role'] ?></div>
                    </div>
                    <a href="?logout=1" class="text-sm bg-red-500/10 text-red-300 hover:bg-red-500/20 px-4 py-2 rounded-lg transition-colors">
                        Déconnexion
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Contenu principal -->
    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Statistiques -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Balance -->
            <div class="bg-blue-600/10 rounded-xl border border-blue-500/20 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="text-blue-300/80 text-sm">Balance Totale</div>
                        <div class="text-2xl font-bold text-blue-100 mt-1">
                            <?= format_number($stats['total_balance']) ?>
                        </div>
                    </div>
                    <div class="p-3 bg-blue-500/10 rounded-lg">
                        <svg class="w-8 h-8 text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Comptes bloqués -->
            <div class="bg-red-600/10 rounded-xl border border-red-500/20 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="text-red-300/80 text-sm">Comptes Bloqués</div>
                        <div class="text-2xl font-bold text-red-100 mt-1">
                            <?= $stats['blocked_accounts'] ?>
                        </div>
                    </div>
                    <div class="p-3 bg-red-500/10 rounded-lg">
                        <svg class="w-8 h-8 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m0 4h.01M19 21H5a2 2 0 01-2-2V5a2 2 0 012-2h14a2 2 0 012 2v14a2 2 0 01-2 2zm-8-4h.01"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Montants suspects -->
            <div class="bg-yellow-600/10 rounded-xl border border-yellow-500/20 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="text-yellow-300/80 text-sm">Montants Suspects</div>
                        <div class="text-2xl font-bold text-yellow-100 mt-1">
                            <?= format_number($stats['suspicious_amount']) ?>
                        </div>
                    </div>
                    <div class="p-3 bg-yellow-500/10 rounded-lg">
                        <svg class="w-8 h-8 text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Total utilisateurs -->
            <div class="bg-green-600/10 rounded-xl border border-green-500/20 p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <div class="text-green-300/80 text-sm">Total Utilisateurs</div>
                        <div class="text-2xl font-bold text-green-100 mt-1">
                            <?= $stats['total_users'] ?>
                        </div>
                    </div>
                    <div class="p-3 bg-green-500/10 rounded-lg">
                        <svg class="w-8 h-8 text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                    </div>
                </div>
            </div>
        </div>

        <!-- Liste des comptes -->
        <div class="bg-white/5 rounded-xl border border-white/10 mb-8">
            <div class="p-6 border-b border-white/10">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
                    <h2 class="text-xl font-semibold">Comptes Clients</h2>
                    <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                        <input type="text" id="searchClient" placeholder="Rechercher..."
                               class="bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-sm w-full sm:w-auto">
                        <select id="filterStatus" 
                                class="bg-white/5 border border-white/10 rounded-lg px-4 py-2 text-sm w-full sm:w-auto">
                            <option value="all">Tous les statuts</option>
                            <option value="active">Actifs</option>
                            <option value="blocked">Bloqués</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-left border-b border-white/10">
                            <th class="p-4 text-sm font-medium text-gray-400">Client</th>
                            <th class="p-4 text-sm font-medium text-gray-400">Email</th>
                            <th class="p-4 text-sm font-medium text-gray-400 text-right">Balance</th>
                            <th class="p-4 text-sm font-medium text-gray-400 text-center">Statut</th>
                            <?php if($_SESSION['role'] === 'admin'): ?>
                            <th class="p-4 text-sm font-medium text-gray-400 text-center">Actions</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($users as $user): ?>
                        <tr class="border-b border-white/10 hover:bg-white/5">
                            <td class="p-4">
                                <div class="font-medium"><?= htmlspecialchars($user['firstname'] . ' ' . $user['lastname']) ?></div>
                                <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($user['userid']) ?></div>
                            </td>
                            <td class="p-4">
                                <?= htmlspecialchars($user['email']) ?>
                            </td>
                            <td class="p-4 text-right font-medium">
                                <?= format_number($user['balance']) ?>
                            </td>
                            <td class="p-4 text-center">
                                <?php if($user['blocked-account'] === 'false'): ?>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-red-500/10 text-red-400 gap-1.5">
                                        <span class="w-1.5 h-1.5 rounded-full bg-red-400"></span>
                                        Bloqué
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-500/10 text-green-400 gap-1.5">
                                        <span class="w-1.5 h-1.5 rounded-full bg-green-400"></span>
                                        Actif
                                    </span>
                                <?php endif; ?>
                            </td>
                            <?php if($_SESSION['role'] === 'admin'): ?>
                            <td class="p-4 text-center">
                                <form method="POST" class="inline-block">
                                    <input type="hidden" name="userid" value="<?= htmlspecialchars($user['userid']) ?>">
                                    <?php if($user['blocked-account'] === 'false'): ?>
                                        <button type="submit" name="action" value="unblock" 
                                                class="px-3 py-1.5 text-sm rounded-lg bg-green-500/10 text-green-400 
                                                       hover:bg-green-500/20 transition-colors">
                                            Débloquer
                                        </button>
                                    <?php else: ?>
                                        <button type="submit" name="action" value="block"
                                                onclick="return confirm('Êtes-vous sûr de vouloir bloquer ce compte ?')"
                                                class="px-3 py-1.5 text-sm rounded-lg bg-red-500/10 text-red-400 
                                                       hover:bg-red-500/20 transition-colors">
                                            Bloquer
                                        </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Transactions suspectes -->
        <div class="bg-white/5 rounded-xl border border-white/10">
            <div class="p-6 border-b border-white/10 flex justify-between items-center">
                <h2 class="text-xl font-semibold">Transactions Suspectes</h2>
                <span class="bg-yellow-500/10 text-yellow-400 px-3 py-1.5 rounded-lg text-sm">
                    <?= count($transactions) ?> transactions
                </span>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="text-left border-b border-white/10">
                            <th class="p-4 text-sm font-medium text-gray-400">Transaction</th>
                            <th class="p-4 text-sm font-medium text-gray-400">De</th>
                            <th class="p-4 text-sm font-medium text-gray-400">Vers</th>
                            <th class="p-4 text-sm font-medium text-gray-400 text-right">Montant</th>
                            <th class="p-4 text-sm font-medium text-gray-400 text-right">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($transactions as $trans): ?>
                        <tr class="border-b border-white/10 hover:bg-white/5">
                            <td class="p-4">
                                <div class="font-medium">Transaction #<?= htmlspecialchars($trans['id']) ?></div>
                                <div class="text-xs text-gray-500"><?= htmlspecialchars($trans['type']) ?></div>
                            </td>
                            <td class="p-4">
                                <div class="font-medium"><?= htmlspecialchars($trans['sender_firstname'] . ' ' . $trans['sender_lastname']) ?></div>
                                <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['sender_id']) ?></div>
                            </td>
                            <td class="p-4">
                                <div class="font-medium"><?= htmlspecialchars($trans['recipient_firstname'] . ' ' . $trans['recipient_lastname']) ?></div>
                                <div class="text-xs text-gray-500">ID: <?= htmlspecialchars($trans['recipient_id']) ?></div>
                            </td>
                            <td class="p-4 text-right font-bold text-red-400">
                                <?= format_number($trans['amount']) ?>
                            </td>
                            <td class="p-4 text-right text-gray-500">
                                <?= time_ago($trans['created_at']) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script>
    document.getElementById('searchClient').addEventListener('input', function(e) {
        const searchTerm = e.target.value.toLowerCase();
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(searchTerm) ? '' : 'none';
        });
    });

    document.getElementById('filterStatus').addEventListener('change', function(e) {
        const status = e.target.value;
        const rows = document.querySelectorAll('tbody tr');
        
        rows.forEach(row => {
            if (status === 'all') {
                row.style.display = '';
                return;
            }
            
            const isBlocked = row.querySelector('.text-red-400') !== null;
            const isActive = row.querySelector('.text-green-400') !== null;
            
            if (status === 'blocked' && isBlocked) row.style.display = '';
            else if (status === 'active' && isActive) row.style.display = '';
            else row.style.display = 'none';
        });
    });
    </script>
</body>
</html>