<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Imators</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

        /* Base styles */
        body {
            font-family: 'Inter', sans-serif;
            color: #FFFFFF;
            background-color: #000000;
        }

        /* Header styles */
        .header {
            background-color: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1002;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            height: 70px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        /* Desktop menu */
        .desktop-menu { 
            display: none;
        }

        @media (min-width: 1024px) {
            .desktop-menu {
                display: flex;
            }

            .desktop-menu-item {
                position: relative;
                padding: 1rem;
                cursor: pointer;
                color: #FFFFFF;
                font-weight: 500;
                transition: all 0.3s ease;
                border-radius: 12px;
            }

            .desktop-menu-item:hover {
                color: rgba(255, 255, 255, 0.7);
                background: rgba(255, 255, 255, 0.1);
            }
        }

        /* Desktop submenu */
        .desktop-submenu {
            position: absolute;
            top: calc(100% + 5px);
            left: 50%;
            transform: translateX(-50%) translateY(10px);
            background-color: #000000;
            min-width: 220px;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
            padding: 8px;
        }

        .desktop-menu-item:hover .desktop-submenu {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0);
        }

        .desktop-submenu a {
            display: block;
            padding: 0.75rem 1rem;
            color: #FFFFFF;
            transition: all 0.2s ease;
            border-radius: 12px;
            text-align: center;
        }

        .desktop-submenu a:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        .mobile-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(5px);
    -webkit-backdrop-filter: blur(5px);
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
    z-index: 1000;
}

.mobile-overlay.active {
    opacity: 1;
    visibility: visible;
}

.mobile-menu {
    position: fixed;
    top: 70px;
    left: 0;
    width: 100%;
    height: calc(100vh - 70px);
    background: #000000;
    transform: translateY(-100%);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 1001;
    opacity: 0;
    visibility: hidden;
    overflow-y: auto;
    -webkit-overflow-scrolling: touch;
}

.mobile-menu.active {
    transform: translateY(0);
    opacity: 1;
    visibility: visible;
}

.mobile-menu-header {
    position: sticky;
    top: 0;
    background: #000000;
    z-index: 2;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
}

.menu-title {
    font-size: 1.25rem;
    font-weight: 600;
}

.mobile-menu-items {
    padding: 20px;
    padding-bottom: 40px;
}

.mobile-menu-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px;
    margin-bottom: 12px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 16px;
    cursor: pointer;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.mobile-menu-item:active {
    transform: scale(0.98);
    background: rgba(255, 255, 255, 0.12);
}

.mobile-account-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
    padding: 16px;
    background: #FFFFFF;
    color: #000000;
    border-radius: 16px;
    font-weight: 600;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.mobile-account-btn:active {
    transform: scale(0.98);
    opacity: 0.9;
}

.hamburger {
    width: 40px;
    height: 40px;
    position: relative;
    cursor: pointer;
    z-index: 1003;
    display: none;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

@media (max-width: 1023px) {
    .hamburger {
        display: flex;
    }
}

.hamburger span {
    display: block;
    position: absolute;
    height: 2px;
    width: 20px;
    background: #FFFFFF;
    border-radius: 2px;
    opacity: 1;
    left: 10px;
    transition: transform 0.3s ease-in-out, opacity 0.2s ease-in-out;
}

.hamburger span:nth-child(1) {
    top: 14px;
    transform-origin: center;
}

.hamburger span:nth-child(2) {
    top: 24px;
    transform-origin: center;
}

.hamburger.active span:nth-child(1) {
    transform: translateY(5px) rotate(45deg);
}

.hamburger.active span:nth-child(2) {
    transform: translateY(-5px) rotate(-45deg);
}

.close-button {
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.1);
    border: 1px solid rgba(255, 255, 255, 0.2);
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.mobile-submenu-panel {
    position: fixed;
    top: 70px;
    left: 0;
    width: 100%;
    height: calc(100vh - 70px);
    background: #000000;
    z-index: 1002;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    transform: translateX(100%);
    opacity: 0;
    visibility: hidden;
    overflow-y: auto;
}

.mobile-submenu-panel.active {
    transform: translateX(0);
    opacity: 1;
    visibility: visible;
}

.mobile-submenu-header {
    position: sticky;
    top: 0;
    background: #000000;
    z-index: 2;
    display: flex;
    align-items: center;
    padding: 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    gap: 15px;
    backdrop-filter: blur(10px);
}

.mobile-submenu-content {
    padding: 20px;
    padding-bottom: 40px;
}

.mobile-submenu-link {
    display: block;
    padding: 16px;
    margin-bottom: 12px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 16px;
    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
}

.mobile-submenu-link:active {
    transform: scale(0.98);
    background: rgba(255, 255, 255, 0.12);
}
    </style>
</head>
<body class="h-full">
<header class="header fixed w-full" style="top: 0;">
        <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-full">
            <div class="flex justify-between items-center h-full">
                <!-- Logo -->
                <div class="flex-shrink-0 flex items-center">
                    <a href="/ar/" class="flex items-center">
                        <img src="https://cdn.imators.com/logo.png" alt="شعارات Imators" class="h-6 w-auto md:h-8">
                    </a>
                </div>
                <!-- Desktop Menu -->
            <div class="desktop-menu items-center space-x-6">
                <div class="desktop-menu-item">
                    المنتجات
                    <div class="desktop-submenu">
                        <a href="/ar/progm">Progm</a>
                        <a href="https://ohmypanel.com">OhMyPanel</a>
                        <a href="https://owtiftt.com">Owtfitt</a>
                        <a href="https://formore.tv">ForMore TV</a>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    أدوات المطور
                    <div class="desktop-submenu">
                        <a href="https://imators.systems">أنظمة Imators</a>
                        <a href="https://developer.imators.com">مطور Imators</a>
                    </div>
                </div>
                <div class="desktop-menu-item">
                    الشركة
                    <div class="desktop-submenu">
                        <a href="/ar/about-us">حول Imators</a>
                        <a href="/ar/contact-us">دعم العملاء</a>
                    </div>
                </div>
            </div>

            <!-- Right side buttons -->
            <div class="flex items-center space-x-4">
                <a href="https://idsma.imators.com" class="imators-account-btn lg:flex hidden">
                    حساب Imators
                </a>
                <button id="hamburger" class="hamburger">
                    <span></span>
                    <span></span>
                </button>
            </div>
        </div>
    </nav>
</header>
    
    <div class="mobile-overlay lg:hidden"></div>

    <div class="mobile-menu lg:hidden">
    <div class="mobile-menu-header">
        <span class="menu-title">أنت الآن على الموقع العربي لشركة Imators، يمكنك <a class="underline decoration-sky-500" href="https://imators.com">العودة إلى موقعنا الدولي</a></span>
        </button>
    </div>
    <div class="mobile-menu-items">
    <a href="https://idsma.imators.com" class="mobile-account-btn">
        حساب Imators
    </a>
    <div class="mobile-menu-item" data-submenu="products">
        <span>المنتجات</span>
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M9 18l6-6-6-6"/>
        </svg>
    </div>
    <div class="mobile-menu-item" data-submenu="dev-tools">
        <span>أدوات المطور</span>
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M9 18l6-6-6-6"/>
        </svg>
    </div>
    <div class="mobile-menu-item" data-submenu="company">
        <span>الشركة</span>
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="M9 18l6-6-6-6"/>
        </svg>
    </div>
</div>
</div>
<div class="mobile-submenu-panel" id="products-submenu">
    <div class="mobile-submenu-header">
        <button class="close-button back-button">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M15 18l-6-6 6-6"/>
            </svg>
        </button>
        <span class="menu-title">المنتجات</span>
    </div>
    <div class="mobile-submenu-content">
        <a href="/ar/progm" class="mobile-submenu-link">Progm</a>
        <a href="https://ohmypanel.com" class="mobile-submenu-link">OhMyPanel</a>
        <a href="https://owtiftt.com" class="mobile-submenu-link">Owtfitt</a>
        <a href="https://formore.tv" class="mobile-submenu-link">ForMore TV</a>
    </div>
</div>
<div class="mobile-submenu-panel" id="dev-tools-submenu">
    <div class="mobile-submenu-header">
        <button class="close-button back-button">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M15 18l-6-6 6-6"/>
            </svg>
        </button>
        <span class="menu-title">أدوات المطور</span>
    </div>
    <div class="mobile-submenu-content">
        <a href="https://imators.systems" class="mobile-submenu-link">أنظمة Imators</a>
        <a href="https://developer.imators.com" class="mobile-submenu-link">مطور Imators</a>
    </div>
</div>
<div class="mobile-submenu-panel" id="company-submenu">
    <div class="mobile-submenu-header">
        <button class="close-button back-button">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M15 18l-6-6 6-6"/>
            </svg>
        </button>
        <span class="menu-title">الشركة</span>
    </div>
    <div class="mobile-submenu-content">
        <a href="/ar/about-us" class="mobile-submenu-link">حول Imators</a>
        <a href="/ar/contact-us" class="mobile-submenu-link">دعم العملاء</a>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const hamburger = document.getElementById('hamburger');
    const mobileMenu = document.querySelector('.mobile-menu');
    const mobileOverlay = document.querySelector('.mobile-overlay');
    const closeButton = document.querySelector('.close-button');
    const menuItems = document.querySelectorAll('.mobile-menu-item');
    const backButtons = document.querySelectorAll('.back-button');
    const header = document.querySelector('.header');

    let isTransitioning = false;

    // Fonction pour ouvrir le menu
    const openMenu = () => {
        if (isTransitioning) return;
        
        document.body.classList.add('menu-open');
        mobileOverlay.classList.add('active');
        mobileMenu.classList.add('active');
        hamburger.classList.add('active');
    };

    // Fonction pour fermer le menu
    const closeMenu = () => {
        if (isTransitioning) return;
        
        document.body.classList.remove('menu-open');
        mobileOverlay.classList.remove('active');
        mobileMenu.classList.remove('active');
        hamburger.classList.remove('active');

        // Ferme tous les sous-menus
        document.querySelectorAll('.mobile-submenu-panel').forEach(submenu => {
            submenu.classList.remove('active');
        });
    };

    // Event listeners pour le menu principal
    hamburger.addEventListener('click', () => {
        if(mobileMenu.classList.contains('active')) {
            closeMenu();
        } else {
            openMenu();
        }
    });
    closeButton.addEventListener('click', closeMenu);
    mobileOverlay.addEventListener('click', closeMenu);

    // Gestion des sous-menus
    menuItems.forEach(item => {
        item.addEventListener('click', () => {
            if (isTransitioning) return;
            isTransitioning = true;

            const submenuId = item.getAttribute('data-submenu') + '-submenu';
            const submenu = document.getElementById(submenuId);

            if (submenu) {
                setTimeout(() => {
                    submenu.style.display = 'block';
                    requestAnimationFrame(() => {
                        submenu.classList.add('active');
                    });
                }, 50);
            }

            setTimeout(() => {
                isTransitioning = false;
            }, 300);
        });
    });

    // Gestion des boutons retour
    backButtons.forEach(button => {
        button.addEventListener('click', () => {
            if (isTransitioning) return;
            isTransitioning = true;

            const submenu = button.closest('.mobile-submenu-panel');
            submenu.classList.remove('active');

            setTimeout(() => {
                submenu.style.display = 'none';
            }, 300);

            setTimeout(() => {
                isTransitioning = false;
            }, 300);
        });
    });

    // Gestion du scroll pour le header
    let lastScrollTop = 0;
    let scrollTimeout;

    window.addEventListener('scroll', () => {
        clearTimeout(scrollTimeout);
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;

        // Animation du fond du header
        if (scrollTop > 0) {
            header.style.backgroundColor = 'rgba(0, 0, 0, 0.98)';
        } else {
            header.style.backgroundColor = 'rgba(0, 0, 0, 0.95)';
        }

        // Ne cache pas le header si le menu est ouvert
        if (!mobileMenu.classList.contains('active')) {
            if (Math.abs(scrollTop - lastScrollTop) > 50) {
                if (scrollTop > lastScrollTop && scrollTop > header.offsetHeight) {
                    header.style.transform = 'translateY(-100%)';
                } else {
                    header.style.transform = 'translateY(0)';
                }
                lastScrollTop = scrollTop;
            }
        }

        scrollTimeout = setTimeout(() => {
            header.style.transform = 'translateY(0)';
        }, 1000);
    });

    // Gestion du swipe
    let touchStartY = 0;
    let touchStartX = 0;

    mobileMenu.addEventListener('touchstart', (e) => {
        touchStartY = e.touches[0].clientY;
        touchStartX = e.touches[0].clientX;
    }, { passive: true });

    mobileMenu.addEventListener('touchmove', (e) => {
        if (!touchStartY || !touchStartX) return;

        const touchEndY = e.touches[0].clientY;
        const touchEndX = e.touches[0].clientX;
        const deltaY = touchEndY - touchStartY;
        const deltaX = touchEndX - touchStartX;

        // Si le swipe est plus vertical qu'horizontal et vers le bas
        if (Math.abs(deltaY) > Math.abs(deltaX) && deltaY > 70) {
            closeMenu();
            touchStartY = null;
            touchStartX = null;
        }
    }, { passive: true });

    // Gestion du défilement du body
    document.addEventListener('touchmove', (e) => {
        if (document.body.classList.contains('menu-open')) {
            e.preventDefault();
        }
    }, { passive: false });
});
</script>
</body>
</html>