<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuration base de données
$host = 'mysql4.ouiheberg.com';
$dbname = 's9104_peerkinton';
$username = 'u9104_v7kuXn4gCe';
$password = '.72c0PS3NYY+g=JnY8E=vuA3';

// Codes d'authentification
$auth_codes = [
    'Mr. Aktas' => ['role' => 'admin', 'code' => 'Izhak4455*#@'],
    'Mr. Lafait' => ['role' => 'support', 'code' => 'Lafait2025']
];

// Connexion DB
function connect_db() {
    global $host, $dbname, $username, $password;
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        die("Erreur de connexion : " . $e->getMessage());
    }
}

// Formatage des nombres
function format_number($number) {
    if($number === null) return '0,00 F';
    return number_format($number, 2, ',', ' ') . ' F';
}

// Calcul temps écoulé
function time_ago($datetime) {
    $time = strtotime($datetime);
    $time_diff = time() - $time;
    
    if($time_diff < 60) return "À l'instant";
    if($time_diff < 3600) return floor($time_diff/60) . " min";
    if($time_diff < 86400) return floor($time_diff/3600) . " h";
    if($time_diff < 604800) return floor($time_diff/86400) . " j";
    return date('d/m/Y', $time);
}

// Déconnexion
if(isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Authentification
if(isset($_POST['auth_submit'])) {
    $code = $_POST['auth_code'];
    $found = false;
    
    foreach($auth_codes as $level => $data) {
        if($data['code'] === $code) {
            $_SESSION['auth'] = true;
            $_SESSION['role'] = $data['role'];
            $_SESSION['level'] = $level;
            $found = true;
            break;
        }
    }
    
    if(!$found) {
        $error = "Code d'autorisation invalide";
    }
}

// Actions sur les comptes (block/unblock)
if(isset($_POST['action']) && isset($_SESSION['auth'])) {
    $pdo = connect_db();
    
    switch($_POST['action']) {
        case 'block':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE users SET `blocked-account` = 'true' WHERE userid = ?");
                $stmt->execute([$_POST['userid']]);
            }
            break;
            
        case 'unblock':
            if($_SESSION['role'] === 'admin') {
                $stmt = $pdo->prepare("UPDATE users SET `blocked-account` = 'false' WHERE userid = ?");
                $stmt->execute([$_POST['userid']]);
            }
            break;
    }
    
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Redirection vers login si non authentifié
if(!isset($_SESSION['auth'])) {
    include 'login.php';
    exit;
}

$pdo = connect_db();

// Statistiques
try {
    $stats = [];
    
    // Balance totale
    $balance_query = $pdo->query("SELECT COALESCE(SUM(balance), 0) as total FROM users");
    $stats['total_balance'] = $balance_query->fetch()['total'];
    
    // Total utilisateurs
    $users_query = $pdo->query("SELECT COUNT(*) as count FROM users");
    $stats['total_users'] = $users_query->fetch()['count'];
    
    // Comptes bloqués
    $blocked_query = $pdo->query("SELECT COUNT(*) as count FROM users WHERE `blocked-account` = 'true'");
    $stats['blocked_accounts'] = $blocked_query->fetch()['count'];
    
    // Montant total suspect
    $suspicious_query = $pdo->query("SELECT COALESCE(SUM(amount), 0) as total FROM transactions WHERE amount >= 500000");
    $stats['suspicious_amount'] = $suspicious_query->fetch()['total'];
} catch(PDOException $e) {
    error_log("Erreur stats : " . $e->getMessage());
    $stats = [
        'total_balance' => 0,
        'total_users' => 0,
        'blocked_accounts' => 0,
        'suspicious_amount' => 0
    ];
}

// Récupération des utilisateurs
try {
    $users = $pdo->query("
        SELECT u.*, 
               COUNT(DISTINCT t.id) as transaction_count,
               SUM(CASE WHEN t.amount >= 500000 THEN 1 ELSE 0 END) as suspicious_transactions
        FROM users u
        LEFT JOIN transactions t ON u.userid = t.sender_id
        GROUP BY u.userid
        ORDER BY u.balance DESC
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Erreur users : " . $e->getMessage());
    $users = [];
}

// Récupération des transactions suspectes
try {
    $transactions = $pdo->query("
        SELECT t.*, 
               s.firstname as sender_firstname, s.lastname as sender_lastname,
               r.firstname as recipient_firstname, r.lastname as recipient_lastname
        FROM transactions t
        LEFT JOIN users s ON t.sender_id = s.userid
        LEFT JOIN users r ON t.recipient_id = r.userid
        WHERE t.amount >= 500000
        ORDER BY t.created_at DESC
        LIMIT 50
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Erreur transactions : " . $e->getMessage());
    $transactions = [];
}

include 'dashboard.php';
?>