<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak | Portfolio</title>
    <link href="https://fonts.googleapis.com/css2?family=Assistant:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Assistant', 'ui-sans-serif', 'system-ui']
                    },
                    animation: {
                        'fade-slide': 'fadeSlideIn 0.8s ease-out forwards',
                    },
                    keyframes: {
                        fadeSlideIn: {
                            '0%': { opacity: '0', transform: 'translateY(20px)' },
                            '100%': { opacity: '1', transform: 'translateY(0)' }
                        }
                    }
                }
            }
        }
    </script>
    <style>
        @keyframes blurAppear {
            from { opacity: 0; filter: blur(10px); }
            to { opacity: 1; filter: blur(0); }
        }
        .blur-appear { 
            animation: blurAppear 1s ease-out forwards; 
            opacity: 0;
        }
        body {
            background-color: white;
            color: black;
            scroll-behavior: smooth;
        }
        @media (prefers-color-scheme: dark) {
            body {
                background-color: black;
                color: white;
            }
        }
        .section-indicator {
            position: fixed;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            display: flex;
            flex-direction: column;
            gap: 15px;
            z-index: 50;
        }
        .section-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background-color: rgba(128, 128, 128, 0.5);
            transition: all 0.3s ease;
        }
        .section-dot.active {
            background-color: black;
            width: 15px;
            height: 15px;
        }
        @media (max-width: 768px) {
            .section-indicator {
                left: 10px;
                background-color: rgba(255, 255, 255, 0.2);
                backdrop-filter: blur(10px);
                padding: 10px;
                border-radius: 20px;
            }
            .dark .section-indicator {
                background-color: rgba(0, 0, 0, 0.2);
            }
        }
        .project-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .project-card:hover {
            transform: scale(1.05);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .section-header {
            position: relative;
            padding-bottom: 10px;
        }
        .section-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 50px;
            height: 2px;
            background-color: currentColor;
        }
    </style>
</head>
<body class="font-sans">
    <div class="section-indicator">
        <div class="section-dot" data-section="hero"></div>
        <div class="section-dot" data-section="skills"></div>
        <div class="section-dot" data-section="projects"></div>
        <div class="section-dot" data-section="musicians"></div>
        <div class="section-dot" data-section="movies"></div>
    </div>

    <div class="container mx-auto px-4 max-w-6xl">
        <!-- Section Hero -->
        <section id="hero" class="min-h-screen flex items-center relative">
            <div class="space-y-6">
                <div class="blur-appear">
                    <p class="text-lg text-gray-600 mb-2 tracking-wider">Hello, I am</p>
                    <h1 class="text-5xl mb-4 tracking-tight">Izhak</h1>
                    <p class="text-xl max-w-2xl mb-6 leading-relaxed">
                        CEO of Imators, passionate developer crafting innovative digital experiences with a focus on clean, efficient code and user-centric design.
                    </p>
                </div>
                <div class="h-1 bg-black dark:bg-white w-full opacity-50"></div>
            </div>
        </section>

        <!-- Competences Section -->
        <section id="skills" class="py-16">
            <h2 class="text-4xl section-header mb-8">My Skills</h2>
            <div class="grid md:grid-cols-2 gap-4">
                <div class="animate-fade-slide delay-100 bg-gray-100 dark:bg-gray-900 p-4 rounded">HTML & CSS</div>
                <div class="animate-fade-slide delay-200 bg-gray-100 dark:bg-gray-900 p-4 rounded">PHP</div>
                <div class="animate-fade-slide delay-300 bg-gray-100 dark:bg-gray-900 p-4 rounded">JavaScript</div>
                <div class="animate-fade-slide delay-400 bg-gray-100 dark:bg-gray-900 p-4 rounded">Responsive Design</div>
            </div>
        </section>

        <!-- Projects Section -->
        <section id="projects" class="py-16">
            <h2 class="text-4xl section-header mb-8">Accomplished Projects</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="border p-6 project-card bg-gray-50 dark:bg-gray-900 rounded-lg">
                    <h3 class="text-2xl mb-4">Web Platform</h3>
                    <p class="mb-4 text-gray-700 dark:text-gray-300">Developed a comprehensive web solution integrating multiple services.</p>
                    <p class="mb-4">Language: HTML, PHP, JavaScript</p>
                    <a href="#" class="text-blue-600 hover:underline">View Project</a>
                </div>
                <div class="border p-6 project-card bg-gray-50 dark:bg-gray-900 rounded-lg">
                    <h3 class="text-2xl mb-4">Mobile App</h3>
                    <p class="mb-4 text-gray-700 dark:text-gray-300">Created an intuitive mobile application for enhanced user experience.</p>
                    <p class="mb-4">Language: JavaScript</p>
                    <a href="#" class="text-blue-600 hover:underline">View Project</a>
                </div>
                <div class="border p-6 project-card bg-gray-50 dark:bg-gray-900 rounded-lg">
                    <h3 class="text-2xl mb-4">E-commerce Solution</h3>
                    <p class="mb-4 text-gray-700 dark:text-gray-300">Implemented a scalable e-commerce platform with secure payment integration.</p>
                    <p class="mb-4">Language: PHP, HTML, CSS</p>
                    <a href="#" class="text-blue-600 hover:underline">View Project</a>
                </div>
            </div>
        </section>

        <!-- Favourite Musicians Section -->
        <section id="musicians" class="py-16">
            <h2 class="text-4xl section-header mb-8">Favourite Musicians</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="relative group">
                    <img src="/api/placeholder/400/300" alt="Musician" class="w-full object-cover md:h-64 h-48 rounded-lg">
                    <div class="mt-4">
                        <h3 class="text-2xl mb-1">Artist Name</h3>
                        <a href="#" class="text-blue-600 hover:underline">Apple Music</a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Favourite Movies Section -->
        <section id="movies" class="py-16">
            <h2 class="text-4xl section-header mb-8">Favourite Movies</h2>
            <div class="grid md:grid-cols-3 gap-6">
                <div class="flex flex-col items-center project-card">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4 rounded-lg shadow-lg">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                </div>
                <div class="flex flex-col items-center project-card">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4 rounded-lg shadow-lg">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                </div>
                <div class="flex flex-col items-center project-card">
                    <img src="/api/placeholder/300/450" alt="Movie Poster" class="w-full max-w-[300px] h-[450px] object-cover mb-4 rounded-lg shadow-lg">
                    <h3 class="text-2xl mb-2">Movie Title</h3>
                    <a href="#" class="text-blue-600 hover:underline">Streaming Platform</a>
                </div>
            </div>
        </section>

        <!-- Footer -->
        <footer class="py-8 text-center border-t border-gray-200 dark:border-gray-800">
            <p class="text-gray-600 dark:text-gray-400">&copy; 2024 Izhak. All rights reserved.</p>
        </footer>
    </div>

    <script>
        document.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section');
            const dots = document.querySelectorAll('.section-dot');
            
            sections.forEach((section, index) => {
                const rect = section.getBoundingClientRect();
                if (rect.top <= window.innerHeight / 2 && rect.bottom >= window.innerHeight / 2) {
                    dots.forEach(dot => dot.classList.remove('active'));
                    dots[index].classList.add('active');
                }
            });
        });

        // Activate first dot on page load
        document.querySelector('.section-dot').classList.add('active');
    </script>
</body>
</html>