<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Izhak Aktas</title>
    <link rel="icon" type="image/x-icon" href="https://forchange.me/profile_picture.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://api.fontshare.com/v2/css?f[]=cabinet-grotesk@400,500,700,800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --summer-yellow: #ffedd5;
            --text: #1a1a1a;
            --accent: #f97316;
        }

        body {
            font-family: 'Cabinet Grotesk', sans-serif;
            background-color: var(--summer-yellow);
            color: var(--text);
            position: relative;
            overflow-x: hidden;
        }

        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 400 400' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.9' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.05'/%3E%3C/svg%3E");
            pointer-events: none;
            z-index: 100;
            opacity: 0.5;
        }

        .sun-glow {
            position: fixed;
            top: -180px;
            right: -180px;
            width: 450px;
            height: 450px;
            background: radial-gradient(circle, rgba(255,165,0,0.2) 0%, rgba(255,165,0,0) 70%);
            border-radius: 50%;
            z-index: -1;
            pointer-events: none;
        }

        .sun-flare {
            position: fixed;
            bottom: -120px;
            left: -120px;
            width: 320px;
            height: 320px;
            background: radial-gradient(circle, rgba(255,209,102,0.15) 0%, rgba(255,209,102,0) 70%);
            border-radius: 50%;
            z-index: -1;
            pointer-events: none;
        }

        .header-border {
            border-top: 1px solid var(--text);
            border-bottom: 1px solid var(--text);
            backdrop-filter: blur(10px);
        }

        @keyframes fadeIn {
            from {opacity: 0;transform: translateY(10px);}
            to {opacity: 1;transform: translateY(0);}
        }

        .fade-in {
            opacity: 0;
            animation: fadeIn 0.8s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }
        
        .delay-1 {
            animation-delay: 0.1s;
        }
        
        .delay-2 {
            animation-delay: 0.2s;
        }
        
        .delay-3 {
            animation-delay: 0.3s;
        }
        
        .delay-4 {
            animation-delay: 0.4s;
        }
        
        .nav-bar {
            position: fixed;
            left: 50%;
            transform: translateX(-50%);
            bottom: 2rem;
            background-color: rgba(255, 255, 255, 0.8);
            padding: 0.75rem;
            border-radius: 9999px;
            display: flex;
            gap: 0.75rem;
            opacity: 0;
            transition: all 0.3s ease;
            box-shadow: 0 4px 16px rgba(249, 115, 22, 0.15);
            backdrop-filter: blur(10px);
            z-index: 100;
            border: 1px solid rgba(249, 115, 22, 0.1);
        }

        .nav-button {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 9999px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: transparent;
            color: #1a1a1a;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-button:hover {
            background-color: rgba(249, 115, 22, 0.1);
        }

        .nav-button.active {
            background-color: var(--accent);
            color: white;
        }

        .nav-button i {
            font-size: 1.1rem;
        }

        .main-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1rem;
        }

        @media (min-width: 640px) {
            .main-container {
                padding: 0 2rem;
            }
        }

        section {
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding: 4rem 0;
            position: relative;
        }

        @media (min-width: 768px) {
            section {
                padding: 6rem 0;
            }
        }

        .hover-scale {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .hover-scale:hover {
            transform: scale(1.02);
            box-shadow: 0 8px 24px rgba(249, 115, 22, 0.1);
        }

        .section-title {
            font-weight: 300;
            letter-spacing: -0.01em;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            padding-bottom: 0.5rem;
            background: linear-gradient(90deg, var(--text) 0%, var(--accent) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            display: inline-block;
        }

        .card {
            background-color: rgba(255, 255, 255, 0.5);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            border: 1px solid rgba(249, 115, 22, 0.1);
            overflow: hidden;
            position: relative;
        }

        .card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--accent) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .card:hover::before {
            opacity: 1;
        }

        .tag {
            font-size: 0.75rem;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            background-color: rgba(249, 115, 22, 0.1);
            color: var(--accent);
            transition: all 0.3s ease;
        }

        .tag:hover {
            background-color: rgba(249, 115, 22, 0.2);
        }

        .summer-gradient {
            background: linear-gradient(120deg, #f97316 0%, #f59e0b 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .project-image {
            transition: transform 0.6s ease;
        }

        .hover-scale:hover .project-image {
            transform: scale(1.05);
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 2.5rem;
            }
            h2 {
                font-size: 2rem;
            }
            .header-content {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }
            .sun-glow, .sun-flare {
                opacity: 0.5;
            }
        }
    </style>
</head>
<body class="min-h-screen">
    <div class="sun-glow"></div>
    <div class="sun-flare"></div>

    <header class="header-border py-6 mb-16 fade-in sticky top-0 bg-[#ffedd5]/90 z-50">
        <div class="main-container">
            <div class="flex justify-between items-center">
                <h1 class="text-5xl md:text-6xl font-light tracking-tight">
                    Izhak
                </h1>
                <p class="text-sm font-light max-w-xs text-right leading-relaxed">
                    Web Developer & Ceo of <span class="summer-gradient font-medium">Imators</span>
                </p>
            </div>
        </div>
    </header>

    <main class="main-container">
        <section id="intro" class="mb-16">
            <div class="max-w-2xl">
                <span class="inline-block text-sm font-light tracking-wide mb-4 fade-in delay-1">
                    Summer Vibes ☀️
                </span>
                <h2 class="text-4xl md:text-5xl font-light tracking-tight mb-6 fade-in delay-2">
                    To <span class="summer-gradient font-medium">fascinate</span>, discover and put a smile on your face
                </h2>
                <p class="text-lg font-light leading-relaxed mb-12 fade-in delay-3">
                    For me, every day makes us learn something or makes us enjoy everyday life. My goal has always been to share, observe and appreciate the moment day by day
                </p>
                <a href="https://discord.com/users/866001325657292801" class="bg-[#f97316] text-white px-8 py-3 rounded-full text-sm font-light tracking-wide fade-in delay-4 hover:bg-[#ea580c] transition-colors inline-block shadow-lg shadow-orange-200">
                    Talk with me  <i class="fa-brands fa-discord" style="color: #ffffff;"></i>
                </a>
            </div>
        </section>

        <section id="about" class="mb-16">
            <h2 class="text-4xl font-light mb-12 section-title">ABOUT ME</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16">
                <div class="space-y-6 card p-8 hover-scale">
                    <p class="text-lg font-light leading-relaxed">
                        I'm a web developer and entrepreneur based in Europe. My journey in tech started with a simple curiosity about how websites work, and it has evolved into a passion for creating digital experiences that matter.
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        As the CEO of Imators, I lead a team dedicated to developing technology that enhances daily life without compromising human connection. We believe in innovation that serves people, not the other way around.
                    </p>
                </div>
                <div class="space-y-6 card p-8 hover-scale">
                    <p class="text-lg font-light leading-relaxed">
                        I have over three years' experience in web design and development. My passion began by creating small websites, then learning, discovering and being able to create with joy and enthusiasm. I love designing with minimalism and modernity. 
                    </p>
                    <p class="text-lg font-light leading-relaxed">
                        My goal has always been to make people have a pleasant experience with me and above all to establish a correct social bond. I go beyond the mission/project/... : I enter the mindset of customers to really understand how they want their request.
                    </p>
                </div>
            </div>
        </section>
        
        <section id="projects" class="mb-16">
            <h2 class="text-4xl font-light mb-12 section-title">MY PROJECTS</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16">
                <div class="space-y-8 hover-scale card p-6">
                    <div class="aspect-video overflow-hidden rounded-lg shadow-md">
                        <img src="https://opengraph.b-cdn.net/production/images/c2346076-5c2d-4af5-bc04-93187bd10074.png?token=htWPJq1jtmC6T1l0lrysm0HzFmIEpPZpdfjbd2qnjX8&height=630&width=1200&expires=33264233001" alt="Imators Platform" class="w-full h-full object-cover project-image">
                    </div>
                    <div class="space-y-4">
                        <div class="flex justify-between items-start">
                            <h3 class="text-2xl font-light">Imators</h3>
                            <span class="tag shadow-sm">2022</span>
                        </div>
                        <p class="text-lg font-light leading-relaxed">
                            Imators is my company. When I set up the company, I had the overriding objective of never using AI for automation or any other purpose. Our aim is to preserve the human being and push him forward by letting him be the actor of what he owns. No one will make decisions for them or do anything for them. We bring everyday technological products to change people's lives 
                        </p>
                        <div class="flex gap-4 flex-wrap">
                            <span class="tag shadow-sm">PHP</span>
                            <span class="tag shadow-sm">HTML</span>
                            <span class="tag shadow-sm">JS</span>
                        </div>
                        <a href="https://imators.com" class="inline-flex items-center gap-2 text-sm hover:underline text-[#f97316]">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="space-y-8 hover-scale card p-6">
                    <div class="aspect-video overflow-hidden rounded-lg shadow-md">
                        <img src="https://www.worldclassweddingvenues.com/Images/worldclassweddingvenues/User_0/Venue_17816/villattitude-exterieur-11-copie.jpg" alt="ForChange Portfolio" class="w-full h-full object-cover project-image">
                    </div>
                    <div class="space-y-4">
                        <div class="flex justify-between items-start">
                            <h3 class="text-2xl font-light">Vert Chasseur</h3>
                            <span class="tag shadow-sm">2025</span>
                        </div>
                        <p class="text-lg font-light leading-relaxed">
                            The aim of this site is to provide a little hobby.
                I designed it for the area where I spend most of my days. I'm going to make it progress little by little but it's not my priority, just a little occupation ;)
                        </p>
                        <div class="flex gap-4 flex-wrap">
                            <span class="tag shadow-sm">PHP</span>
                            <span class="tag shadow-sm">HTML</span>
                            <span class="tag shadow-sm">JS</span>
                            <span class="tag shadow-sm">SQL</span>                     
                        </div>
                        <a href="https://vertchasseur.com" class="inline-flex items-center gap-2 text-sm hover:underline text-[#f97316]">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="space-y-8 hover-scale card p-6">
                    <div class="aspect-video overflow-hidden rounded-lg shadow-md">
                        <img src="https://opengraph.b-cdn.net/production/images/7d08cca6-56aa-42d1-a641-f9f44914ea12.png?token=jXDBoGRjIgGiGA3pNhDAtPJ8odoJIiQ_1zznvH6RNR0&height=630&width=1200&expires=33258602552" alt="AI Content Generator" class="w-full h-full object-cover project-image">
                    </div>
                    <div class="space-y-4">
                        <div class="flex justify-between items-start">
                            <h3 class="text-2xl font-light">Gemance</h3>
                            <span class="tag shadow-sm">2023</span>
                        </div>
                        <p class="text-lg font-light leading-relaxed">
                            For a brief moment, I was thinking of selling the stones I was collecting. Unfortunately this project was going to take me too much time. So I left them on display
                        </p>
                        <div class="flex gap-4 flex-wrap">
                            <span class="tag shadow-sm">HTML</span>
                            <span class="tag shadow-sm">JS</span>
                            <span class="tag shadow-sm">StripeAPI</span>
                        </div>
                        <a href="https://www.gemance.com/" class="inline-flex items-center gap-2 text-sm hover:underline text-[#f97316]">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="space-y-8 hover-scale card p-6">
                    <div class="aspect-video overflow-hidden rounded-lg shadow-md">
                        <img src="peerkinton_image.png" alt="ForChange Portfolio" class="w-full h-full object-cover project-image">
                    </div>
                    <div class="space-y-4">
                        <div class="flex justify-between items-start">
                            <h3 class="text-2xl font-light">Peerkinton</h3>
                            <span class="tag shadow-sm">2025</span>
                        </div>
                        <p class="text-lg font-light leading-relaxed">
                        Peerkinton was founded in England in March 2016. The aim in creating Peerkinton was to create an institution dedicated to technological learning and study by offering our members high-end digital access. Our institute collects data and profiles from our students and allows them to publish it, work on it, and show human knowledge
                        </p>
                        <div class="flex gap-4 flex-wrap">
                            <span class="tag shadow-sm">PHP</span>
                            <span class="tag shadow-sm">HTML</span>
                            <span class="tag shadow-sm">JS</span>
                            <span class="tag shadow-sm">SQL</span>                     
                        </div>
                        <a href="https://peerkinton.com" class="inline-flex items-center gap-2 text-sm hover:underline text-[#f97316]">
                            Visit website
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="7" y1="17" x2="17" y2="7"></line>
                                <polyline points="7 7 17 7 17 17"></polyline>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <section id="details" class="mb-16">
            <h2 class="text-4xl font-light mb-12 section-title">DETAILS</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="card p-8 hover-scale space-y-4">
                    <div class="flex items-center justify-between">
                        <h3 class="text-2xl font-light">Experience</h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="#f97316" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-briefcase">
                            <rect x="2" y="7" width="20" height="14" rx="2" ry="2"></rect>
                            <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"></path>
                        </svg>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Years Active</span>
                            <span class="font-medium">3+</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Projects Completed*</span>
                            <span class="font-medium">257+</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Companies Founded</span>
                            <span class="font-medium">1</span>
                        </div>
                    </div>
                </div>

                <div class="card p-8 hover-scale space-y-4">
                    <div class="flex items-center justify-between">
                        <h3 class="text-2xl font-light">I code with</h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="#f97316" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-code">
                            <polyline points="16 18 22 12 16 6"></polyline>
                            <polyline points="8 6 2 12 8 18"></polyline>
                        </svg>
                    </div>
                    <div class="flex flex-wrap gap-2">
                        <span class="tag shadow-sm">HTML</span>
                        <span class="tag shadow-sm">CSS</span>
                        <span class="tag shadow-sm">JavaScript</span>
                        <span class="tag shadow-sm">Java</span>
                        <span class="tag shadow-sm">PHP</span>
                        <span class="tag shadow-sm">SQL</span>
                        <span class="tag shadow-sm">Apache</span>
                        <span class="tag shadow-sm">Python</span>
                        <span class="tag shadow-sm">C++</span>
                    </div>
                </div>

                <div class="card p-8 hover-scale space-y-4">
                    <div class="flex items-center justify-between">
                        <h3 class="text-2xl font-light">Current Focus</h3>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="#f97316" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-target">
                            <circle cx="12" cy="12" r="10"></circle>
                            <circle cx="12" cy="12" r="6"></circle>
                            <circle cx="12" cy="12" r="2"></circle>
                        </svg>
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Main Project</span>
                            <span class="font-medium">Imators</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Learning</span>
                            <span class="font-medium">React Native</span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm">Location</span>
                            <span class="font-medium">Europe</span>
                        </div>
                        <p class="text-xs italic">Last updated on February 7 at 18:46</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="music" class="mb-16">
            <h2 class="text-4xl font-light mb-12 section-title">MY FAVORITE ALBUMS</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://media.pitchfork.com/photos/6662e6122ce1ce711b18e944/master/w_1280%2Cc_limit/Sabrina-Carpenter-Short-n-Sweet.jpg" 
                             class="w-full h-full object-cover project-image" alt="Short n Sweet album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Short n' Sweet</h3>
                        <p class="text-gray-700 text-sm">Sabrina Carpenter</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/uk/album/short-n-sweet/1750307020" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b273d0bbd3ea2ec554f17a6603cc" 
                             class="w-full h-full object-cover project-image" alt="Silk Sonic album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">An Evening with Silk Sonic</h3>
                        <p class="text-gray-700 text-sm">Bruno Mars & Anderson .Paak</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/album/short-n-sweet/1728313338" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b273e8107e6d9214baa81bb79bba" 
                             class="w-full h-full object-cover project-image" alt="Girl album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">GIRL</h3>
                        <p class="text-gray-700 text-sm">Pharrell Williams</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/g-i-r-l/863835302" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b2734bc66095f8a70bc4e6593f4f" 
                             class="w-full h-full object-cover project-image" alt="Future Nostalgia album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Future Nostalgia</h3>
                        <p class="text-gray-700 text-sm">Dua Lipa</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/future-nostalgia/1538003494" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b2738863bc11d2aa12b54f5aeb36" 
                             class="w-full h-full object-cover project-image" alt="After Hours album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">After Hours</h3>
                        <p class="text-gray-700 text-sm">The Weeknd</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/after-hours/1499378108" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b273cce6bab1f59b165133175d88" 
                             class="w-full h-full object-cover project-image" alt="Witness album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Witness</h3>
                        <p class="text-gray-700 text-sm">Katy Perry</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/witness/1395619660" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b2731e9a057052d59004caf47e22" 
                             class="w-full h-full object-cover project-image" alt="PRISM album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">PRISM</h3>
                        <p class="text-gray-700 text-sm">Katy Perry</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/prism/1440818542" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-square overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://i.scdn.co/image/ab67616d0000b27326f7f19c7f0381e56156c94a" 
                             class="w-full h-full object-cover project-image" alt="Graduation album">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Graduation</h3>
                        <p class="text-gray-700 text-sm">Kanye West</p>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://music.apple.com/be/album/graduation/1451901307" class="text-sm hover:underline">Apple Music</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <section id="media" class="mb-16">
            <h2 class="text-4xl font-light mb-12 section-title">MY FAVORITE SERIES & MOVIES</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
                <div class="hover-scale card p-4">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://seriesonweb.com/wp-content/uploads/2024/04/Sugar.jpg" 
                             class="w-full h-full object-cover project-image" alt="Sugar">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Sugar</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://tv.apple.com/be/show/sugar/umc.cmc.4r6q7tdquewehwvb3rzl0k3dtm" class="text-sm hover:underline">Apple TV+</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://preview.redd.it/fly-me-to-the-moon-2024-textless-v0-y4htoeerwezc1.jpeg?auto=webp&s=841eca3463d5408f09090df6a2a7e645eee100f9" 
                             class="w-full h-full object-cover project-image" alt="To The Moon">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">To The Moon</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://tv.apple.com/be/movie/to-the-moon/umc.cmc.7bwrikjdeik56bk49vlr7c1h6" class="text-sm hover:underline">Apple TV+</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="Apple_TV_The_Gorge_key_art_2_3.png" 
                             class="w-full h-full object-cover project-image" alt="The Gorge">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">The Gorge</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://tv.apple.com/us/movie/the-gorge/umc.cmc.26o403koqo2klixc0jtqy6tmc" class="text-sm hover:underline">Apple TV+</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://upload.wikimedia.org/wikipedia/en/6/60/Manhunt_Apple_TV_poster.png" 
                             class="w-full h-full object-cover project-image" alt="Manhunt">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Manhunt</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="https://tv.apple.com/be/show/manhunt/umc.cmc.3uqhvdplroersd5p2l72udkal" class="text-sm hover:underline">Apple TV+</a>
                        </div>
                    </div>
                </div>

                <div class="hover-scale card p-4">
                    <div class="aspect-[2/3] overflow-hidden rounded-lg shadow-md mb-4">
                        <img src="https://resize.elle.fr/original/var/plain_site/storage/images/loisirs/series/ces-films-et-series-a-regarder-si-vous-avez-aime-lupin-dans-l-ombre-d-arsene/94289862-3-fre-FR/7-films-et-series-a-regarder-si-vous-avez-aime-Lupin-dans-l-ombre-d-Arsene.jpg" 
                             class="w-full h-full object-cover project-image" alt="Lupin">
                    </div>
                    <div class="space-y-2">
                        <h3 class="text-xl font-medium text-[#f97316]">Lupin</h3>
                        <div class="flex items-center gap-2">
                            <span class="w-2 h-2 bg-[#f97316] rounded-full"></span>
                            <a href="#" class="text-sm hover:underline">Netflix</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="py-12 text-center text-sm font-light border-t border-black/5 mt-16 relative overflow-hidden">
        <div class="absolute inset-0 opacity-10 bg-gradient-to-r from-orange-200 to-orange-400 z-[-1]"></div>
        <div class="main-container">
            <p>Designed with a smile by Izhak. @forchange </p>
            <p class="text-xs mt-2 text-black/70">The images used on this site are for illustrative purposes only.</p>
            <p class="text-xs mt-1 text-black/70">*This number indicates the number of customer projects realised and not mine</p>
        </div>
    </footer>

    <nav class="nav-bar">
        <button class="nav-button" data-section="1">
            <i class="fas fa-home"></i>
        </button>
        <button class="nav-button" data-section="2">
            <i class="fas fa-user"></i>
        </button>
        <button class="nav-button" data-section="3">
            <i class="fas fa-briefcase"></i>
        </button>
        <button class="nav-button" data-section="4">
            <i class="fas fa-list"></i>
        </button>
        <button class="nav-button" data-section="5">
            <i class="fas fa-music"></i>
        </button>
        <button class="nav-button" data-section="6">
            <i class="fas fa-film"></i>
        </button>
    </nav>
</body>
</html>