<?php
$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$member_id = isset($_GET['member']) ? intval($_GET['member']) : null;

// Vérifier que seuls les admins puissent inviter ou gérer les membres
if (($action === 'invite' || $action === 'remove' || $action === 'update_role') && !$is_admin) {
    header("Location: ?page=members");
    exit;
}

// Traitement des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'invite' && $is_admin) {
        $email = isset($_POST['email']) ? trim($_POST['email']) : '';
        $name = isset($_POST['name']) ? trim($_POST['name']) : '';
        $role = isset($_POST['role']) ? $_POST['role'] : 'member';
        
        if (!empty($email) && !empty($name) && filter_var($email, FILTER_VALIDATE_EMAIL)) {
            // Générer un token d'invitation
            $token = bin2hex(random_bytes(16));
            $expiry = date('Y-m-d H:i:s', strtotime('+48 hours'));
            
            // Vérifier si l'utilisateur existe déjà
            $stmt = $db->prepare("SELECT id FROM utilisateurs WHERE email = ?");
            $stmt->execute([$email]);
            $existing_user = $stmt->fetch();
            
            if ($existing_user) {
                // Vérifier si l'utilisateur est déjà membre de cette famille
                $stmt = $db->prepare("SELECT id FROM family_members WHERE family_site_id = ? AND user_id = ?");
                $stmt->execute([$family_id, $existing_user['id']]);
                $already_member = $stmt->fetch();
                
                if ($already_member) {
                    $error = "This person is already a member of your family.";
                } else {
                    // Ajouter directement l'utilisateur existant comme membre
                    $stmt = $db->prepare("INSERT INTO family_members (family_site_id, user_id, role) VALUES (?, ?, ?)");
                    $stmt->execute([$family_id, $existing_user['id'], $role]);
                    
                    // Envoyer un email de notification
                    $invite_url = $site_url;
                    
                    $to = $email;
                    $subject = "You've been added to " . $family['family_name'] . " family hub";
                    
                    $headers = "MIME-Version: 1.0" . "\r\n";
                    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                    $headers .= 'From: AndWeare <noreply@andweare.com>' . "\r\n";
                    
                    $message = '
                    <html>
                    <head>
                        <title>Welcome to ' . htmlspecialchars($family['family_name']) . ' Family Hub</title>
                    </head>
                    <body>
                        <div style="max-width: 600px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif;">
                            <div style="text-align: center; margin-bottom: 20px;">
                                <img src="https://andweare.com/images/logo.png" alt="AndWeare Logo" style="height: 40px;">
                            </div>
                            <div style="background-color: #f9f9f9; border-radius: 10px; padding: 20px; margin-bottom: 20px;">
                                <h2 style="color: #333; margin-top: 0;">Welcome to ' . htmlspecialchars($family['family_name']) . ' Family Hub!</h2>
                                <p style="color: #666;">
                                    <strong>' . htmlspecialchars($current_user['username']) . '</strong> has added you to the ' . htmlspecialchars($family['family_name']) . ' family on AndWeare.
                                </p>
                                <p style="color: #666;">
                                    You can access your family hub by clicking the button below:
                                </p>
                                <div style="text-align: center; margin: 30px 0;">
                                    <a href="' . $invite_url . '" style="background-color: #4F46E5; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                        Go to Family Hub
                                    </a>
                                </div>
                            </div>
                            <div style="color: #999; font-size: 12px; text-align: center;">
                                <p>
                                    This email was sent from <a href="https://andweare.com" style="color: #4F46E5;">AndWeare</a>, a platform for creating private family hubs.
                                </p>
                            </div>
                        </div>
                    </body>
                    </html>
                    ';
                    
                    mail($to, $subject, $message, $headers);
                    
                    $success = "Member added successfully! They have been notified via email.";
                }
            } else {
                // Créer une invitation pour un nouvel utilisateur
                $stmt = $db->prepare("INSERT INTO family_invitations (family_id, email, name, role, token, created_by, expires_at) VALUES (?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$family_id, $email, $name, $role, $token, $user_id, $expiry]);
                
                // Construire l'URL d'invitation
                $invite_url = 'https://andweare.com/join/' . $token;
                
                // Envoyer un email d'invitation
                $to = $email;
                $subject = "You're invited to join " . $family['family_name'] . " family hub";
                
                $headers = "MIME-Version: 1.0" . "\r\n";
                $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                $headers .= 'From: AndWeare <noreply@andweare.com>' . "\r\n";
                
                $message = '
                <html>
                <head>
                    <title>Invitation to ' . htmlspecialchars($family['family_name']) . ' Family Hub</title>
                </head>
                <body>
                    <div style="max-width: 600px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif;">
                        <div style="text-align: center; margin-bottom: 20px;">
                            <img src="https://andweare.com/images/logo.png" alt="AndWeare Logo" style="height: 40px;">
                        </div>
                        <div style="background-color: #f9f9f9; border-radius: 10px; padding: 20px; margin-bottom: 20px;">
                            <h2 style="color: #333; margin-top: 0;">You\'re Invited!</h2>
                            <p style="color: #666;">
                                <strong>' . htmlspecialchars($current_user['username']) . '</strong> has invited you to join the ' . htmlspecialchars($family['family_name']) . ' family on AndWeare.
                            </p>
                            <p style="color: #666;">
                                AndWeare is a platform where families can share photos, track important dates, and stay connected in a private online space.
                            </p>
                            <p style="color: #666;">
                                Join your family by clicking the button below:
                            </p>
                            <div style="text-align: center; margin: 30px 0;">
                                <a href="' . $invite_url . '" style="background-color: #4F46E5; color: white; padding: 12px 24px; text-decoration: none; border-radius: 5px; font-weight: bold;">
                                    Accept Invitation
                                </a>
                            </div>
                            <p style="color: #999; font-size: 14px;">
                                This invitation expires in 48 hours.
                            </p>
                        </div>
                        <div style="color: #999; font-size: 12px; text-align: center;">
                            <p>
                                If you received this email by mistake, simply delete it. You won\'t be added to any mailing list.
                            </p>
                        </div>
                    </div>
                </body>
                </html>
                ';
                
                mail($to, $subject, $message, $headers);
                
                $success = "Invitation sent successfully!";
            }
        } else {
            $error = "Please enter a valid name and email address.";
        }
    } else if ($action === 'update_role' && $is_admin) {
        $member_id = isset($_POST['member_id']) ? intval($_POST['member_id']) : 0;
        $role = isset($_POST['role']) ? $_POST['role'] : 'member';
        
        // Vérifier que ce n'est pas l'admin principal qui est modifié
        $stmt = $db->prepare("SELECT user_id FROM family_members WHERE id = ? AND family_site_id = ?");
        $stmt->execute([$member_id, $family_id]);
        $member_to_update = $stmt->fetch();
        
        $stmt = $db->prepare("SELECT created_by FROM family_sites WHERE id = ?");
        $stmt->execute([$family_id]);
        $family_creator = $stmt->fetch();
        
        if ($member_to_update && $member_to_update['user_id'] == $family_creator['created_by'] && $role != 'admin') {
            $error = "You cannot change the role of the family creator.";
        } else if ($member_to_update) {
            $stmt = $db->prepare("UPDATE family_members SET role = ? WHERE id = ? AND family_site_id = ?");
            $stmt->execute([$role, $member_id, $family_id]);
            
            $success = "Member role updated successfully!";
        }
    }
}

// Action de suppression de membre
if ($action === 'remove' && $is_admin && $member_id) {
    // Vérifier que ce n'est pas l'admin principal qui est supprimé
    $stmt = $db->prepare("SELECT fm.user_id FROM family_members fm JOIN family_sites fs ON fm.family_site_id = fs.id WHERE fm.id = ? AND fm.family_site_id = ?");
    $stmt->execute([$member_id, $family_id]);
    $member_to_remove = $stmt->fetch();
    
    $stmt = $db->prepare("SELECT created_by FROM family_sites WHERE id = ?");
    $stmt->execute([$family_id]);
    $family_creator = $stmt->fetch();
    
    if ($member_to_remove && $member_to_remove['user_id'] == $family_creator['created_by']) {
        $error = "You cannot remove the family creator.";
    } else if ($member_to_remove) {
        $stmt = $db->prepare("DELETE FROM family_members WHERE id = ? AND family_site_id = ?");
        $stmt->execute([$member_id, $family_id]);
        
        $success = "Member removed successfully!";
    }
    
    if (!isset($error)) {
        header("Location: ?page=members");
        exit;
    }
}

// Action d'annulation d'invitation
if ($action === 'cancel_invite' && $is_admin) {
    $invite_id = isset($_GET['invite']) ? intval($_GET['invite']) : null;
    
    if ($invite_id) {
        $stmt = $db->prepare("DELETE FROM family_invitations WHERE id = ? AND family_id = ?");
        $stmt->execute([$invite_id, $family_id]);
        
        $success = "Invitation cancelled successfully!";
        header("Location: ?page=members");
        exit;
    }
}

// Récupérer les membres de la famille
$stmt = $db->prepare("
    SELECT fm.*, u.username, u.email, u.profile_photo 
    FROM family_members fm 
    JOIN utilisateurs u ON fm.user_id = u.id 
    WHERE fm.family_site_id = ? 
    ORDER BY FIELD(fm.role, 'admin', 'editor', 'member'), u.username
");
$stmt->execute([$family_id]);
$members = $stmt->fetchAll();

// Récupérer les invitations en cours
$stmt = $db->prepare("
    SELECT * FROM family_invitations 
    WHERE family_id = ? AND expires_at > NOW() 
    ORDER BY created_at DESC
");
$stmt->execute([$family_id]);
$invitations = $stmt->fetchAll();

// Récupérer l'ID du créateur de la famille
$stmt = $db->prepare("SELECT created_by FROM family_sites WHERE id = ?");
$stmt->execute([$family_id]);
$family_creator = $stmt->fetch();
$creator_id = $family_creator ? $family_creator['created_by'] : 0;
?>

<div class="mb-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Family Members</h1>
        <?php if ($is_admin): ?>
            <button class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition" onclick="document.getElementById('invite-modal').classList.remove('hidden')">
                Invite Member
            </button>
        <?php endif; ?>
    </div>
    
    <?php if (isset($error)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>
    
    <?php if (isset($success)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo htmlspecialchars($success); ?>
        </div>
    <?php endif; ?>
    
    <!-- Current Members -->
    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <h2 class="text-lg font-bold mb-4">Members (<?php echo count($members); ?>)</h2>
        
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Member
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Email
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Role
                        </th>
                        <?php if ($is_admin): ?>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($members as $member): ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <?php if ($member['profile_photo']): ?>
                                            <img class="h-10 w-10 rounded-full" src="<?php echo htmlspecialchars($member['profile_photo']); ?>" alt="">
                                        <?php else: ?>
                                            <div class="h-10 w-10 rounded-full bg-indigo-100 flex items-center justify-center text-indigo-500">
                                                <?php echo htmlspecialchars(strtoupper(substr($member['username'], 0, 1))); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900">
                                            <?php echo htmlspecialchars($member['username']); ?>
                                            <?php if ($member['user_id'] == $creator_id): ?>
                                                <span class="ml-2 px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                                    Creator
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500"><?php echo htmlspecialchars($member['email']); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php if ($is_admin && $member['user_id'] != $user_id && $member['user_id'] != $creator_id): ?>
                                    <form method="POST" action="?page=members&action=update_role" class="inline-block">
                                        <input type="hidden" name="member_id" value="<?php echo $member['id']; ?>">
                                        <select name="role" onchange="this.form.submit()" class="text-sm rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                            <option value="admin" <?php echo $member['role'] === 'admin' ? 'selected' : ''; ?>>Admin</option>
                                            <option value="editor" <?php echo $member['role'] === 'editor' ? 'selected' : ''; ?>>Editor</option>
                                            <option value="member" <?php echo $member['role'] === 'member' ? 'selected' : ''; ?>>Member</option>
                                        </select>
                                    </form>
                                <?php else: ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                        <?php 
                                        if ($member['role'] === 'admin') echo 'bg-purple-100 text-purple-800';
                                        else if ($member['role'] === 'editor') echo 'bg-blue-100 text-blue-800';
                                        else echo 'bg-gray-100 text-gray-800';
                                        ?>">
                                        <?php echo ucfirst(htmlspecialchars($member['role'])); ?>
                                    </span>
                                <?php endif; ?>
                            </td>
                            <?php if ($is_admin): ?>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <?php if ($member['user_id'] != $user_id && $member['user_id'] != $creator_id): ?>
                                        <a href="?page=members&action=remove&member=<?php echo $member['id']; ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure you want to remove this member?')">Remove</a>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Pending Invitations -->
    <?php if ($is_admin && count($invitations) > 0): ?>
        <div class="bg-white shadow rounded-lg p-6">
            <h2 class="text-lg font-bold mb-4">Pending Invitations (<?php echo count($invitations); ?>)</h2>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Name
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Email
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Invited By
                            </th>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Expires
                            </th>
                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php foreach ($invitations as $invite): ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">
                                        <?php echo htmlspecialchars($invite['name']); ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-500"><?php echo htmlspecialchars($invite['email']); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                    $stmt = $db->prepare("SELECT username FROM utilisateurs WHERE id = ?");
                                    $stmt->execute([$invite['created_by']]);
                                    $inviter = $stmt->fetch();
                                    ?>
                                    <div class="text-sm text-gray-500">
                                        <?php echo $inviter ? htmlspecialchars($inviter['username']) : 'Unknown'; ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-500">
                                        <?php 
                                        $expires = new DateTime($invite['expires_at']);
                                        $now = new DateTime();
                                        $interval = $now->diff($expires);
                                        
                                        if ($interval->d > 0) {
                                            echo $interval->format('%d days, %h hours');
                                        } else if ($interval->h > 0) {
                                            echo $interval->format('%h hours, %i minutes');
                                        } else {
                                            echo $interval->format('%i minutes');
                                        }
                                        ?>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="?page=members&action=cancel_invite&invite=<?php echo $invite['id']; ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Are you sure you want to cancel this invitation?')">Cancel</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Invite Modal -->
<?php if ($is_admin): ?>
    <div id="invite-modal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg max-w-md w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-xl font-bold">Invite Family Member</h2>
                    <button onclick="document.getElementById('invite-modal').classList.add('hidden')" class="text-gray-500 hover:text-gray-700">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                
                <form action="?page=members&action=invite" method="POST">
                    <div class="mb-4">
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                        <input type="text" id="name" name="name" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    
                    <div class="mb-4">
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" id="email" name="email" required class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    
                    <div class="mb-6">
                        <label for="role" class="block text-sm font-medium text-gray-700 mb-1">Role</label>
                        <select id="role" name="role" class="w-full rounded-lg border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="member">Member (view only)</option>
                            <option value="editor">Editor (can add content)</option>
                            <option value="admin">Admin (full access)</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">
                            <strong>Member:</strong> Can view all family content<br>
                            <strong>Editor:</strong> Can add photos, events, and comment<br>
                            <strong>Admin:</strong> Can manage members and all settings
                        </p>
                    </div>
                    
                    <div class="flex justify-end space-x-2">
                        <button type="button" onclick="document.getElementById('invite-modal').classList.add('hidden')" class="bg-white px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">Cancel</button>
                        <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Send Invitation</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if ($action === 'invite'): ?>
    document.getElementById('invite-modal').classList.remove('hidden');
    <?php endif; ?>
});
</script>