<?php
header('Content-Type: application/json');

// Récupérer le texte à convertir en voix
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['text']) || empty($data['text'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Le texte est requis'
    ]);
    exit;
}

// Configuration de l'API OpenAI
$api_key = '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'; // Remplace par ta clé API OpenAI
$endpoint = 'https://api.openai.com/v1/audio/speech';

// Données pour l'API OpenAI TTS
$requestData = [
    'model' => 'tts-1',  // Modèle standard
    'input' => $data['text'],
    'voice' => 'alloy',  // Voix française (tu peux choisir: alloy, echo, fable, onyx, nova, shimmer)
    'response_format' => 'mp3'
];

// Exécuter la requête à l'API OpenAI
$ch = curl_init($endpoint);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $api_key
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// Gestion des erreurs
if (curl_errno($ch)) {
    echo json_encode([
        'success' => false,
        'message' => 'Erreur cURL: ' . curl_error($ch)
    ]);
    exit;
}
curl_close($ch);

// Vérifier le code de statut HTTP
if ($httpCode !== 200) {
    $error = json_decode($response, true);
    echo json_encode([
        'success' => false,
        'message' => 'Erreur API: ' . ($error['error']['message'] ?? 'Erreur inconnue'),
        'code' => $httpCode
    ]);
    exit;
}

// Sauvegarder le fichier audio
$filename = 'tts_' . md5($data['text'] . time()) . '.mp3';
$filepath = 'audio/' . $filename;

// Créer le dossier audio s'il n'existe pas
if (!file_exists('audio')) {
    mkdir('audio', 0755, true);
}

// Sauvegarder le fichier audio
file_put_contents($filepath, $response);

// Renvoyer l'URL du fichier audio
echo json_encode([
    'success' => true,
    'audio_url' => $filepath,
    'message' => 'Synthèse vocale générée avec succès'
]);