<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Updates - Imators</title>
    <link href="https://cdn.imators.com/logo.png" rel="icon" type="image/png" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.1.2/dist/tailwind.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&display=swap');
        body {
            font-family: 'Space Grotesk', sans-serif;
            background-color: #000000;
            color: #FFFFFF;
        }
        
        header {
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .separator {
            height: 1px;
            background-color: #333;
            width: 100%;
            margin: 30px 0;
        }
        
        a.text-link {
            position: relative;
            color: #FFFFFF;
            text-decoration: none;
            padding-bottom: 2px;
        }
        
        a.text-link::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 1px;
            bottom: 0;
            left: 0;
            background-color: #FFFFFF;
            transform: scaleX(0);
            transform-origin: bottom right;
            transition: transform 0.3s;
        }
        
        a.text-link:hover::after {
            transform: scaleX(1);
            transform-origin: bottom left;
        }
    </style>
</head>
<body>
    <?php include 'src/header.php'; ?>

    <div class="w-full h-64 md:h-80 lg:h-96 overflow-hidden">
        <img src="updates_banner.png" alt="Updates Banner" class="w-full h-full object-cover">
    </div>
    
    <div class="container px-4 mx-auto py-12">
        <h1 class="text-4xl font-light mb-6">Latest Updates.</h1>
        <p class="text-xl text-gray-400 mb-12">Découvrez les dernières améliorations et mises à jour de nos applications.</p>
        
        <?php
        // Simuler des données de mises à jour (remplacer par votre logique de base de données)
        $updates = [
            [
                'app' => 'Imators Studio',
                'version' => '2.5.3',
                'date' => '18 Avril 2025',
                'description' => 'Amélioration des performances de rendu et correction de bugs majeurs.',
                'link' => '/download/studio'
            ],
            [
                'app' => 'Imators Mobile',
                'version' => '1.7.2',
                'date' => '15 Avril 2025',
                'description' => 'Nouveaux filtres de création et interface utilisateur optimisée.',
                'link' => '/download/mobile'
            ],
            [
                'app' => 'Imators Cloud',
                'version' => '3.0.1',
                'date' => '10 Avril 2025',
                'description' => 'Synchronisation améliorée et nouvelles options de partage de projet.',
                'link' => '/download/cloud'
            ]
        ];

        foreach ($updates as $update) {
            echo '<div class="py-6 flex flex-wrap items-center">';
            echo '    <div class="w-full md:w-1/4 mb-4 md:mb-0">';
            echo '        <h3 class="text-xl font-light">' . htmlspecialchars($update['app']) . '</h3>';
            echo '        <p class="text-sm text-gray-500 mt-1">v' . htmlspecialchars($update['version']) . '</p>';
            echo '    </div>';
            echo '    <div class="w-full md:w-2/4 mb-4 md:mb-0">';
            echo '        <p class="text-gray-400">' . htmlspecialchars($update['description']) . '</p>';
            echo '        <p class="text-sm text-gray-500 mt-2">' . htmlspecialchars($update['date']) . '</p>';
            echo '    </div>';
            echo '    <div class="w-full md:w-1/4 text-right">';
            echo '        <a href="' . htmlspecialchars($update['link']) . '" class="text-link">Télécharger →</a>';
            echo '    </div>';
            echo '</div>';
            echo '<div class="separator"></div>';
        }
        ?>
        
        <div class="py-10">
            <h2 class="text-2xl font-light mb-8">Restez à jour</h2>
            
            <div class="flex flex-wrap">
                <div class="w-full md:w-1/2 mb-8 md:mb-0">
                    <h3 class="text-lg font-light mb-2">Notifications</h3>
                    <p class="text-gray-400 mb-2">Activez les notifications pour recevoir les dernières mises à jour.</p>
                    <a href="/parametres" class="text-link">Gérer les notifications →</a>
                </div>
                
                <div class="w-full md:w-1/2">
                    <h3 class="text-lg font-light mb-2">Notes de version</h3>
                    <p class="text-gray-400 mb-2">Consultez l'historique complet des changements.</p>
                    <a href="/changelog" class="text-link">Voir le changelog →</a>
                </div>
            </div>
        </div>
    </div>

    <?php include 'src/footer.php'; ?>

    <div class="fixed bottom-0 left-0 right-0 mx-4 sm:mx-6 md:mx-8 mb-4 sm:mb-6 p-4 sm:p-5 bg-black text-white rounded-lg shadow-xl z-50 opacity-0 translate-y-8 transition-all duration-500 ease-out" id="cookieBox">
      <div class="container mx-auto flex flex-col sm:flex-row justify-between items-center gap-4">
        <div class="text-sm md:text-base font-light leading-relaxed max-w-3xl">
        Our site uses only the essential cookies required for the site to function properly. No information is passed on to third parties. To find out more about the essential information collected, <a href="./terms-of-use" class="underline">please read our terms of use</a>.
        </div>
        <button class="w-full sm:w-auto bg-white text-black px-6 py-2 rounded-full hover:bg-gray-100 transition-colors whitespace-nowrap text-sm font-medium" onclick="acceptCookies()">
        Accept
        </button>
      </div>
    </div>

    <script>
      function acceptCookies() {
        const cookieBox = document.getElementById('cookieBox');
        cookieBox.classList.add('opacity-0', 'translate-y-8');
        
        setTimeout(() => {
          cookieBox.style.display = 'none';
          localStorage.setItem('cookiesAccepted', 'true');
        }, 500);
      }

      window.onload = function() {
        const cookieBox = document.getElementById('cookieBox');
        
        if (localStorage.getItem('cookiesAccepted') === 'true') {
          cookieBox.style.display = 'none';
        } else {
          setTimeout(() => {
            cookieBox.classList.remove('opacity-0', 'translate-y-8');
          }, 2000);
        }
      }
    </script>

    <script>
        document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.remove('hidden');
        });
        
        document.getElementById('mobile-menu-close')?.addEventListener('click', function() {
            document.getElementById('mobile-menu')?.classList.add('hidden');
        });
    </script>
</body>
</html>