/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.listeners;

import fr.imators.shop.ImatorsShop;
import fr.imators.shop.gui.ShopGUI;
import fr.imators.shop.managers.ShopManager;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class SignListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String[] lines = sign.getLines();
        if (lines.length < 1 || !lines[0].contains("[SHOP]")) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (!ImatorsShop.getInstance().getDatabaseManager().isPlayerLinked(player.getUniqueId().toString())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Tu dois d'abord lier ton compte avec /link <ID_CARTE> !");
            return;
        }
        ShopManager shopManager = ImatorsShop.getInstance().getShopManager();
        int shopId = shopManager.getShopIdByLocation(block.getLocation());
        if (shopId == -1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Cette boutique n'existe plus !");
            return;
        }
        new ShopGUI(shopId).open(player);
    }
}

