/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.gui;

import fr.imators.shop.ImatorsShop;
import fr.imators.shop.gui.ItemCreationGUI;
import fr.imators.shop.models.Shop;
import fr.imators.shop.models.ShopItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ShopGUI
implements Listener {
    private static Map<Player, ShopGUI> activeShopGUIs = new HashMap<Player, ShopGUI>();
    private static Map<Player, Integer> waitingForPrice = new HashMap<Player, Integer>();
    private static Map<Player, Integer> waitingForStock = new HashMap<Player, Integer>();
    private static Map<Player, String> waitingForItemName = new HashMap<Player, String>();
    private static Map<Player, Material> selectedMaterial = new HashMap<Player, Material>();
    private int shopId;
    private Player player;

    public ShopGUI(int shopId) {
        this.shopId = shopId;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImatorsShop.getInstance());
    }

    public void open(Player player) {
        this.player = player;
        activeShopGUIs.put(player, this);
        Shop shop = ImatorsShop.getInstance().getShopManager().getShop(this.shopId);
        if (shop == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Boutique introuvable !");
            return;
        }
        List<ShopItem> items = ImatorsShop.getInstance().getShopManager().getShopItems(this.shopId);
        boolean isOwner = shop.getOwnerUuid().equals(player.getUniqueId().toString());
        String title = isOwner ? String.valueOf(ChatColor.BLUE) + "G\u00e9rer: " + shop.getName() : String.valueOf(ChatColor.GREEN) + shop.getName();
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)title);
        for (int i = 0; i < items.size() && i < 45; ++i) {
            ShopItem item = items.get(i);
            Material material = Material.valueOf((String)item.getMaterial());
            ItemStack displayItem = new ItemStack(material);
            ItemMeta meta = displayItem.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + item.getName());
            if (isOwner) {
                meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Prix: " + String.valueOf(ChatColor.GREEN) + item.getPrice() + " FCoins", String.valueOf(ChatColor.GRAY) + "Stock: " + (item.getStock() == -1 ? String.valueOf(ChatColor.YELLOW) + "Illimit\u00e9" : String.valueOf(ChatColor.WHITE) + String.valueOf(item.getStock())), "", String.valueOf(ChatColor.BLUE) + "Clic gauche: Modifier", String.valueOf(ChatColor.RED) + "Clic droit: Supprimer"));
            } else {
                meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Prix: " + String.valueOf(ChatColor.GREEN) + item.getPrice() + " FCoins", String.valueOf(ChatColor.GRAY) + "Stock: " + (item.getStock() == -1 ? String.valueOf(ChatColor.YELLOW) + "Illimit\u00e9" : (item.getStock() > 0 ? String.valueOf(ChatColor.GREEN) + String.valueOf(item.getStock()) : String.valueOf(ChatColor.RED) + "Rupture")), "", item.getStock() != 0 ? String.valueOf(ChatColor.GREEN) + "Clic pour acheter" : String.valueOf(ChatColor.RED) + "Indisponible"));
            }
            displayItem.setItemMeta(meta);
            inv.setItem(i, displayItem);
        }
        if (isOwner) {
            ItemStack addItem = new ItemStack(Material.EMERALD);
            ItemMeta addMeta = addItem.getItemMeta();
            addMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Ajouter un article");
            addMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Clique pour ajouter", String.valueOf(ChatColor.GRAY) + "un nouvel article"));
            addItem.setItemMeta(addMeta);
            inv.setItem(49, addItem);
        }
        ItemStack closeItem = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeItem.getItemMeta();
        closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Fermer");
        closeItem.setItemMeta(closeMeta);
        inv.setItem(53, closeItem);
        player.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!activeShopGUIs.containsKey(player)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        ShopGUI gui = activeShopGUIs.get(player);
        Shop shop = ImatorsShop.getInstance().getShopManager().getShop(gui.shopId);
        boolean isOwner = shop.getOwnerUuid().equals(player.getUniqueId().toString());
        if (event.getCurrentItem().getType() == Material.BARRIER) {
            player.closeInventory();
            activeShopGUIs.remove(player);
            return;
        }
        if (event.getCurrentItem().getType() == Material.EMERALD && isOwner) {
            player.closeInventory();
            new ItemCreationGUI(gui.shopId).open(player);
            return;
        }
        List<ShopItem> items = ImatorsShop.getInstance().getShopManager().getShopItems(gui.shopId);
        int slot = event.getSlot();
        if (slot >= items.size() || slot < 0) {
            return;
        }
        ShopItem item = items.get(slot);
        if (isOwner) {
            if (event.isLeftClick()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Modification d'articles non impl\u00e9ment\u00e9e dans cette version");
            } else if (event.isRightClick()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Suppression d'articles non impl\u00e9ment\u00e9e dans cette version");
            }
        } else {
            if (item.getStock() == 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Cet article n'est plus en stock !");
                return;
            }
            int buyerUserId = ImatorsShop.getInstance().getDatabaseManager().getLinkedUserId(player.getUniqueId().toString());
            if (buyerUserId == -1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Erreur: compte non li\u00e9 !");
                return;
            }
            if (ImatorsShop.getInstance().getShopManager().purchaseItem(item.getId(), buyerUserId, player.getName())) {
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Tu as achet\u00e9 " + item.getName() + " pour " + item.getPrice() + " FCoins !");
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.valueOf((String)item.getMaterial()))});
                gui.open(player);
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Erreur lors de l'achat !");
            }
        }
    }
}

