/*
 * Decompiled with CFR 0.152.
 */
package fr.imators.shop.database;

import fr.imators.shop.ImatorsShop;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.bukkit.configuration.file.FileConfiguration;

public class DatabaseManager {
    private Connection connection;
    private String host;
    private String database;
    private String username;
    private String password;
    private int port;

    public DatabaseManager() {
        FileConfiguration config = ImatorsShop.getInstance().getConfig();
        this.host = config.getString("database.host", "localhost");
        this.port = config.getInt("database.port", 3306);
        this.database = config.getString("database.name", "ggdcvggs_peerkinton");
        this.username = config.getString("database.username", "root");
        this.password = config.getString("database.password", "");
    }

    public boolean connect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return true;
            }
            Class.forName("com.mysql.cj.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&allowPublicKeyRetrieval=true", this.username, this.password);
            this.createTables();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTables() {
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS linked_players (id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36) UNIQUE NOT NULL, user_id INT NOT NULL, linked_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS shops (id INT AUTO_INCREMENT PRIMARY KEY, location_world VARCHAR(100) NOT NULL, location_x INT NOT NULL, location_y INT NOT NULL, location_z INT NOT NULL, owner_uuid VARCHAR(36) NOT NULL, shop_name VARCHAR(100) NOT NULL, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS shop_items (id INT AUTO_INCREMENT PRIMARY KEY, shop_id INT NOT NULL, item_material VARCHAR(50) NOT NULL, item_name VARCHAR(100) NOT NULL, price DECIMAL(10,2) NOT NULL, stock INT DEFAULT -1, FOREIGN KEY (shop_id) REFERENCES shops(id) ON DELETE CASCADE)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean validateIdCarte(String idCarte) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT id FROM identites WHERE id_carte = ?");
            stmt.setString(1, idCarte);
            ResultSet rs = stmt.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getUserIdByIdCarte(String idCarte) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT id FROM identites WHERE id_carte = ?");
            stmt.setString(1, idCarte);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return rs.getInt("id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public boolean linkPlayer(String uuid, int userId) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO linked_players (uuid, user_id) VALUES (?, ?) ON DUPLICATE KEY UPDATE user_id = VALUES(user_id)");
            stmt.setString(1, uuid);
            stmt.setInt(2, userId);
            return stmt.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isPlayerLinked(String uuid) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT id FROM linked_players WHERE uuid = ?");
            stmt.setString(1, uuid);
            ResultSet rs = stmt.executeQuery();
            return rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getLinkedUserId(String uuid) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("SELECT user_id FROM linked_players WHERE uuid = ?");
            stmt.setString(1, uuid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return rs.getInt("user_id");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public boolean addTransaction(int userId, int destinataireId, double montant, String motif, String emetteurNom, String destinataireNom) {
        try {
            PreparedStatement stmt = this.connection.prepareStatement("INSERT INTO transactions (user_id, destinataire_id, montant, motif, date, emetteur_nom, destinataire_nom) VALUES (?, ?, ?, ?, ?, ?, ?)");
            stmt.setInt(1, userId);
            stmt.setInt(2, destinataireId);
            stmt.setDouble(3, montant);
            stmt.setString(4, motif);
            stmt.setString(5, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            stmt.setString(6, emetteurNom);
            stmt.setString(7, destinataireNom);
            return stmt.executeUpdate() > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

