<!DOCTYPE html>

<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Elona</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #000000 0%, #1a1a1a 25%, #2d1810 50%, #4a3728 75%, #d4af37 100%);
        }

    .glitch {
        animation: glitch 0.1s infinite;
    }

    @keyframes glitch {
        0% { transform: translate(0); }
        20% { transform: translate(-2px, 2px); }
        40% { transform: translate(-2px, -2px); }
        60% { transform: translate(2px, 2px); }
        80% { transform: translate(2px, -2px); }
        100% { transform: translate(0); }
    }

    .led-text {
        font-family: 'Cinzel', serif;
        color: #d4af37;
        text-shadow: 0 0 10px #d4af37, 0 0 20px #d4af37, 0 0 30px #d4af37;
    }

    .fade-in-scroll {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.8s ease;
    }

    .fade-in-scroll.visible {
        opacity: 1;
        transform: translateY(0);
    }

    .glow-border {
        position: relative;
        border-radius: 8px;
        overflow: hidden;
    }

    .glow-border::before {
        content: '';
        position: absolute;
        top: -2px;
        left: -2px;
        right: -2px;
        bottom: -2px;
        background: linear-gradient(45deg, #d4af37, #f4d03f, #d4af37, #f4d03f);
        background-size: 400% 400%;
        animation: glow-rotate 3s linear infinite;
        z-index: -1;
    }

    @keyframes glow-rotate {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }

    .credits-scroll {
        animation: scroll-up 15s linear infinite;
    }

    @keyframes scroll-up {
        0% { transform: translateY(100vh); }
        100% { transform: translateY(-100%); }
    }

    .blink {
        animation: blink 0.2s ease-in-out;
    }

    @keyframes blink {
        0%, 100% { opacity: 1; }
        50% { opacity: 0; }
    }

    .corruption-frame {
        position: relative;
        overflow: hidden;
    }

    .corruption-frame::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent 30%, rgba(255,0,0,0.3) 35%, transparent 40%, transparent 60%, rgba(255,0,0,0.2) 65%, transparent 70%);
        z-index: 2;
    }

    .corruption-frame::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: 
            linear-gradient(120deg, transparent 20%, rgba(0,0,0,0.8) 22%, transparent 24%),
            linear-gradient(60deg, transparent 40%, rgba(255,255,255,0.1) 42%, transparent 44%),
            linear-gradient(30deg, transparent 60%, rgba(0,0,0,0.6) 62%, transparent 64%);
        clip-path: polygon(0 0, 30% 0, 25% 25%, 50% 20%, 45% 45%, 70% 40%, 65% 65%, 90% 60%, 85% 85%, 100% 80%, 100% 100%, 0 100%);
        z-index: 3;
    }
</style>

</head>
<body class="bg-black overflow-x-hidden">
    <div id="step1" class="min-h-screen gradient-bg flex items-center justify-center">
        <div id="cassette" class="bg-black bg-opacity-80 border border-yellow-600 rounded-lg p-8 text-center cursor-pointer hover:bg-opacity-90 transition-all duration-300">
            <h2 class="text-yellow-400 text-2xl mb-4 font-light">Dossier 02/09</h2>
            <div class="text-yellow-300 text-lg">↓ Cliquer vous lancer la lecture ↓</div>
        </div>
    </div>

<div id="step2" class="min-h-screen bg-black hidden items-center justify-center">
    <div id="bug-overlay" class="absolute inset-0 bg-black z-10 hidden"></div>
    <h1 id="elona-title" class="text-8xl led-text font-bold hidden" style="font-family: 'Cinzel', serif;">ELONA</h1>
</div>

<div id="step3" class="min-h-screen gradient-bg hidden">
    <div class="container mx-auto px-8 py-16">
        <div class="max-w-4xl mx-auto">
            <div class="fade-in-scroll mb-8">
                <p class="text-yellow-100 text-xl leading-relaxed mb-6">
                    Elona, c'est actuellement la personne sur laquelle nous enquêtons dans ce dossier. Tout nos agents ont malheureusement abandonné de prendre de n'importe quelle manière le dossier. La raison? Nous ne la connaissons pas, mais moi je sait pourquoi, car j'ai clôturé ce dossier.       
                </p>
            </div>
            <div class="fade-in-scroll mb-8">
                <p class="text-yellow-100 text-xl leading-relaxed mb-6">
                    NYC, 02:00pm, elle quitte son bureau et grimpe dans la voiture. Tenant le parapluie, je le range dans le coffre et me précipite au volant pour la conduire. On arrive, elle sort, fait son achat et reviens. Il est temp de rentrer et de la raisonner, il faut qu'elle mange. Elle adore les Mojitos qu'il font au coin, j'en prend un en toute discrétion et je le lui ramène pour le dîner, accompagner du Burger quelle adore. Ravis qu'elle souris, la journée de demain ne sera pas un cadeau.
                </p>
            </div>
            <div class="fade-in-scroll mb-8">
                <p class="text-yellow-100 text-xl leading-relaxed mb-6">
                    NYC, 06:00am, son rendez-vous la stress, elle a peur et se tourne les pouces en routes. Je l'a rassure et lui dit que tout va bien se passer. Elle est ressorti, fiere et contente, car elle à réussi. Le reste de la journée, elle s'énerve sur son mac, jete des verres par terre et se fâche mais je lui tient la main. La journée c'est bien finis ? On a été manger ces pates préfèrer après sa persévérance remarquable qu'elle a mise en place toute la journée. Elle m'a regarder pendant que je lui tenait la main et elle m'a dit "Il y'a temp de fille plus chouette que moi tu sait", mais j'ai rétorqué "Demain on va voir les Lakers comme tu voulais. Ah et pourquoi toi ? Parce que je t'adore comme tu est, resplendissante meme à distance et super collante quand on se voit, comme moi au final. Et ce style, putain, arrête d'être aussi belle". Malheureusement un amour fou pour cette beauté au yeux bleus était impossible a minimiser, car elle est tellement belle, tellement souriante, tellement spéciale émotionnellement a mon gout, que je veut l'embrasser et dire merci, merci d'être toi putain.
                </p>
            </div>
            <div class="fade-in-scroll">
                <button id="btn-suite" class="bg-yellow-600 hover:bg-yellow-500 text-black px-8 py-3 rounded-lg font-semibold transition-all duration-300 transform hover:scale-105">
                    Suite
                </button>
            </div>
        </div>
    </div>
</div>

<div id="step4" class="min-h-screen gradient-bg hidden">
    <div class="container mx-auto px-8 py-16">
        <div class="max-w-6xl mx-auto">
            <div class="grid md:grid-cols-2 gap-12 mb-12">
                <div class="text-center">
                    <div class="w-80 h-96 bg-gradient-to-b from-yellow-900 to-yellow-700 rounded-lg mx-auto mb-6 flex items-center justify-center" style="background-image: url('d64703ef-40a7-46c5-b563-07f4c223dfba.jpeg'); background-size: cover; background-position: center;">
                    </div>
                    <p class="text-yellow-100 text-lg leading-relaxed">
                        Nous avons déduit de cette preuve que une beauté éthérée aux reflets dorés, représente son visage
                    </p>
                </div>
                <div class="text-center">
                    <div class="w-80 h-96 bg-gradient-to-b from-yellow-800 to-yellow-600 rounded-lg mx-auto mb-6 flex items-center justify-center" style="background-image: url('e074a21f-0f69-4557-b1ae-dea06f8555f5.jpeg'); background-size: cover; background-position: center;">
                    </div>
                    <p class="text-yellow-100 text-lg leading-relaxed">
                        Heureusement , nous avons pu déduire et affirmer mon hypothèse : elle est unique et je l'aime de tout mon coeur.
                    </p>
                </div>
            </div>
            <div class="text-center">
                <button id="btn-finale" class="bg-yellow-600 hover:bg-yellow-500 text-black px-8 py-3 rounded-lg font-semibold transition-all duration-300 transform hover:scale-105">
                    Suite Finale
                </button>
            </div>
        </div>
    </div>
</div>

<div id="step5" class="min-h-screen gradient-bg hidden">
    <div class="container mx-auto px-8 py-16">
        <div class="max-w-6xl mx-auto">
            <div class="grid md:grid-cols-2 gap-12">
                <div class="text-center">
                    <div id="glitch-image" class="w-80 h-96 bg-gradient-to-b from-yellow-400 to-yellow-700 rounded-lg mx-auto mb-6 flex items-center justify-center corruption-frame" style="background-image: url('d64703ef-40a7-46c5-b563-07f4c223dfba.jpeg'); background-size: cover; background-position: center;">
                    </div>
                    <p class="text-yellow-100 text-lg leading-relaxed">
                        Selon moi, j'ai pu déduire que sa beauté est perturbante. Un tel gout pour tout dans la vie comme la mode et le choix de sport, ne se trouve pas partout, avec une aussi belle gentillesse dans son coeur.
                                    
                                      
                    </p>
                </div>
                <div class="text-center">
                    <div class="w-80 h-96 bg-gradient-to-b from-yellow-800 to-yellow-600 rounded-lg mx-auto mb-6 flex items-center justify-center glow-border" style="background-image: url('transcendance.jpg'); background-size: cover; background-position: center;">
                    </div>
                    <p class="text-yellow-100 text-lg leading-relaxed">
                        Elona dans sa forme ultime, rayonnante d'une lumière dorée qui repousse toute ténèbre et restore l'harmonie par un simple message quand je lui parle.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="credits" class="min-h-screen bg-black hidden flex items-center justify-center">
    <div class="credits-scroll text-center text-yellow-400">
        <div class="mb-8 text-2xl font-bold">CRÉDITS</div>
        <div class="mb-6 text-lg">Créé par Izhak</div>
        <div class="mb-6 text-lg">Beauté offerte par Elona</div>
        <div class="mb-6 text-lg">Gentilesse donné Elona</div>
                <div class="mb-6 text-lg">Pureté émise par Elona</div>
                        <div class="mb-6 text-lg">Amour donné par Elona</div>
                                <div class="mb-6 text-lg">Fille exceptionnelle jouer par Elona</div>
        <div class="mb-6 text-lg">Interface Elona v1.0</div>
        <div class="mb-6 text-lg">Pour Nana :</div>
        <div class="text-lg">Merci d'être la fille que j'aime le plus.</div>
    </div>
</div>

<script>
    let currentStep = 1;
    
    function scrollToTop() {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    }
    
    document.getElementById('cassette').addEventListener('click', function() {
        this.style.transition = 'all 2s ease-out';
        this.style.filter = 'blur(10px)';
        this.style.opacity = '0';
        setTimeout(() => {
            document.getElementById('step1').style.transition = 'opacity 1.5s ease-out';
            document.getElementById('step1').style.opacity = '0';
            setTimeout(() => {
                document.getElementById('step1').classList.add('hidden');
                scrollToTop();
                showStep2();
            }, 1500);
        }, 2000);
    });
    
    function showStep2() {
        const step2 = document.getElementById('step2');
        const bugOverlay = document.getElementById('bug-overlay');
        const title = document.getElementById('elona-title');
        
        step2.style.opacity = '0';
        step2.classList.remove('hidden');
        step2.classList.add('flex');
        step2.style.transition = 'opacity 1s ease-in';
        setTimeout(() => {
            step2.style.opacity = '1';
        }, 100);
        
        setTimeout(() => {
            bugOverlay.classList.remove('hidden');
            bugOverlay.classList.add('glitch');
            
            setTimeout(() => {
                bugOverlay.classList.add('hidden');
                bugOverlay.classList.remove('glitch');
                title.classList.remove('hidden');
                
                setTimeout(() => {
                    title.classList.add('blink');
                    setTimeout(() => {
                        title.classList.remove('blink');
                        setTimeout(() => {
                            title.classList.add('blink');
                            setTimeout(() => {
                                title.classList.remove('blink');
                                setTimeout(() => {
                                    title.style.transition = 'opacity 1.5s ease-out';
                                    title.style.opacity = '0';
                                    setTimeout(() => {
                                        step2.style.transition = 'opacity 1.5s ease-out';
                                        step2.style.opacity = '0';
                                        setTimeout(() => {
                                            step2.classList.add('hidden');
                                            scrollToTop();
                                            showStep3();
                                        }, 1500);
                                    }, 1500);
                                }, 1000);
                            }, 300);
                        }, 500);
                    }, 300);
                }, 2000);
            }, 3000);
        }, 2000);
    }
    
    function showStep3() {
        const step3 = document.getElementById('step3');
        step3.style.opacity = '0';
        step3.classList.remove('hidden');
        step3.style.transition = 'opacity 2s ease-in';
        setTimeout(() => {
            step3.style.opacity = '1';
            observeElements();
        }, 100);
    }
    
    function observeElements() {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('visible');
                } else {
                    entry.target.classList.remove('visible');
                }
            });
        });
        
        document.querySelectorAll('.fade-in-scroll').forEach(el => {
            observer.observe(el);
        });
    }
    
    document.getElementById('btn-suite').addEventListener('click', function() {
        const step3 = document.getElementById('step3');
        const step4 = document.getElementById('step4');
        
        step3.style.transition = 'opacity 1.5s ease-out';
        step3.style.opacity = '0';
        
        setTimeout(() => {
            step3.classList.add('hidden');
            scrollToTop();
            step4.style.opacity = '0';
            step4.classList.remove('hidden');
            step4.style.transition = 'opacity 2s ease-in';
            setTimeout(() => {
                step4.style.opacity = '1';
            }, 100);
        }, 1500);
    });
    
    document.getElementById('btn-finale').addEventListener('click', function() {
        const step4 = document.getElementById('step4');
        const step5 = document.getElementById('step5');
        
        step4.style.transition = 'opacity 1.5s ease-out';
        step4.style.opacity = '0';
        
        setTimeout(() => {
            step4.classList.add('hidden');
            scrollToTop();
            step5.style.opacity = '0';
            step5.classList.remove('hidden');
            step5.style.transition = 'opacity 2s ease-in';
            setTimeout(() => {
                step5.style.opacity = '1';
                
                setTimeout(() => {
                    document.getElementById('glitch-image').classList.add('glitch');
                }, 2000);
                
                setTimeout(() => {
                    step5.style.transition = 'opacity 2s ease-out';
                    step5.style.opacity = '0';
                    setTimeout(() => {
                        step5.classList.add('hidden');
                        scrollToTop();
                        showCredits();
                    }, 2000);
                }, 8000);
            }, 100);
        }, 1500);
    });
    
    function showCredits() {
        const credits = document.getElementById('credits');
        credits.style.opacity = '0';
        credits.classList.remove('hidden');
        credits.classList.add('flex');
        credits.style.transition = 'opacity 2s ease-in';
        setTimeout(() => {
            credits.style.opacity = '1';
        }, 100);
    }
</script>

</body>
</html>