<?php

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'core/parser.php';
require_once 'core/router.php';
require_once 'core/response.php';

$query = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $query = $input['query'] ?? '';
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $query = $_GET['query'] ?? '';
}

if (empty($query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'No query provided',
        'data' => null
    ]);
    exit;
}

try {
    $parser = new CanParser();
    $router = new CanRouter();
    $response = new CanResponse();
    
    $parsed = $parser->parse($query);
    $result = $router->execute($parsed);
    
    echo $response->format($result, 'api');
    
} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage(),
        'data' => null
    ]);
}

?>