"use client";

// src/tab-panel.tsx
import { forwardRef } from "@heroui/system";
import { useDOMRef } from "@heroui/react-utils";
import { clsx, getInertValue } from "@heroui/shared-utils";
import { mergeProps } from "@react-aria/utils";
import { useTabPanel } from "@react-aria/tabs";
import { useFocusRing } from "@react-aria/focus";
import { jsx } from "react/jsx-runtime";
var TabPanel = forwardRef((props, ref) => {
  var _a, _b;
  const { as, tabKey, destroyInactiveTabPanel, state, className, slots, classNames, ...otherProps } = props;
  const Component = as || "div";
  const domRef = useDOMRef(ref);
  const { tabPanelProps } = useTabPanel({ ...props, id: String(tabKey) }, state, domRef);
  const { focusProps, isFocused, isFocusVisible } = useFocusRing();
  const selectedItem = state.selectedItem;
  const content = state.collection.getItem(tabKey).props.children;
  const tabPanelStyles = clsx(classNames == null ? void 0 : classNames.panel, className, (_a = selectedItem == null ? void 0 : selectedItem.props) == null ? void 0 : _a.className);
  const isSelected = tabKey === (selectedItem == null ? void 0 : selectedItem.key);
  if (!content || !isSelected && destroyInactiveTabPanel) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    Component,
    {
      ref: domRef,
      "data-focus": isFocused,
      "data-focus-visible": isFocusVisible,
      "data-inert": !isSelected ? "true" : void 0,
      inert: getInertValue(!isSelected),
      ...isSelected && mergeProps(tabPanelProps, focusProps, otherProps),
      className: (_b = slots.panel) == null ? void 0 : _b.call(slots, { class: tabPanelStyles }),
      "data-slot": "panel",
      children: content
    }
  );
});
TabPanel.displayName = "HeroUI.TabPanel";
var tab_panel_default = TabPanel;

export {
  tab_panel_default
};
