"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/common/assertion.ts
var assertion_exports = {};
__export(assertion_exports, {
  __DEV__: () => __DEV__,
  __TEST__: () => __TEST__,
  dataAttr: () => dataAttr,
  isArray: () => isArray,
  isEmpty: () => isEmpty,
  isEmptyArray: () => isEmptyArray,
  isEmptyObject: () => isEmptyObject,
  isFunction: () => isFunction,
  isNumeric: () => isNumeric,
  isObject: () => isObject
});
module.exports = __toCommonJS(assertion_exports);
var __DEV__ = process.env.NODE_ENV !== "production";
var __TEST__ = process.env.NODE_ENV === "test";
function isArray(value) {
  return Array.isArray(value);
}
function isEmptyArray(value) {
  return isArray(value) && value.length === 0;
}
function isObject(value) {
  const type = typeof value;
  return value != null && (type === "object" || type === "function") && !isArray(value);
}
function isEmptyObject(value) {
  return isObject(value) && Object.keys(value).length === 0;
}
function isEmpty(value) {
  if (isArray(value)) return isEmptyArray(value);
  if (isObject(value)) return isEmptyObject(value);
  if (value == null || value === "") return true;
  return false;
}
function isFunction(value) {
  return typeof value === "function";
}
var dataAttr = (condition) => condition ? "true" : void 0;
var isNumeric = (value) => value != null && parseInt(value.toString(), 10) > 0;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  __DEV__,
  __TEST__,
  dataAttr,
  isArray,
  isEmpty,
  isEmptyArray,
  isEmptyObject,
  isFunction,
  isNumeric,
  isObject
});
