"use client";
import {
  useReactAriaPopover
} from "./chunk-WR4S6RJE.mjs";

// src/use-popover.ts
import { useEffect } from "react";
import { useDOMRef } from "@heroui/react-utils";
import { useOverlayTriggerState } from "@react-stately/overlays";
import { useFocusRing } from "@react-aria/focus";
import { ariaHideOutside, useOverlayTrigger, usePreventScroll } from "@react-aria/overlays";
import { getShouldUseAxisPlacement } from "@heroui/aria-utils";
import { mapPropsVariants, useProviderContext } from "@heroui/system";
import { getArrowPlacement } from "@heroui/aria-utils";
import { popover } from "@heroui/theme";
import { mergeProps, mergeRefs } from "@react-aria/utils";
import { clsx, dataAttr, objectToDeps } from "@heroui/shared-utils";
import { useMemo, useCallback, useRef } from "react";
var DEFAULT_PLACEMENT = "top";
function usePopover(originalProps) {
  var _a, _b, _c;
  const globalContext = useProviderContext();
  const [props, variantProps] = mapPropsVariants(originalProps, popover.variantKeys);
  const {
    as,
    ref,
    children,
    state: stateProp,
    triggerRef: triggerRefProp,
    scrollRef,
    defaultOpen,
    onOpenChange,
    isOpen: isOpenProp,
    isNonModal = true,
    shouldFlip = true,
    containerPadding = 12,
    shouldBlockScroll = false,
    isDismissable = true,
    shouldCloseOnBlur,
    portalContainer,
    updatePositionDeps,
    dialogProps: dialogPropsProp,
    placement: placementProp = DEFAULT_PLACEMENT,
    triggerType = "dialog",
    showArrow = false,
    offset = 7,
    crossOffset = 0,
    boundaryElement,
    isKeyboardDismissDisabled,
    shouldCloseOnInteractOutside,
    shouldCloseOnScroll,
    motionProps,
    className,
    classNames,
    onClose,
    ...otherProps
  } = props;
  const Component = as || "div";
  const domRef = useDOMRef(ref);
  const domTriggerRef = useRef(null);
  const wasTriggerPressedRef = useRef(false);
  const triggerRef = triggerRefProp || domTriggerRef;
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const innerState = useOverlayTriggerState({
    isOpen: isOpenProp,
    defaultOpen,
    onOpenChange: (isOpen) => {
      onOpenChange == null ? void 0 : onOpenChange(isOpen);
      if (!isOpen) {
        onClose == null ? void 0 : onClose();
      }
    }
  });
  const state = stateProp || innerState;
  const {
    popoverProps,
    underlayProps,
    placement: ariaPlacement
  } = useReactAriaPopover(
    {
      triggerRef,
      isNonModal,
      popoverRef: domRef,
      placement: placementProp,
      offset,
      scrollRef,
      isDismissable,
      shouldCloseOnBlur,
      boundaryElement,
      crossOffset,
      shouldFlip,
      containerPadding,
      updatePositionDeps,
      isKeyboardDismissDisabled,
      shouldCloseOnScroll,
      shouldCloseOnInteractOutside
    },
    state
  );
  const placement = useMemo(() => {
    if (!ariaPlacement) {
      return null;
    }
    return getShouldUseAxisPlacement(ariaPlacement, placementProp) ? ariaPlacement : placementProp;
  }, [ariaPlacement, placementProp]);
  const { triggerProps } = useOverlayTrigger({ type: triggerType }, state, triggerRef);
  const { isFocusVisible, isFocused, focusProps } = useFocusRing();
  const slots = useMemo(
    () => popover({
      ...variantProps
    }),
    [objectToDeps(variantProps)]
  );
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  usePreventScroll({
    isDisabled: !(shouldBlockScroll && state.isOpen)
  });
  const getPopoverProps = (props2 = {}) => ({
    ref: domRef,
    ...mergeProps(popoverProps, otherProps, props2),
    style: mergeProps(popoverProps.style, otherProps.style, props2.style)
  });
  const getDialogProps = (props2 = {}) => ({
    // `ref` and `dialogProps` from `useDialog` are passed from props
    // if we use `useDialog` here, dialogRef won't be focused on mount
    "data-slot": "base",
    "data-open": dataAttr(state.isOpen),
    "data-focus": dataAttr(isFocused),
    "data-arrow": dataAttr(showArrow),
    "data-focus-visible": dataAttr(isFocusVisible),
    "data-placement": ariaPlacement ? getArrowPlacement(ariaPlacement, placementProp) : void 0,
    ...mergeProps(focusProps, dialogPropsProp, props2),
    className: slots.base({ class: clsx(baseStyles) }),
    style: {
      // this prevent the dialog to have a default outline
      outline: "none"
    }
  });
  const getContentProps = useCallback(
    (props2 = {}) => ({
      "data-slot": "content",
      "data-open": dataAttr(state.isOpen),
      "data-arrow": dataAttr(showArrow),
      "data-placement": ariaPlacement ? getArrowPlacement(ariaPlacement, placementProp) : void 0,
      className: slots.content({ class: clsx(classNames == null ? void 0 : classNames.content, props2.className) })
    }),
    [slots, state.isOpen, showArrow, placement, placementProp, classNames, ariaPlacement]
  );
  const onPress = useCallback(
    (e) => {
      var _a2;
      let pressTimer;
      if (e.pointerType === "touch" && ((originalProps == null ? void 0 : originalProps.backdrop) === "blur" || (originalProps == null ? void 0 : originalProps.backdrop) === "opaque")) {
        pressTimer = setTimeout(() => {
          wasTriggerPressedRef.current = true;
        }, 100);
      } else {
        wasTriggerPressedRef.current = true;
      }
      (_a2 = triggerProps.onPress) == null ? void 0 : _a2.call(triggerProps, e);
      return () => {
        clearTimeout(pressTimer);
      };
    },
    [triggerProps == null ? void 0 : triggerProps.onPress]
  );
  const getTriggerProps = useCallback(
    (props2 = {}, _ref = null) => {
      const { isDisabled, ...otherProps2 } = props2;
      return {
        "data-slot": "trigger",
        ...mergeProps({ "aria-haspopup": "dialog" }, triggerProps, otherProps2),
        onPress,
        isDisabled,
        className: slots.trigger({
          class: clsx(classNames == null ? void 0 : classNames.trigger, props2.className),
          // apply isDisabled class names to make the trigger child disabled
          // e.g. for elements like div or HeroUI elements that don't have `isDisabled` prop
          isTriggerDisabled: isDisabled
        }),
        ref: mergeRefs(_ref, triggerRef)
      };
    },
    [state, triggerProps, onPress, triggerRef]
  );
  const getBackdropProps = useCallback(
    (props2 = {}) => ({
      "data-slot": "backdrop",
      className: slots.backdrop({ class: classNames == null ? void 0 : classNames.backdrop }),
      onClick: (e) => {
        if (!wasTriggerPressedRef.current) {
          e.preventDefault();
          return;
        }
        state.close();
        wasTriggerPressedRef.current = false;
      },
      ...underlayProps,
      ...props2
    }),
    [slots, state.isOpen, classNames, underlayProps]
  );
  useEffect(() => {
    if (state.isOpen && (domRef == null ? void 0 : domRef.current)) {
      return ariaHideOutside([domRef == null ? void 0 : domRef.current]);
    }
  }, [state.isOpen, domRef]);
  return {
    state,
    Component,
    children,
    classNames,
    showArrow,
    triggerRef,
    placement,
    isNonModal,
    popoverRef: domRef,
    portalContainer,
    isOpen: state.isOpen,
    onClose: state.close,
    disableAnimation,
    shouldBlockScroll,
    backdrop: (_c = originalProps.backdrop) != null ? _c : "transparent",
    motionProps,
    getBackdropProps,
    getPopoverProps,
    getTriggerProps,
    getDialogProps,
    getContentProps
  };
}

export {
  usePopover
};
