import * as _react_types_button from '@react-types/button';
import * as react from 'react';
import { Ref } from 'react';
import * as _heroui_system from '@heroui/system';
import { HTMLHeroUIProps, PropGetter } from '@heroui/system';
import { NumberInputVariantProps, SlotsToClasses, NumberInputSlots } from '@heroui/theme';
import { AriaNumberFieldProps } from '@react-types/numberfield';
import { NumberFieldStateOptions } from '@react-stately/numberfield';

interface Props extends Omit<HTMLHeroUIProps<"input">, keyof NumberInputVariantProps> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLInputElement>;
    /**
     * Ref to the container DOM node.
     */
    baseRef?: Ref<HTMLDivElement>;
    /**
     * Ref to the input wrapper DOM node.
     * This is the element that wraps the input label and the innerWrapper when the labelPlacement="inside"
     * and the input has start/end content.
     */
    wrapperRef?: Ref<HTMLDivElement>;
    /**
     * Ref to the input inner wrapper DOM node.
     * This is the element that wraps the input and the start/end content when passed.
     */
    innerWrapperRef?: Ref<HTMLDivElement>;
    /**
     * Element to be rendered in the left side of the input.
     */
    startContent?: React.ReactNode;
    /**
     * Element to be rendered in the right side of the input.
     * if you pass this prop and the `onClear` prop, the passed element
     * will have the clear button props and it will be rendered instead of the
     * default clear button.
     */
    endContent?: React.ReactNode;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Input classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    mainWrapper: "main-wrapper-classes",
     *    inputWrapper: "input-wrapper-classes",
     *    innerWrapper: "inner-wrapper-classes",
     *    input: "input-classes",
     *    clearButton: "clear-button-classes",
     *    helperWrapper: "helper-wrapper-classes",
     *    stepperWrapper: "stepper-wrapper-classes",
     *    description: "description-classes",
     *    errorMessage: "error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<NumberInputSlots>;
    /**
     * Whether to hide the increment and decrement buttons.
     */
    hideStepper?: boolean;
    /**
     * Callback fired when the value is cleared.
     * if you pass this prop, the clear button will be shown.
     */
    onClear?: () => void;
    /**
     * React aria onChange event.
     */
    onValueChange?: AriaNumberFieldProps["onChange"];
}
type UseNumberInputProps = Props & Omit<NumberFieldStateOptions, "locale"> & Omit<AriaNumberFieldProps, "onChange"> & NumberInputVariantProps;
declare function useNumberInput(originalProps: UseNumberInputProps): {
    Component: _heroui_system.As<any>;
    classNames: SlotsToClasses<"label" | "base" | "input" | "description" | "errorMessage" | "helperWrapper" | "mainWrapper" | "inputWrapper" | "innerWrapper" | "clearButton" | "stepperButton" | "stepperWrapper"> | undefined;
    domRef: react.RefObject<HTMLInputElement>;
    label: react.ReactNode;
    description: react.ReactNode;
    startContent: react.ReactNode;
    endContent: react.ReactNode;
    labelPlacement: "inside" | "outside" | "outside-left";
    isClearable: boolean | undefined;
    hasHelper: boolean;
    hasStartContent: boolean;
    isLabelOutside: boolean;
    isOutsideLeft: boolean;
    isLabelOutsideAsPlaceholder: boolean;
    shouldLabelBeOutside: boolean;
    shouldLabelBeInside: boolean;
    hasPlaceholder: boolean;
    isInvalid: boolean;
    errorMessage: react.ReactNode;
    hideStepper: boolean | undefined;
    incrementButtonProps: _react_types_button.AriaButtonProps<"button">;
    decrementButtonProps: _react_types_button.AriaButtonProps<"button">;
    getBaseProps: PropGetter;
    getLabelProps: PropGetter;
    getNumberInputProps: PropGetter;
    getHiddenNumberInputProps: PropGetter;
    getMainWrapperProps: PropGetter;
    getInputWrapperProps: PropGetter;
    getInnerWrapperProps: PropGetter;
    getHelperWrapperProps: PropGetter;
    getDescriptionProps: PropGetter;
    getErrorMessageProps: PropGetter;
    getClearButtonProps: PropGetter;
    getStepperIncreaseButtonProps: PropGetter;
    getStepperDecreaseButtonProps: PropGetter;
    getStepperWrapperProps: PropGetter;
};
type UseNumberInputReturn = ReturnType<typeof useNumberInput>;

export { type Props, type UseNumberInputProps, type UseNumberInputReturn, useNumberInput };
