"use client";
import {
  CalendarCell
} from "./chunk-6KIC4ELS.mjs";
import {
  useCalendarContext
} from "./chunk-PEV3D27N.mjs";
import {
  slideVariants
} from "./chunk-5CY7DCRB.mjs";

// src/calendar-month.tsx
import { endOfMonth, getWeeksInMonth } from "@internationalized/date";
import { useLocale } from "@react-aria/i18n";
import { useCalendarGrid } from "@react-aria/calendar";
import { m } from "framer-motion";
import { dataAttr, getInertValue } from "@heroui/shared-utils";
import { jsx, jsxs } from "react/jsx-runtime";
function CalendarMonth(props) {
  const { startDate, direction, currentMonth, firstDayOfWeek } = props;
  const { locale } = useLocale();
  const weeksInMonth = getWeeksInMonth(startDate, locale, firstDayOfWeek);
  const { state, slots, weekdayStyle, isHeaderExpanded, disableAnimation, classNames } = useCalendarContext();
  const { gridProps, headerProps, weekDays } = useCalendarGrid(
    {
      ...props,
      weekdayStyle,
      endDate: endOfMonth(startDate),
      firstDayOfWeek
    },
    state
  );
  const bodyContent = [...new Array(weeksInMonth).keys()].map((weekIndex) => /* @__PURE__ */ jsx(
    "tr",
    {
      className: slots == null ? void 0 : slots.gridBodyRow({ class: classNames == null ? void 0 : classNames.gridBodyRow }),
      "data-slot": "grid-body-row",
      inert: getInertValue(!!isHeaderExpanded),
      children: state.getDatesInWeek(weekIndex, startDate).map(
        (date, i) => date ? /* @__PURE__ */ jsx(
          CalendarCell,
          {
            classNames,
            currentMonth: startDate,
            date,
            firstDayOfWeek,
            isPickerVisible: isHeaderExpanded,
            slots,
            state
          },
          i
        ) : /* @__PURE__ */ jsx("td", {}, i)
      )
    },
    weekIndex
  ));
  return /* @__PURE__ */ jsxs(
    "table",
    {
      ...gridProps,
      "aria-hidden": dataAttr(isHeaderExpanded),
      className: slots == null ? void 0 : slots.grid({ class: classNames == null ? void 0 : classNames.grid }),
      "data-slot": "grid",
      tabIndex: -1,
      children: [
        /* @__PURE__ */ jsx(
          "thead",
          {
            ...headerProps,
            className: slots == null ? void 0 : slots.gridHeader({ class: classNames == null ? void 0 : classNames.gridHeader }),
            "data-slot": "grid-header",
            children: /* @__PURE__ */ jsx(
              "tr",
              {
                className: slots == null ? void 0 : slots.gridHeaderRow({ class: classNames == null ? void 0 : classNames.gridHeaderRow }),
                "data-slot": "grid-header-row",
                children: weekDays.map((day, index) => /* @__PURE__ */ jsx(
                  "th",
                  {
                    className: slots == null ? void 0 : slots.gridHeaderCell({ class: classNames == null ? void 0 : classNames.gridHeaderCell }),
                    "data-slot": "grid-header-cell",
                    children: /* @__PURE__ */ jsx("span", { children: day })
                  },
                  index
                ))
              }
            )
          }
        ),
        disableAnimation ? /* @__PURE__ */ jsx(
          "tbody",
          {
            className: slots == null ? void 0 : slots.gridBody({ class: classNames == null ? void 0 : classNames.gridBody }),
            "data-slot": "grid-body",
            tabIndex: isHeaderExpanded ? -1 : 0,
            children: bodyContent
          },
          currentMonth
        ) : /* @__PURE__ */ jsx(
          m.tbody,
          {
            animate: "center",
            className: slots == null ? void 0 : slots.gridBody({ class: classNames == null ? void 0 : classNames.gridBody }),
            custom: direction,
            "data-slot": "grid-body",
            exit: "exit",
            initial: "enter",
            variants: slideVariants,
            children: bodyContent
          },
          currentMonth
        )
      ]
    }
  );
}

export {
  CalendarMonth
};
