import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import { Ref } from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { SkeletonVariantProps, SlotsToClasses, SkeletonSlots } from '@heroui/theme';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: Ref<HTMLElement | null>;
    /**
     * The skeleton will be visible while isLoading is `false`.
     * @default false
     */
    isLoaded?: boolean;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Skeleton classNames={{
     *    base:"base-classes", // skeleton wrapper
     *    content: "content-classes", // children wrapper
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<SkeletonSlots>;
}
type UseSkeletonProps = Props & SkeletonVariantProps;
declare function useSkeleton(originalProps: UseSkeletonProps): {
    Component: _heroui_system.As<any>;
    children: react.ReactNode;
    slots: {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"base" | "content"> | undefined;
    getSkeletonProps: PropGetter;
    getContentProps: PropGetter;
};
type UseSkeletonReturn = ReturnType<typeof useSkeleton>;

export { type UseSkeletonProps, type UseSkeletonReturn, useSkeleton };
