"use client";
import {
  selectData
} from "./chunk-B2EYB6CA.mjs";

// src/hidden-select.tsx
import { useFormReset } from "@react-aria/utils";
import { useVisuallyHidden } from "@react-aria/visually-hidden";
import { useFormValidation } from "@react-aria/form";
import { jsx, jsxs } from "react/jsx-runtime";
function useHiddenSelect(props, state, triggerRef) {
  var _a;
  let data = selectData.get(state) || {};
  let {
    autoComplete,
    name = data.name,
    isDisabled = data.isDisabled,
    selectionMode,
    onChange,
    form
  } = props;
  let { validationBehavior, isRequired, isInvalid } = data;
  let { visuallyHiddenProps } = useVisuallyHidden();
  useFormReset(props.selectRef, state.selectedKeys, state.setSelectedKeys);
  useFormValidation(
    {
      validationBehavior,
      focus: () => {
        var _a2;
        return (_a2 = triggerRef.current) == null ? void 0 : _a2.focus();
      }
    },
    state,
    props.selectRef
  );
  return {
    containerProps: {
      ...visuallyHiddenProps,
      "aria-hidden": true,
      ["data-a11y-ignore"]: "aria-hidden-focus"
    },
    inputProps: {
      style: { display: "none" }
    },
    selectProps: {
      form,
      autoComplete,
      disabled: isDisabled,
      "aria-invalid": isInvalid || void 0,
      "aria-required": isRequired && validationBehavior === "aria" || void 0,
      required: isRequired && validationBehavior === "native",
      name,
      tabIndex: -1,
      value: selectionMode === "multiple" ? [...state.selectedKeys].map((k) => String(k)) : (_a = [...state.selectedKeys][0]) != null ? _a : "",
      multiple: selectionMode === "multiple",
      onChange: (e) => {
        state.setSelectedKeys(e.target.value);
        onChange == null ? void 0 : onChange(e);
      }
    }
  };
}
function HiddenSelect(props) {
  var _a;
  let { state, triggerRef, selectRef, label, name, isDisabled, form } = props;
  let { containerProps, selectProps } = useHiddenSelect({ ...props, selectRef }, state, triggerRef);
  if (state.collection.size <= 300) {
    return /* @__PURE__ */ jsx("div", { ...containerProps, "data-testid": "hidden-select-container", children: /* @__PURE__ */ jsxs("label", { children: [
      label,
      /* @__PURE__ */ jsxs("select", { ...selectProps, ref: selectRef, children: [
        /* @__PURE__ */ jsx("option", {}),
        [...state.collection.getKeys()].map((key) => {
          let item = state.collection.getItem(key);
          if ((item == null ? void 0 : item.type) === "item") {
            return /* @__PURE__ */ jsx("option", { value: item.key, children: item.textValue }, item.key);
          }
        })
      ] })
    ] }) });
  } else if (name) {
    return /* @__PURE__ */ jsx(
      "input",
      {
        autoComplete: selectProps.autoComplete,
        disabled: isDisabled,
        form,
        name,
        type: "hidden",
        value: (_a = [...state.selectedKeys].join(",")) != null ? _a : ""
      }
    );
  }
  return null;
}

export {
  useHiddenSelect,
  HiddenSelect
};
