import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _heroui_system from '@heroui/system';
import { PropGetter, HTMLHeroUIProps } from '@heroui/system';
import { ProgressVariantProps, SlotsToClasses, ProgressSlots } from '@heroui/theme';
import { AriaProgressBarProps } from '@react-types/progress';
import { ReactRef } from '@heroui/react-utils';

interface Props extends HTMLHeroUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * Whether to show the value label.
     * @default false
     */
    showValueLabel?: boolean;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Progress classNames={{
     *    base:"base-classes",
     *    labelWrapper: "labelWrapper-classes",
     *    label: "label-classes",
     *    value: "value-classes",
     *    track: "track-classes",
     *    indicator: "indicator-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<ProgressSlots>;
}
type UseProgressProps = Props & AriaProgressBarProps & ProgressVariantProps;
declare function useProgress(originalProps: UseProgressProps): {
    Component: _heroui_system.As<any>;
    domRef: react.RefObject<HTMLElement>;
    slots: {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        labelWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        value: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        track: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        indicator: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        label: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        labelWrapper: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        value: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        track: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
        indicator: (slotProps?: ({
            color?: "default" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            size?: "sm" | "md" | "lg" | undefined;
            disableAnimation?: boolean | undefined;
            radius?: "none" | "sm" | "md" | "lg" | "full" | undefined;
            isDisabled?: boolean | undefined;
            isStriped?: boolean | undefined;
            isIndeterminate?: boolean | undefined;
        } & tailwind_variants.ClassProp<tailwind_variants.ClassValue>) | undefined) => string;
    } & {};
    classNames: SlotsToClasses<"base" | "label" | "track" | "value" | "labelWrapper" | "indicator"> | undefined;
    label: react.ReactNode;
    percentage: number | undefined;
    showValueLabel: boolean;
    getProgressBarProps: PropGetter;
    getLabelProps: PropGetter;
};
type UseProgressReturn = ReturnType<typeof useProgress>;

export { type UseProgressProps, type UseProgressReturn, useProgress };
