"use client";
import {
  listbox_item_default
} from "./chunk-SDA7RI74.mjs";

// src/listbox-section.tsx
import { listboxSection } from "@heroui/theme";
import { useMemo } from "react";
import { forwardRef } from "@heroui/system";
import { mergeProps } from "@react-aria/utils";
import { clsx } from "@heroui/shared-utils";
import { Divider } from "@heroui/divider";
import { useListBoxSection } from "@react-aria/listbox";
import { jsx, jsxs } from "react/jsx-runtime";
var ListboxSection = forwardRef(
  ({
    item,
    state,
    as,
    variant,
    color,
    disableAnimation,
    className,
    classNames,
    hideSelectedIcon,
    showDivider = false,
    dividerProps = {},
    itemClasses,
    // removed title from props to avoid browsers showing a tooltip on hover
    // the title props is already inside the rendered prop
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    title,
    // removed items from props to avoid show in html element
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    items,
    ...otherProps
  }, _) => {
    const Component = as || "li";
    const slots = useMemo(() => listboxSection(), []);
    const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
    const dividerStyles = clsx(classNames == null ? void 0 : classNames.divider, dividerProps == null ? void 0 : dividerProps.className);
    const { itemProps, headingProps, groupProps } = useListBoxSection({
      heading: item.rendered,
      "aria-label": item["aria-label"]
    });
    return /* @__PURE__ */ jsxs(
      Component,
      {
        "data-slot": "base",
        ...mergeProps(itemProps, otherProps),
        className: slots.base({ class: baseStyles }),
        children: [
          item.rendered && /* @__PURE__ */ jsx(
            "span",
            {
              ...headingProps,
              className: slots.heading({ class: classNames == null ? void 0 : classNames.heading }),
              "data-slot": "heading",
              children: item.rendered
            }
          ),
          /* @__PURE__ */ jsxs(
            "ul",
            {
              ...groupProps,
              className: slots.group({ class: classNames == null ? void 0 : classNames.group }),
              "data-has-title": !!item.rendered,
              "data-slot": "group",
              children: [
                [...item.childNodes].map((node) => {
                  const { key: nodeKey, props: nodeProps } = node;
                  let listboxItem = /* @__PURE__ */ jsx(
                    listbox_item_default,
                    {
                      classNames: itemClasses,
                      color,
                      disableAnimation,
                      hideSelectedIcon,
                      item: node,
                      state,
                      variant,
                      ...nodeProps
                    },
                    nodeKey
                  );
                  if (node.wrapper) {
                    listboxItem = node.wrapper(listboxItem);
                  }
                  return listboxItem;
                }),
                showDivider && /* @__PURE__ */ jsx(
                  Divider,
                  {
                    as: "li",
                    className: slots.divider({
                      class: dividerStyles
                    }),
                    ...dividerProps
                  }
                )
              ]
            }
          )
        ]
      },
      item.key
    );
  }
);
ListboxSection.displayName = "HeroUI.ListboxSection";
var listbox_section_default = ListboxSection;

export {
  listbox_section_default
};
