type OverlayPlacement = "top" | "bottom" | "right" | "left" | "top-start" | "top-end" | "bottom-start" | "bottom-end" | "left-start" | "left-end" | "right-start" | "right-end";
interface OverlayOptions {
    /**
     * Whether the element should render an arrow.
     * @default false
     */
    showArrow?: boolean;
    /**
     * The additional offset applied along the main axis between the element and its
     * anchor element.
     * @default 7 (px) - if `showArrow` is true the default value is 10 (px)
     */
    offset?: number;
    /**
     * The additional offset applied along the cross axis between the element and its
     * anchor element.
     * @default 0
     */
    crossOffset?: number;
    /**
     * Whether the element should flip its orientation (e.g. top to bottom or left to right) when
     * there is insufficient room for it to render completely.
     * @default true
     */
    shouldFlip?: boolean;
    /**
     * The placement of the element with respect to its anchor element.
     * @default 'top'
     */
    placement?: OverlayPlacement;
    /**
     * The placement padding that should be applied between the element and its
     * surrounding container.
     * @default 12
     */
    containerPadding?: number;
    /** Handler that is called when the overlay should close. */
    onClose?: () => void;
}

export type { OverlayOptions, OverlayPlacement };
