<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>15 by Izhak Aktas - Compteur</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Nunito', sans-serif;
            font-weight: 300;
        }
        
        .flip-clock {
            position: relative;
            overflow: hidden;
            height: 100px;
            perspective: 400px;
        }
        
        .flip-unit {
            position: absolute;
            width: 100%;
            height: 50%;
            left: 0;
            backface-visibility: hidden;
            overflow: hidden;
            transform-style: preserve-3d;
        }
        
        .flip-top, .flip-bottom {
            position: absolute;
            width: 100%;
            height: 100%;
            left: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 60px;
            color: #333;
        }
        
        .flip-top {
            top: 0;
            transform-origin: 50% 100%;
            border-bottom: 1px solid rgba(0,0,0,0.1);
            border-radius: 10px 10px 0 0;
        }
        
        .flip-bottom {
            bottom: 0;
            transform-origin: 50% 0%;
            border-radius: 0 0 10px 10px;
        }
        
        .flip-top.flip {
            animation: flip-top 0.5s ease-in;
        }
        
        .flip-bottom.flip {
            animation: flip-bottom 0.5s ease-out;
        }
        
        @keyframes flip-top {
            0% {
                transform: rotateX(0deg);
            }
            100% {
                transform: rotateX(-90deg);
            }
        }
        
        @keyframes flip-bottom {
            0% {
                transform: rotateX(90deg);
            }
            100% {
                transform: rotateX(0deg);
            }
        }
    </style>
</head>
<body class="bg-white min-h-screen flex items-center justify-center">
    <?php
    $eventDate = strtotime('2025-03-17 00:00:00');
    $currentDate = time();
    $remainingSeconds = $eventDate - $currentDate;
    
    $days = floor($remainingSeconds / 86400);
    $hours = floor(($remainingSeconds % 86400) / 3600);
    $minutes = floor(($remainingSeconds % 3600) / 60);
    $seconds = $remainingSeconds % 60;
    
    $values = [
        'days' => $days,
        'hours' => $hours,
        'minutes' => $minutes,
        'seconds' => $seconds
    ];
    ?>

    <div class="text-center">
        <h1 class="text-4xl mb-12">15 by Izhak Aktas</h1>
        
        <div class="flex justify-center items-center space-x-8">
            <?php foreach ($values as $key => $value): ?>
                <div class="flex flex-col items-center">
                    <div class="w-24 h-24 bg-gray-50 rounded-lg shadow-md overflow-hidden" data-unit="<?php echo $key; ?>">
                        <div class="flip-clock">
                            <div class="flip-unit flip-top">
                                <div class="flip-top"><?php echo str_pad($value, 2, '0', STR_PAD_LEFT); ?></div>
                            </div>
                            <div class="flip-unit flip-bottom">
                                <div class="flip-bottom"><?php echo str_pad($value, 2, '0', STR_PAD_LEFT); ?></div>
                            </div>
                        </div>
                    </div>
                    <span class="text-sm mt-2"><?php echo ucfirst($key); ?></span>
                </div>
            <?php endforeach; ?>
        </div>
        
        <p class="mt-12 text-gray-500">L'événement commence le 17 Mars 2025</p>
    </div>

    <script>
    function updateCountdown() {
        const eventDate = new Date('March 17, 2025 00:00:00').getTime();
        const units = ['days', 'hours', 'minutes', 'seconds'];
        let currentValues = {};
        
        units.forEach(unit => {
            const element = document.querySelector(`[data-unit="${unit}"]`);
            currentValues[unit] = parseInt(element.querySelector('.flip-top').textContent);
        });
        
        const updateTimer = () => {
            const now = new Date().getTime();
            const distance = eventDate - now;
            
            if (distance < 0) {
                clearInterval(interval);
                document.querySelector('.mt-12').textContent = "L'événement a commencé !";
                return;
            }
            
            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);
            
            const newValues = {
                days: days,
                hours: hours,
                minutes: minutes,
                seconds: seconds
            };
            
            units.forEach(unit => {
                if (currentValues[unit] !== newValues[unit]) {
                    flipUnit(unit, newValues[unit]);
                    currentValues[unit] = newValues[unit];
                }
            });
        };
        
        const flipUnit = (unit, newValue) => {
            const element = document.querySelector(`[data-unit="${unit}"]`);
            const topFlip = element.querySelector('.flip-top');
            const bottomFlip = element.querySelector('.flip-bottom');
            
            // Format the number with leading zeros
            const formattedValue = String(newValue).padStart(2, '0');
            
            // Update the displayed value
            topFlip.textContent = formattedValue;
            bottomFlip.textContent = formattedValue;
            
            // Trigger the animation
            topFlip.classList.add('flip');
            bottomFlip.classList.add('flip');
            
            // Remove the animation class after it's done
            setTimeout(() => {
                topFlip.classList.remove('flip');
                bottomFlip.classList.remove('flip');
            }, 500);
        };
        
        updateTimer();
        const interval = setInterval(updateTimer, 1000);
    }
    
    document.addEventListener('DOMContentLoaded', updateCountdown);
    </script>
</body>
</html>